/* pkcrack - zipdecrypt.c
 *
 * (C) by Peter Conrad <conrad@unix-ag.uni-kl.de>
 *
 * $Id: zipdecrypt.c,v 1.6 1996/08/21 17:58:38 conrad Release1_2 $
 *
 * $Log: zipdecrypt.c,v $
 * Revision 1.6  1996/08/21 17:58:38  conrad
 * Some cleanups to suppress some warnings...
 *
 * Revision 1.5  1996/08/21 17:40:12  conrad
 * Major changes:
 *  - detached ZIP-decryption from main(), so the function can be included
 *    into pkcrack
 *  - rely on readhead.c/writehead.c instead of our own buffers
 *
 * Revision 1.4  1996/08/13 13:33:06  conrad
 * now supporting longer filenames instead of 8+'.'+3
 *
 * Revision 1.3  1996/06/12 09:47:30  conrad
 * Release version
 *
 * Revision 1.2  1996/06/11 20:09:00  conrad
 * improved version. Now handles the central directory correctly
 * (hopefully).
 *
 * Revision 1.1  1996/06/11 10:24:29  conrad
 * Initial revision
 *
 */

static char RCSID[]="$Id: zipdecrypt.c,v 1.6 1996/08/21 17:58:38 conrad Release1_2 $";

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include "crc.h"
#include "pkcrack.h"
#include "keystuff.h"
#include "headers.h"

extern int	read_sig( FILE *fp );
extern int	read_local( FILE *fp, char *fname, int noskip );
extern int	read_dir( FILE *fp, int noskip );
extern int	read_end( FILE *fp, int noskip );
extern int	write_sig( FILE *fp, int type );
extern int	write_local( FILE *fp, local *lh );
extern int	write_dir( FILE *fp, dirtype *dir );
extern int	write_end( FILE *fp, enddirtype *end );

#ifndef O_BINARY
#define	O_BINARY	0
#endif

#define	MIN(a,b)	(((a)<(b))?(a):(b))

#define	NUMOFFSETS	100

static uword	offset=0, dirOffset=0;

static struct file {
    char	*name;
    uword	relOffset;
} offsets[NUMOFFSETS];

static int	numOffsets=0;
static byte	buffer[1024];

static int copy( FILE *outf, FILE *inf, int len, int decrypt )
{
int	i, j, finished=0;
byte	p;

    len += 12*decrypt;

    i = fread( buffer, 1, MIN(1024,len), inf );
    if( i < MIN(1024,len) )
    {
	fprintf( stderr, "File too short. Aborting...\n" );
	finished = 1;
    }

    j = 0;
    if( decrypt )
	for( ; j < 12; j++ )
	    p = cUpdateKeys( buffer[j] );

    while( len > 0 )
    {
	if( decrypt )
	    for( i = 0; i+j < MIN(1024,len); i++ )
		buffer[i+j] = cUpdateKeys( buffer[i+j] );
	fwrite( &buffer[j], 1, MIN(1024,len)-j, outf );
	offset += MIN(1024,len)-j;
	len -= MIN(1024,len);
	if( len > 0 )
	{
	    i = fread( buffer, 1, MIN(1024,len), inf );
	    if( i < MIN(1024,len) )
	    {
		fprintf( stderr, "File too short. Aborting...\n" );
		finished = 1;
	    }
	    j = 0;
	}
    }

    return finished;
}

int zipdecrypt( char *inname, char *outname, uword k0, uword k1, uword k2 )
{
int	i, finished=0, decrypt=0, err=0;
FILE	*infile, *outfile;

    infile = fopen( inname, "rb" );
    if( !infile )
    {
	fprintf( stderr, "ZipDecrypt: can't open input file %s!\n", inname );
	return 0;
    }
    outfile = fopen( outname, "wb" );
    if( !outfile )
    {
	fprintf( stderr, "ZipDecrypt: can't open output file %s!\n", outname );
	fclose( infile );
	return 0;
    }

    do{
	err = read_sig(infile);
	switch( err )
	{
	  case LOCAL:
	    offsets[numOffsets].relOffset = offset;
	    err = !write_sig(outfile, LOCAL);
	    offset += 4;
	    if( !err ) err = (read_local(infile,"",1)<0);
	    decrypt = lh.gpb[0]&1;
	    if( decrypt )
	    {
		lh.gpb[0] &= 0xfe;
		lh.csize -= 12;
		key0 = k0;
		key1 = k1;
		key2 = k2;
	    }
	    if( !err ) err = !write_local(outfile, &lh);
	    offset += 26+lh.flen;
	    if( !err && lh.extralen > 0 ) err = copy(outfile, infile, lh.extralen, 0);
	    offsets[numOffsets].name = malloc( lh.flen+1 );
	    memcpy( offsets[numOffsets].name, filename, lh.flen+1 );
	    numOffsets++;
	    if( !err )
		err = copy( outfile, infile, lh.csize, decrypt );
	    break;
	  case DIR:
	    if( !dirOffset )
		dirOffset = offset;
	    err = !write_sig(outfile, DIR);
	    offset += 4;
	    if( !err ) err = (read_dir(infile,1)<0);
	    if( dir.gpb[0]&1 )
	    {
		dir.gpb[0] &= 0xfe;
		dir.csize -= 12;
	    }
	    for( i = 0; !err && i < numOffsets && strcmp( offsets[i].name, filename ); i++ );
	    if( i >= numOffsets )
	    {
		fprintf( stderr, "Central directory contains unknown filename: %s\n", filename );
		err = 1;
	    }
	    else
		dir.locoffset = offsets[i].relOffset;
	    if( !err ) err = !write_dir( outfile, &dir );
	    offset += 42 + dir.flen;
	    if( !err && dir.extralen > 0 ) err = copy(outfile, infile, dir.extralen, 0);
	    if( !err && dir.commlen > 0 ) err = copy(outfile, infile, dir.commlen, 0);
	    break;
	  case END:
	    err = !write_sig(outfile, END);
	    offset += 4;
	    if( !err ) err = (read_end(infile,1)<0);
	    enddir.centroffset = dirOffset;
	    if( !err ) err = !write_end( outfile, &enddir );
	    offset += 18;
	    if( !err && enddir.commlen > 0 ) err = copy(outfile, infile, enddir.commlen, 0);
	    finished = 1;
	    break;
	  default:
	    fprintf( stderr, "Error: unknown signature (ZIP file may be corrupt)\n");
	    fclose( infile );
	    fclose( outfile );
	    return 0;
	    break;
	}
    }while( !finished && !err );

    fclose( infile );
    fclose( outfile );

    return 1;
}

