/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)passwd.C	1.10 95/11/21 Sun Microsystems"

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "asn1_der.h"
#include "ObjId.h"
#include "Name.h"
#include "X509Cert.h"
#include "Sig.h"
#include "Passwd.h"

Bstream
passwd_decrypt(const Bstream& passwd, const Bstream& input,
		const ObjId& md_oid, String& errormsg)
{
	Bstream temp, nullbstr;

	if (cbc_decrypt((const char *)passwd.getdatap(), input, md_oid,
			&temp) < 0) {
		errormsg = "Error decrypting data with given passwd.\n";
		return (nullbstr);
	}
	return (temp);
}

Bstream
passwd_encrypt(const Bstream& passwd, const Bstream& input,
		const ObjId& md_oid, String& errormsg)
{
	Bstream temp, nullbstr;

	if (cbc_encrypt((const char *)passwd.getdatap(), input, md_oid,
			&temp) < 0) {
		errormsg = "Error encrypting data with given passwd.\n";
		return (nullbstr);
	}
	return (temp);
}

char *getpass_str(const char *prompt)
{
        static char pass[255];

        system("stty -echo");
        fprintf(stderr, "%s", prompt);
        fgets(pass, 255, stdin);
        system("stty echo");
        fprintf(stderr, "\n");
	// now remove the new-line if there is one !
	int len = strlen(pass);
	if (pass[len - 1] == '\n')
		pass[len - 1] = '\0';
       	return (pass);
}

/*
 * Get a typed in password from the user.  Check twice to be confident it's
 * right.
 */
char *
passwd_confident(const char *prompt)
{
	char *p;
	char passwd[255];
  
	while (1) {
		if ((p = getpass_str(prompt))) {
			strcpy(passwd, p);
			if ((p = getpass_str("again: "))) {
				if (strcmp(passwd, p) == 0)
					return (p);
			}
			fprintf(stderr,
				"Different passwords entered.  Try again\n");
		}
	}
}
