/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)simplecrypt.c	1.13 95/11/15 Sun Microsystems"

#ifdef SYSV
#include <skip_sysv.h>
#endif

#ifdef SUNOS
#include <skip_sunos.h>
#endif

#if !defined(SYSV) && !defined(SUNOS)
#include <skip_os.h>
#endif

#include <bdcmod.h>
#include <skip_crypt.h>
#include <skip_proto.h>

/*
 * simplecrypt encryptor/decryptor module
 *
 */
#define MODULE_NAME		"simplecrypt"

char				simplecrypt_name[] = 	MODULE_NAME " V1.13";

static void *			simple_open(	char *,
						unsigned int,
						char *,
						unsigned int
				);
static void			simple_close(	void *
				);
static void			simple_encrypt(	void *,
						char *,
						unsigned int *,
						char *,
						char *,
						unsigned int,
						unsigned char *
				);
static void			simple_decrypt(	void *,
						char *,
						unsigned int *,
						char *,
						char *,
						unsigned int,
						unsigned char *
				);
static unsigned int		simple_outlen(	unsigned int
				);

#ifdef DEBUG
int				simplecrypt_busy = 0;
static int			simplecrypt_debug = 1;
#else
int				simplecrypt_busy = 1;
static int			simplecrypt_debug = 0;
#endif


/*
 * module number - this is used to identify the module in the protocol
 */
const unsigned int	simplecrypt_id = 10;

/*
 * simplecrypt_v1/SunScreen entry point
 */
const skip_cryptor_t		simplecrypt_module_v1 = {
	MODULE_NAME,		/* name */
	simple_open,		/* open */
	simple_close,		/* close */
	simple_encrypt,		/* encrypt */
	simple_decrypt,		/* decrypt */
	simple_outlen,		/* getoutputlen */
	8,			/* kp_len */
	8,			/* ekp_len */
	8,			/* mid_len */
	0,			/* flags */
	SKIP_SIMPLECRYPT,	/* Kij algorithm ID */ 
	SKIP_SIMPLECRYPT	/* Kp algorithm Id */ 
};

/*
 * simplecrypt/ESP entry point (same code!)
 */
const skip_cryptor_t		simplecrypt_module = {
	MODULE_NAME,		/* name */
	simple_open,		/* open */
	simple_close,		/* close */
	simple_encrypt,		/* encrypt */
	simple_decrypt,		/* decrypt */
	simple_outlen,		/* getoutputlen */
	8,			/* kp_len */
	8,			/* ekp_len */
	8,			/* mid_len */
	0,			/* flags */
	SKIP_KIJ_SIMPLECRYPT,	/* Kij algorithm ID */ 
	SKIP_CRYPT_SIMPLECRYPT	/* Kp algorithm Id */ 
};

/*
 * simplecrypt cipher state (holds the key)
 */
typedef struct {
	unsigned int	len;
	char		*buf;
} simplecrypt_t;


/* simple_open()
 *
 * simplecrypt open entry point
 */
static void *
simple_open(char *key, unsigned int keylen, char *iv, unsigned int ivlen)
{
	register int 		k;
	register simplecrypt_t	*keyp;

	simplecrypt_busy++;

	if (keylen == 0) {
		simplecrypt_busy--;
		return (NULL);
	}

	keyp = (simplecrypt_t *) MEM_ALLOC(sizeof (*keyp));

	if (keyp == NULL) {
		simplecrypt_busy--;
		return (NULL);
	}

	keyp->buf = (char *) MEM_ALLOC(keylen);
	if (keyp->buf == NULL) {
		simplecrypt_busy--;
		MEM_FREE(keyp, sizeof (*keyp));
		return (NULL);
	}

	keyp->len = keylen;
	BCOPY(key, keyp->buf, keylen);
	if (simplecrypt_debug) {
		printf("simple_open: keylen = %d, ivlen = %d, "
			"cs is %x\n", keylen, ivlen, keyp);
		printf("kp = ");
		for (k = 0; k < keylen; k++) {
			printf("%x ", (unsigned char) key[k]);
		}
		printf("\n");
	}
	return ((void *) keyp);
}

/* simple_close()
 *
 * simplecrypt close entry point
 */
static void
simple_close(void * cs)
{
	register simplecrypt_t	*keyp = cs;

	if (simplecrypt_debug) {
		printf("simple_close: closing cs %x\n", cs);
	}
	MEM_FREE(keyp->buf, keyp->len);
	MEM_FREE(keyp, sizeof (simplecrypt_t));
	simplecrypt_busy--;
}

/* simple_encrypt()
 *
 * encrypt entry point
 */
static void
simple_encrypt(void *cs, char *in, unsigned int *len, char *out,
		char *midbuf, unsigned int midlen, unsigned char *payload_type)
{
	register int	i;
	simplecrypt_t	*keyp = cs;
	register char	*c;
	register char	*s = keyp->buf;
	register char	*e = keyp->buf + keyp->len;

	/*
	 * exclusive-or the key over the buffer
	 */
	for (i = 0, c = s; i < *len; i++) {
		out[i] = in[i] ^ *c++;
		if (c == e) {
			c = s;
		}
	}
}

/* simple_decrypt()
 *
 * decrypt entry point
 */
static void
simple_decrypt(void *cs, char *in, unsigned int *len, char *out,
		char *midbuf, unsigned int midlen, unsigned char *payload_type)
{
	register int	i;
	simplecrypt_t	*keyp = cs;
	register char	*c;
	register char	*s = keyp->buf;
	register char	*e = keyp->buf + keyp->len;

	/*
	 * exclusive-or the key over the buffer
	 */
	for (i = 0, c = s; i < *len; i++) {
		out[i] = in[i] ^ *c++;
		if (c == e) {
			c = s;
		}
	}
}

/*
 * getoutputlen entry point
 */
static unsigned int
simple_outlen(unsigned int insize)
{
	return (insize);
}
