/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_crypt.c	1.9 95/11/21 Sun Microsystems"

/*
 * System includes
 */
#ifdef SYSV
#include <skip_sysv.h>
#endif
#ifdef SUNOS
#include <skip_sunos.h>
#endif
#if !defined(SYSV) && !defined(SUNOS)
#include <skip_os.h>
#endif

/*
 * SKIP includes
 */
#include <bdcmod.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_crypt.h>
#include <skip_key.h>

/*
 * table of cryptors and associated statistics
 */
const int		skip_max_cryptors = SKIP_MAXCRYPTORS;
skip_cryptor_t		skip_cryptors[SKIP_MAXCRYPTORS];
skip_cryptor_t		skip_cryptors_v1[SKIP_MAXCRYPTORS];

/*
 * static functions prototypes
 */
static void * skip_err_open(caddr_t , unsigned int , caddr_t , unsigned int );
static void skip_err_close(void *);
static void skip_err_logger(void *, caddr_t , unsigned int *, caddr_t ,
	caddr_t , unsigned int, unsigned char *);
static unsigned int skip_err_outlen(unsigned int);

/* skip_key_initcryptors()
 * 
 * initalise the crypto system
 *
 * Returns: none
 */
void
skip_key_initcryptors()
{
	register int	i;
	skip_cryptor_t	*cp;

	/*
	 * initialise the table of crypt modules to be empty
	 */
	bzero((caddr_t) skip_cryptors, sizeof skip_cryptors);
	cp = &skip_cryptors[0];
	for (i = 0; i < SKIP_MAXCRYPTORS; i++) {
		cp->name		= CRYPT_NOT_PRESENT;
		cp->open		= skip_err_open;
		cp->close		= skip_err_close;
		cp->encrypt		= skip_err_logger;
		cp->decrypt		= skip_err_logger;
		cp->getoutputlen	= skip_err_outlen;
		cp->ekp_len		= -1;
		cp->mid_len		= -1;
		cp++;
	}

	bzero((caddr_t) skip_cryptors_v1, sizeof skip_cryptors);
	cp = &skip_cryptors_v1[0];
	for (i = 0; i < SKIP_MAXCRYPTORS; i++) {
		cp->name		= CRYPT_NOT_PRESENT;
		cp->open		= skip_err_open;
		cp->close		= skip_err_close;
		cp->encrypt		= skip_err_logger;
		cp->decrypt		= skip_err_logger;
		cp->getoutputlen	= skip_err_outlen;
		cp->ekp_len		= -1;
		cp->mid_len		= -1;
		cp++;
	}
}

/* skip_key_uninitcryptors()
 * 
 * uninitalise the crypto system for unload
 *
 * Returns: none
 */
void
skip_key_uninitcryptors()
{
	bzero((caddr_t) skip_cryptors, sizeof skip_cryptors);
	bzero((caddr_t) skip_cryptors_v1, sizeof skip_cryptors_v1);
}

/* skip_install_cryptmod()
 *
 * install a new crypt module in the V1 table
 *
 * Returns: 0 on success, non-zero otherwise
 */
int
skip_install_cryptmod(const skip_cryptor_t *this_module,
			unsigned int module_id,
			unsigned char version)
{
	skip_cryptor_t	*cp;


	if (module_id >= SKIP_MAXCRYPTORS) {
		skip_log1(
		"skip_install_cryptmod: bad module id (%d)", module_id);
		return (-1);
	}

	if (version == SKIP_V2) {
		cp = &skip_cryptors[module_id];
	} else {
		cp = &skip_cryptors_v1[module_id];
	}

	if (cp->encrypt != skip_err_logger) {
		skip_log2(
		"skip_install_cryptmod: %s already present as module %d\n",
		this_module->name, module_id);
		return (-1);
	}

	BCOPY((caddr_t) this_module, (caddr_t) cp, sizeof(skip_cryptor_t));

	SKIP_DEBUG2("skip_install_cryptmod: %s installed as module %d\n",
					this_module->name, module_id);
	return (0);
}

/* skip_remove_cryptmod()
 *
 * remove a crypt module from the V1 table
 *
 * Returns: none
 */
void
skip_remove_cryptmod(unsigned int module_id, unsigned char version)
{
	skip_cryptor_t	*cp;


	if (module_id >= SKIP_MAXCRYPTORS) {
		skip_log1(
		"skip_remove_cryptmod: bad module id (%d)", module_id);
		return;
	}

	if (version == SKIP_V2) {
		cp = &skip_cryptors[module_id];
	} else {
		cp = &skip_cryptors_v1[module_id];
	}

	if (cp->encrypt == skip_err_logger) {
		skip_log1(
		"skip_remove_cryptmod: module %d not present", module_id);
		return;
	}
	SKIP_DEBUG1("skip_remove_cryptmod: %s module removed\n",
						cp->name);

	cp->name		= CRYPT_NOT_PRESENT;
	cp->open		= skip_err_open;
	cp->close		= skip_err_close;
	cp->encrypt		= skip_err_logger;
	cp->decrypt		= skip_err_logger;
	cp->getoutputlen	= skip_err_outlen;
	cp->ekp_len		= -1;
	cp->mid_len		= -1;
	cp->encrypts		= 0;
	cp->encrypterrs 	= 0;
	cp->decrypts 		= 0;
	cp->decrypterrs 	= 0;

}

/* skip_err_open()
 *
 * open error logger - called when a crypt module is not present
 *
 * Returns: NULL
 */
/*ARGSUSED*/
static void *
skip_err_open(caddr_t key, unsigned int keylen, caddr_t iv, unsigned int ivlen)
{
	skip_log("skip_err_open: encryption algorithm not present");
	return (NULL);
}

/* skip_err_close()
 *
 * close error logger - called when a crypt module is not present
 *
 * Returns: none
 */
/*ARGSUSED*/
static void
skip_err_close(void *cs)
{
	skip_log("skip_err_close: encryption algorithm not present");
}

/* skip_err_logger()
 *
 * encrypt/decrypt error logger - called when a crypt module is not present
 *
 * Returns: none
 */
static void
skip_err_logger(void *cs, caddr_t in, unsigned int *len, caddr_t out,
	caddr_t midbuf, unsigned int midlen, unsigned char *payload_type)
{
	static int	logged = 0;

	if (logged % 1000 == 0) {
		skip_log("skip_err_logger: encryption algorithm not present");
	}
	logged++;
	*len = 0;
}

/* skip_err_outlen()
 *
 * dummy output length handler - called when a crypt module is not present
 *
 * Returns: 0
 */
static unsigned int
skip_err_outlen(unsigned int msize)
{
	return (0);
}

