/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_fetchcert.C	1.8 95/11/22"
 
#include<sys/time.h>
#include <sys/wait.h>
#ifdef SYSV
#include <sys/select.h>
#endif
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <time.h>
 
#include "Time.h"
#include "Bigint.h"
#include "Bstream.h"
#include "ObjId.h"
#include "Name.h"
#include "SkipCert.h"
#include "X509Cert.h"
#include "X509skip.h"
#include "malloc.h"
#include "utils.h"
#include "Sig.h"
 
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#ifdef RW
#include <rw/tvslist.h>
#else
#ifdef LIBG
#include <SLList.h>
#include <DLList.h>
#endif
#endif
#include <iostream.h>
#include <ctype.h>

#include "skip_proto.h"
#include <skip_certbase.h>
#include "skip_conf.h"
#include "skip_fetchcert.h"
#include "skip_log.h"
#include "skip_keymgr.h"

/*
** Skip Certificate fetching:
** If I need alice's certificate, I fork certicate fetcher.  The certificate
** fetcher goes through each of the lookup lines in the SKIP_CONF file 
** and tries to get the certificate in that manner.  If it fails, it moves 
** to the next one.
**
** When the certificate is found, it is written to a pipe which the keymgrd
** is selecting and the certificate is returned.  If all mechanisms fail,
** it will currently return the nullstr.
**
** The skip_keymgrd reads the SKIP_CONF file when it starts.   Each line of
** lookup in SKIP_CONF is allocated one unit class work.  A unit of work 
** is everything needed to do a lookup.  The lookup may be a DNS lookup,
** a ping, or a directory lookup.  So, If I want to find Alice's certificate,
** I call get_cert, it forks and walks through each unit of work until it
** finds a match.
**
** Needs TBD:
**	1. Decide when to count out the site for good and send back the null
**	   certificate.
*/

static int nresolvers=0;
extern Bstream CA_X509_Cert;

struct resolver {
	int id;
	Bstream (*resolve)(struct in_addr *, struct remote_info *);
	struct in_addr server;
};

struct cert_req {
	struct remote_info host;
	void *msg;
};

static int add_cdp_resolver(char *); 
void scheduler(cert_req&);
#ifdef RW
RWTValSlist<cert_req> reqs;
RWTValSlist<resolver> resolver_list;
#else
DLList<cert_req> reqs;
SLList<resolver> resolver_list;
#endif

void get_certificate(int fd, struct remote_info *keyid, void *msg)
{
	void *save_msg;
	Bstream box;

	box=keyid->keyid;
#ifdef RW
	int i;
	RWTValSlistIterator<cert_req> iterator(reqs);

	for (i=iterator(); i==TRUE; i=iterator+=1) {
		if (iterator.key().host.keyid== box)
			return;
	}
#else
#ifdef LIBG
	for (Pix i=reqs.first(); i != 0; reqs.next(i)) 
		if (reqs(i).host.keyid==box)
			return;
#endif
#endif
	struct cert_req r;
	int size;
	int pid;
	size=skip_alloc_size(msg);
	save_msg=(void *)malloc(size);
	bcopy(msg, save_msg, size);
	r.host.keyid=box;
	r.host.ip_addr=keyid->ip_addr;
	r.msg=save_msg;
	pid = fork();
	if (pid) {
#ifdef RW
		reqs.insert(r);
#else
#ifdef LIBG
		reqs.append(r);
#endif
#endif
		return;
	}
	String temp;
	temp=box.gethexstr();
	skip_log(SKIP_NOTICE, "Received request for keyid %s. Dispatching...",(const char *)temp);
	scheduler(r);
	exit(0);
}

Bstream cdp_fetch(struct in_addr *ds, struct remote_info *r)
{
	SkipCert *cert;
	Bstream certstr;
	int status;

	if (ds->s_addr != 0) 
		r->ip_addr=*ds;
	status=cdp_get_cert(&r->ip_addr, 1, r->keyid, &cert);
	certstr=cert->encode();
	delete cert;
	return certstr;
}

void scheduler(cert_req& c)
{
	Bstream result;
	Bstream nullstr;
	Bstream (*func)(u_long,u_long);
	resolver r;
#ifdef RW
	RWTValSlistIterator<resolver> iterator(resolver_list);

	for (int i=iterator(); i==TRUE; i=iterator+=1) {
		r=iterator.key();
#else
#ifdef LIBG
	for (Pix i=resolver_list.first(); i!=0; resolver_list.next(i)) {
		r=resolver_list(i);
#endif
#endif
#ifdef DEBUG
		fprintf(stderr,"Calling resolver function with %x %x\n",c.keyid,r.server.s_addr);
#endif
		result=(r.resolve)(&r.server, &c.host);
		if (result!=nullstr) {
			int fd;
			skip_send_cert_reply(result);
			return;
		}
	}
	return;
}

void
flush_resolvers() 
{
	reqs.clear();
	resolver_list.clear();
}
	
int 
add_resolver(int proto, char *arg)
{
	u_long parm;
	switch (proto) {
		case RESOLVE_PING:
			return add_cdp_resolver(arg);
		default:
			skip_log(SKIP_ERROR, "Unsupported resolver");
			break;
	}
	return 0;
}

static int add_cdp_resolver(char *arg) 
{
	resolver r;
	r.id=nresolvers;
	r.resolve=cdp_fetch;
	if (arg == NULL) 
		r.server.s_addr=0;
	else {
		
		if (isdigit(*arg)) 
			r.server.s_addr=ntohl(inet_addr(arg)); /* XXX */
		else {
			struct hostent *h;
			char **q;

			h=gethostbyname(arg);
			if (h==NULL) {
				skip_log(SKIP_ERROR,"Host lookup of %s failed", arg);
				return 0;
			}
			q=h->h_addr_list;
			bcopy(*q,&r.server,h->h_length);
			r.server.s_addr=htonl(r.server.s_addr);
		} /* else isdigit */
	}  
#ifdef RW
	resolver_list.insert(r);	/* XXX check this result */
#else
#ifdef LIBG
	resolver_list.append(r);	/* XXX check this result */
#endif
#endif
	nresolvers++;
	return 1;			/* XXX only return true */
}

void skip_fetch_rsp( int keyfd, Bstream &certstr)
{
	struct cert_req temp;
	X509SkipCert cert;
	Bstream tempstr;
	int n;
	int retval;

	tempstr=certstr;
	if (cert.decode(certstr)){
		skip_log(SKIP_NOTICE,"Warning: Unable to decode fetched cert");
	}
	if (!cert.isValid(CA_X509_Cert)){
		skip_log(SKIP_NOTICE,"Warning: Unable to decode fetched cert");
	}
	Bstream keyid=cert.skip_name();

#ifdef RW
	RWTValSlistIterator<cert_req> iterator(reqs);
#endif

#ifdef RW
	for (n=iterator(); n==TRUE; n=iterator+=1) {
		temp=iterator.key();
#else
#ifdef LIBG
	for (Pix i=reqs.first(); i!=0; reqs.next(i) ) {
		temp=reqs(i);
#endif
#endif
		if (temp.host.keyid == keyid ) {
			n=skip_add_cert(certstr, SKIP_NSID_IPV4,SKIP_CERT_X509);
			if (n) 
				fprintf(stderr,"trouble Adding Certificiate to Database=%d\n",n);
			else {
				void *new_msg;
				int size;
				new_msg=(void *)malloc(MGTCSIZE);
				skip_log(SKIP_NOTICE, "Received response");
				make_response(temp.msg,new_msg,&size, &temp.host);
				put_skip_msg(keyfd, new_msg, size);
				free((char *)new_msg);
			}
#if 0
#ifdef RW

//			reqs.remove(temp);
#else
#ifdef LIBG
			for (Pix i=reqs.first(); i!=0; reqs.next(i)){
				if (reqs(i) == temp){
					reqs.del(i);
					break;
				}
			}
#endif  /* LIBG */
#endif	/* RW */
#endif
			free((char *)temp.msg);
		}
	}
}
