/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/


#pragma ident "@(#)skiptool_stubs.c	1.4 95/11/22 Sun Microsystems"

/*
 * skiptool_stubs.c - Notify and event callback function stubs.
 * This file was generated by `gxv' from `skiptool.G'.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/panel.h>
#include <xview/textsw.h>
#include <xview/xv_xrect.h>
#include "skiptool_ui.h"


/*
 * Global object definitions.
 */
skiptool_base_window_objects	*Skiptool_base_window;
skiptool_hostwin_objects	*Skiptool_hostwin;
skiptool_key_params_win_objects	*Skiptool_key_params_win;
skiptool_required_win_objects	*Skiptool_required_win;
skiptool_about_win_objects	*Skiptool_about_win;

#ifdef MAIN

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;

main(int argc, char **argv)
{
	/*
	 * Initialize XView.
	 */
	xv_init(XV_INIT_ARGC_PTR_ARGV, &argc, argv, NULL);
	INSTANCE = xv_unique_key();
	
	/*
	 * Initialize user interface components.
	 * Do NOT edit the object initializations by hand.
	 */
	Skiptool_base_window = skiptool_base_window_objects_initialize(NULL, NULL);
	Skiptool_hostwin = skiptool_hostwin_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_key_params_win = skiptool_key_params_win_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_required_win = skiptool_required_win_objects_initialize(NULL, Skiptool_base_window->base_window);
	Skiptool_about_win = skiptool_about_win_objects_initialize(NULL, Skiptool_base_window->base_window);
	
	
	init(argc, argv);

	/*
	 * Turn control over to XView.
	 */
	xv_main_loop(Skiptool_base_window->base_window);
	exit(0);
}

#endif


/*
 * Menu handler for `menu (Key Management...)'.
 */
Menu_item
skiptool_menu_item0_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_key_params_win->key_params_win, XV_SHOW, TRUE, NULL);
		
		{
get_key_params();

		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `access_ctrl'.
 */
void
skiptool_base_window_access_ctrl_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
access_update();
	}
	
	if (value == 1)
	{
access_update();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `access_mode'.
 */
void
skiptool_base_window_access_mode_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	if (value == 0)
	{
access_update();
	}
	
	if (value == 1)
	{
access_update();
	}
	
	if (value == 2)
	{
access_update();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `hostlist'.
 */
int
systems_list_notify(Panel_item item, char *string, Xv_opaque client_data, Panel_list_op op, Event *event, int row)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch(op) {
	case PANEL_LIST_OP_DESELECT:
		editor(1, row);
		break;

	case PANEL_LIST_OP_SELECT:
		editor(0, row);
		break;

	case PANEL_LIST_OP_VALIDATE:
		break;

	case PANEL_LIST_OP_DELETE:
		break;
	}
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	/* gxv_end_connections */

	return XV_OK;
}

/*
 * Notify callback function for `add_host_button1'.
 */
void
skiptool_base_window_add_host_button1_notify_callback(Panel_item item, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Skiptool_hostwin->hostwin, XV_SHOW, TRUE, NULL);
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `delete_button'.
 */
void
skiptool_base_window_delete_button_notify_callback(Panel_item item, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
host_delete();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `key_status'.
 */
void
skiptool_base_window_key_status_notify_callback(Panel_item item, Event *event)
{
	skiptool_base_window_objects *ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
key_status();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `secure'.
 */
void
skiptool_hostwin_secure_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_hostwin_objects *ip = (skiptool_hostwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
build_alg_menus(ip);
selectors_available(ip);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `nsid'.
 */
void
skiptool_hostwin_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_hostwin_objects *ip = (skiptool_hostwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */
	/* gxv_end_connections */

}

/*
 * Notify callback function for `hostwin_cancel'.
 */
void
skiptool_hostwin_hostwin_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_objects *ip = (skiptool_hostwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
save_or_discard(ip);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `key_apply'.
 */
void
skiptool_key_params_win_key_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_key_params_win_objects *ip = (skiptool_key_params_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	xv_set(Skiptool_key_params_win->key_params_win, XV_SHOW, FALSE, NULL);
	
	{
set_key_params();

	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `key_default'.
 */
void
skiptool_key_params_win_key_default_notify_callback(Panel_item item, Event *event)
{
	skiptool_key_params_win_objects *ip = (skiptool_key_params_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
set_key_defaults();

	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `required_add'.
 */
void
skiptool_required_win_required_add_notify_callback(Panel_item item, Event *event)
{
	skiptool_required_win_objects *ip = (skiptool_required_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
required_systems_add();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `required_cancel'.
 */
void
skiptool_required_win_required_cancel_notify_callback(Panel_item item, Event *event)
{
	skiptool_required_win_objects *ip = (skiptool_required_win_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
required_systems_done();
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `hostwin_apply'.
 */
void
skiptool_hostwin_hostwin_apply_notify_callback(Panel_item item, Event *event)
{
	skiptool_hostwin_objects *ip = (skiptool_hostwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
hostwin_apply(ip);
	}
	
	/* gxv_end_connections */

}

/*
 * Menu handler for `help_menu (About...)'.
 */
Menu_item
skiptool_help_menu_item1_callback(Menu_item item, Menu_generate op)
{
	skiptool_base_window_objects * ip = (skiptool_base_window_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		xv_set(Skiptool_about_win->about_win, XV_SHOW, TRUE, NULL);
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Background event callback function for `controls1'.
 * This is a function generated by guide to handle popup 
 * menu help_menu for control area controls1.
 */
void
skiptool_base_window_controls1_background_handler(Xv_opaque panel, Event *event)
{
	
	if (event_action(event) == ACTION_MENU && event_is_down(event)) {
		Menu	menu = (Menu) xv_get(panel, WIN_MENU);

		if (menu)
			menu_show(menu, panel, event, 0);
	}
}

/*
 * Menu handler for `stats_menu (Interface Stats)'.
 */
Menu_item
skiptool_stats_menu_item0_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(0);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `stats_menu (Header Stats)'.
 */
Menu_item
skiptool_stats_menu_item1_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(1);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `stats_menu (Algorithm Stats)'.
 */
Menu_item
skiptool_stats_menu_item2_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(2);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Menu handler for `stats_menu (Key Stats)'.
 */
Menu_item
skiptool_stats_menu_item3_callback(Menu_item item, Menu_generate op)
{
	Xv_opaque ip = (Xv_opaque) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	switch (op) {
	case MENU_DISPLAY:
		break;

	case MENU_DISPLAY_DONE:
		break;

	case MENU_NOTIFY:
		
		/* gxv_start_connections DO NOT EDIT THIS SECTION */

		{
stats(3);
		}
		
		/* gxv_end_connections */

		break;

	case MENU_NOTIFY_DONE:
		break;
	}
	return item;
}

/*
 * Notify callback function for `r_nsid'.
 */
void
skiptool_hostwin_r_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_hostwin_objects *ip = (skiptool_hostwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
selectors_available(ip);
	}
	
	/* gxv_end_connections */

}

/*
 * Notify callback function for `s_nsid'.
 */
void
skiptool_hostwin_s_nsid_notify_callback(Panel_item item, int value, Event *event)
{
	skiptool_hostwin_objects *ip = (skiptool_hostwin_objects *) xv_get(item, XV_KEY_DATA, INSTANCE);
	
	
	/* gxv_start_connections DO NOT EDIT THIS SECTION */

	{
selectors_available(ip);
	}
	
	/* gxv_end_connections */

}
