#!/bin/sh
#
#pragma ident "@(#)skipd_restart.sh	1.3  96/10/09"
#
#  Kill and restart the SKIP key management/certificate daemon

PATH=/bin:/usr/bin:/sbin:/usr/sbin
export PATH

SUNOS=`uname -r | sed 's/\..*//g'`
if [ $SUNOS = 5 ]; then
	SKIP_BIN=/opt/SUNWicg/bin
	SKIP_ETC=/etc/opt/SUNWicg/skip
else
	SKIP_BIN=/usr/skip/bin
	SKIP_ETC=/etc/skip
fi

SKIP_PID=$SKIP_ETC/skipd.pid
SKIPD=$SKIP_BIN/skipd

PATH=$SKIP_BIN:$PATH

if [ $# != 0 ]
then
	echo "usage: $0" 1>&2
	exit 1
fi

if [ ! -f $SKIP_PID -o ! -x $SKIPD ]
then
	exit 1
fi

kill `cat $SKIP_PID` > /dev/null 2>&1

exec $SKIPD
