/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)AuthPolicy.C	1.9 96/05/15"

#include <dirent.h>
#include "AuthPolicy.h"


AuthPolicy::AuthPolicy()
{
}

void AuthPolicy::clear()
{
	X509_CAs.clear();
	valid_hash.clear();
}

AuthPolicy::~AuthPolicy()
{
	clear();
}

int AuthPolicy::load_CAs(char *path)
{
	DIR *d;
	struct dirent *e;

	d = opendir(path);
	if (d == NULL)
		return FALSE;

	while (e = readdir(d)) {
		int len = strlen(e->d_name);

		if (len < 5)
			continue;

		if (strcmp(e->d_name + len - 5, ".x509") != 0)
			continue;

		char buf[1024];

		sprintf(buf, "%s/%s", path, e->d_name);

		Bstream certstr;
		X509Cert cert;

		certstr = File_to_Bstr(buf);
		if (certstr.getlength() == 0)
			continue;

		if (asn1_der_decode_cert(certstr, cert) != SUCCESS)
			continue;

		X509_CA entry;

		entry.ca_cert = cert;

		buf[strlen(buf)-5] = '\0';
		strcat(buf, ".mcrl");
		entry.revoked.load(buf);

		X509_CAs.append(entry);
	}

	closedir(d);

	return TRUE;
}

void AuthPolicy::load_auth_dh(char* filename)
{
	FILE *fp;
	char buf[256];
	char hex[33];
	int lineno = 0;
	Bstream r;
	char *p;
	int i;
	extern byte atob(char);

	fp = fopen(filename, "r");
	if (fp == NULL) {
		disable_hash_checking = TRUE;
		return;
	}

	disable_hash_checking = FALSE;

	while (fgets(buf, 256, fp) != NULL) {
		lineno++;
		buf[255] = '\0';

		for (p = buf; p && *p != '\n'; p++)
			;
		*p = '\0';

		for (p = buf; *p && (*p == ' ' || *p == '\t'); p++)
			;

		if (p[0] == '#' || p[0] == '\0')
			continue;

		for (i = 0; i < 32 && p && atob(*p) != 0xFF; p++, i++)
			hex[i] = *p;

		if (i != 32) {
			fprintf(stderr, "error reading %s, line %d\n",
						filename, lineno);
			continue;
		}
		hex[i] = '\0';

		Bstream_atob(r, hex);
		valid_hash.append(r);
	}

	fclose(fp);
}

int AuthPolicy::load(char* root)
{
	char filename[256];

	clear();

	sprintf(filename, "%s/dh_allowed", root);
	load_auth_dh(filename);

	sprintf(filename, "%s/CAs", root);
	load_CAs(filename);

	return TRUE;
}

