/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)Xstring.C	1.3 96/04/10 Sun Microsystems"

#define bcopy(a,b,c)	memcpy(b,a,c)

#include <memory.h>
#include <string.h>
#include "Xstring.h"

#ifndef NULL
#define NULL 0
#endif

Xstring::~Xstring()
{
	if (s)
		delete [] s;
}

Xstring::Xstring()
{
	s = NULL;
}

Xstring::Xstring(const void *p, int len)
{
	s = new char [len+1];
	bcopy(p, s, len);
	s[len] = (char) 0;
}

Xstring::Xstring(const char *p)
{
	s = new char [strlen(p) + 1];
	strcpy(s, p);
}

Xstring::Xstring(const Xstring& a)
{
	s = new char [strlen(a.s) + 1];
	strcpy(s, a.s);
}

Xstring::Xstring(const Xstring& a, const Xstring& b)
{

	if (a.s == NULL && b.s == NULL)
	{
		s = NULL;
	}
	else if (a.s == NULL)
	{
		int len_b = strlen(b.s)+1;	// includes '\0' at end

		s = new char [len_b];
		(void) bcopy(b.s, s, len_b);
	}
	else if (b.s == NULL)
	{
		int len_a = strlen(a.s)+1;	// includes '\0' at end

		s = new char [len_a];
		(void) bcopy(a.s, s, len_a);
	}
	else {
		int len_a = strlen(a.s);	// doesn't include '\0'
		int len_b = strlen(b.s)+1;	// includes '\0' at end

		s = new char [len_a + len_b];

		(void) bcopy(a.s, s, len_a);
		(void) bcopy(b.s, s + len_a, len_b);
	}
}

int Xstring::length() const
{
	if (s)
		return strlen(s);
	return 0;
}

int operator ==(const Xstring& a, const Xstring& b)
{

	if (a.s == b.s)
		return 1;
	if (a.s == NULL || b.s == NULL)
		return 0;
	return strcmp(a.s, b.s) == 0;
}

int operator !=(const Xstring& a, const Xstring& b)
{
	return !(a == b);
}

Xstring::operator const char *() const
{
	return s;
}

Xstring operator +(const Xstring& a, const Xstring& b)
{
	return Xstring(a, b);
}

Xstring& Xstring::operator +=(const Xstring& b)
{

	if (b.s == NULL)		// nothing to do
		return *this;

	int len_b = strlen(b.s) + 1;	// includes '\0' at end

	if (s == NULL) {

		s = new char [len_b];
		(void) bcopy(b.s, s, len_b);

		return *this;
	}

	char *new_s;
	int len = strlen(s);		// doesn't include '\0'

	new_s = new char [len + len_b];

	(void) bcopy(s, new_s, len);
	(void) bcopy(b.s, new_s + len, len_b);

	delete [] s;
	s = new_s;

	return *this;
}

Xstring& Xstring:: operator =(const Xstring& rhs)
{

	if (this != &rhs) {
		if (s)
			delete [] s;

		int len = strlen(rhs.s) + 1;

		s = new char [len];
		(void) bcopy(rhs.s, s, len);
	}

	return *this;
}

