/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
#ifdef SYSV
#include <skip_sysv.h>
#endif
#ifdef SUNOS
#include <skip_sunos.h>
#endif
#if !defined(SYSV) && !defined(SUNOS)
#include <skip_os.h>
#endif

#include <skip_proto.h>
#include <skip_crypt.h>

#define bzero(s, n) memset(s, 0,n)
#define bcopy(s,d,n) memcpy(d,s,n)

extern skip_cryptor_t safer_128sk_cbc_nopad_module;
extern skip_cryptor_t safer_128sk_cbc_module;
unsigned char key[] = {   0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08,
			  0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08 };

unsigned char databuf[] = { 0x03, 0x01, 0x04, 0x01, 0x05, 0x09, 0x02, 0x06,
			    0x05, 0x03, 0x05, 0x08, 0x09, 0x07, 0x09, 0x03};

dump_buf(char *input, int len)
{
	int count=0;
	printf("len = %d\n", len);
	while (len > 0) {
		printf("%02x ", (unsigned char) *input);
		input++;
		len--;
		count++;
		if (count % 8 == 0) 
			printf("\n");
	}
	printf("\n");
}

main(){
	unsigned char iv[8];
	char payload = 1;
	char inbuf[24];
	char encryptbuf[24];
	char decryptbuf[24];
	void *cs;
	int len;
	skip_cryptor_t *mod;

	mod = &safer_128sk_cbc_nopad_module;

	len = 16;


	printf("Original Buf:\n");
	dump_buf(databuf, len);

	bcopy(databuf, inbuf, len);

	bzero(iv, 8);

	cs = (*mod->open)(key, 16, iv, 8);
	(*mod->encrypt)(cs, inbuf, &len, encryptbuf, iv, 8, &payload);
	(*mod->close)(cs);

	printf("Encrypted Buf:\n");
	dump_buf(encryptbuf, len);
	bzero(iv, 8);

	cs = (*mod->open)(key, 16, iv, 8);
	(*mod->decrypt)(cs, encryptbuf, &len, decryptbuf, iv, 8, &payload);
	(*mod->close)(cs);

	printf("Decrypted Buf:\n");
	dump_buf(decryptbuf, len);

	bcopy(decryptbuf, databuf, len);

	mod = &safer_128sk_cbc_module;

	len = 16;
	bcopy(databuf, inbuf, len);
	dump_buf(inbuf, len);
	cs = (*mod->open)(key, 16, iv, 8);
	bzero(iv, 8);

	(*mod->encrypt)(cs, inbuf, &len, encryptbuf, iv, 8, &payload);
	(*mod->close)(cs);

	printf("Encrypted Buf:\n");
	dump_buf(encryptbuf, len);

	bzero(iv, 8);
	cs = (*mod->open)(key, 16, iv, 8);
	(*mod->decrypt)(cs, encryptbuf, &len, decryptbuf, iv, 8, &payload);
	(*mod->close)(cs);

	printf("Decrypted Buf:\n");
	dump_buf(decryptbuf, len);

}
