/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_ioctl.h	1.26 96/07/08 Sun Microsystems"

#ifndef SKIP_IOCTL_H
#define SKIP_IOCTL_H

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * SKIP keystore ioctls
 */
enum {	
	SKIP_KEY_GET_KEY_STATS,	/* get skip keys statistics 		*/
	SKIP_KEY_GET_HDR_STATS,	/* get skip headers statistics 		*/
	SKIP_KEY_GET_CPT_STATS,	/* get crypto modules statistics 	*/
	SKIP_KEY_GET_MAC_STATS,	/* get MAC modules statistics 		*/
	SKIP_KEY_GET_CRYPTORS,	/* get loaded cryptors list 		*/
	SKIP_KEY_GET_KIJ_ALGS,	/* get supported kij algs list 		*/
	SKIP_KEY_GET_VAR,	/* get named variable value (kvm like)	*/
	SKIP_KEY_SET_VAR,	/* set named variable value (kvm like)	*/
	SKIP_KEY_STATUS,	/* get crypto keys status (kvm like)	*/
	SKIP_KEY_LIST		/* get list of Local Master Key IDs 	*/
};		

/*
 * structures describing SKIP key driver statistics
 */
typedef struct {
	unsigned long		skip_encrypt_keys_active;
	unsigned long		skip_decrypt_keys_active;
	unsigned long		skip_key_lookups;
	unsigned long		skip_keymgr_requests;
	unsigned long		skip_key_reclaims;
	unsigned long		skip_key_nocanput;
	unsigned long		skip_key_allocbfail;
	unsigned long		skip_key_kmemallocfail;
	unsigned long		skip_hash_collisions;
} ioctl_key_stat_t;

typedef struct {
	unsigned long		skip_hdr_encodes;
	unsigned long		skip_hdr_decodes;
	unsigned long		skip_hdr_runts;
	unsigned long		skip_hdr_short_nodeids;
	unsigned long		skip_hdr_short_r_mkeyid;
	unsigned long		skip_hdr_short_s_mkeyid;
	unsigned long		skip_hdr_bad_r_mkeyid;
	unsigned long		skip_hdr_short_ekps;
	unsigned long		skip_hdr_short_mids;
	unsigned long		skip_hdr_bad_kp_algs;
	unsigned long		skip_hdr_bad_mac_algs;
	unsigned long		skip_hdr_bad_mac_size;
	unsigned long		skip_hdr_bad_mac_val;
	unsigned long		skip_hdr_bad_versions;
	unsigned long		skip_ipsp_decodes;
	unsigned long		skip_ipsp_encodes;
	unsigned long		skip_hdr_bad_nsid;
	unsigned long		skip_hdr_bad_next;
	unsigned long		skip_hdr_bad_esp_spi;
	unsigned long		skip_hdr_bad_ah_spi;
	unsigned long		skip_hdr_bad_iv;
} ioctl_hdr_stat_t;

/*
 * structure describing SKIP per-crypto system statistics
 */
typedef struct {
	unsigned int		module_id;
	unsigned long		encrypts;
	unsigned long		encrypterrs;
	unsigned long		decrypts;
	unsigned long		decrypterrs;
} crypt_mod_stat_t;

/*
 * structure describing a SKIP MAC module statistics
 */
typedef struct {
	unsigned int		module_id;
	unsigned long		in_mac;
	unsigned long		in_mac_errs;
	unsigned long		out_mac;
	unsigned long		out_mac_errs;
} mac_mod_stat_t;

/*
 * Crypto Modules statistics
 */
typedef struct {
	unsigned int		nb_algs;
	unsigned char		version;
	crypt_mod_stat_t	crypt_stats[SKIP_MAXCRYPTORS];
} ioctl_crypt_stat_t;

/*
 * MAC Modules statistics
 */
typedef struct {
	unsigned int		nb_algs;
	mac_mod_stat_t		mac_stats[SKIP_MAX_MAC];
} ioctl_mac_stat_t;

/*
 * Kij/Kp and MAC Modules List
 */
typedef struct {
	boolean_t	flag_alg[SKIP_MAXCRYPTORS];
	boolean_t	flag_alg_v1[SKIP_MAXCRYPTORS];
	boolean_t	flag_alg_mac[SKIP_MAX_MAC];
} ioctl_alg_list_t;

/*
 * Set/Get var ioctls
 */
#define	MAXVARNAMELG	40

/*
 * structure for kvm-like access
 */
#define	SKIP_FMT_STD	0
#define	SKIP_FMT_NET	1

typedef struct skip_sym {
	int	*p_value;
	int	v_fmt;
	char	*p_name;
} skip_sym_t;

typedef struct {
	char	var_name[MAXVARNAMELG];
	int	var_lg;
	int	var_value;
} ioctl_skip_sym_t;

/*
 * XXX - size of a crypto variable
 */
#define	MAXVARSZ		24

/*
 * Encryption/Decryption keys status
 */
typedef struct {
	skip_param_t		params;
	int			ekp_len;
	char			ekp_buf[MAXVARSZ];
	unsigned int		obytes;
	int			max_obytes;
	int			count_out;
	int			count_in;
} ioctl_key_status_t;

/*
 * Local Master Key ID list
 */
typedef struct {
	skip_key_var_t	mkeyid[SKIP_MAX_LOCAL_KEYIDS];	/* Array of Keys  */
	int		count;				/* number of keys */
} skip_keyid_list_t;

typedef struct {
	skip_keyid_list_t	keyid_lst[SKIP_MAX_NSID];
} ioctl_keyid_t;


/*
 * function prototypes - exported functions
 */
extern int		skip_get_key_stats(ioctl_key_stat_t *);
extern int		skip_get_hdr_stats(ioctl_hdr_stat_t *);
extern int		skip_get_key_status(ioctl_key_status_t *);
extern int		skip_get_var(ioctl_skip_sym_t *);
extern int		skip_set_var(ioctl_skip_sym_t *);
extern void		skip_get_kp_alg_list(ioctl_alg_list_t *);
extern void		skip_get_kij_alg_list(ioctl_alg_list_t *);
extern void		skip_cryptor_stats(ioctl_crypt_stat_t *);
extern void		skip_mac_stats(ioctl_mac_stat_t *);
extern void		skip_get_keyid_list(ioctl_keyid_t *);

#ifdef  __cplusplus
}
#endif

#endif /* SKIP_IOCTL_H */
