/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skipd.C	1.27 96/10/15"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include "skip_keymgr.h"
#include "skip_log.h"
#include "cdp.h"
#include "cdp_queue.h"
#include "skip_certbase.h"
#include "skip_localidlist.h"
#include "Sig.h"
#include "Passwd.h"


cdp_queue cdp_q;

int reinit_flag = 0;
int kern_fd;
int certd_fd;

extern int verbose;


void skipd_loop();


void usage()
{
	fprintf(stderr, "usage: ...\n");	// XXX
}

main(int argc, char **argv)
{
	int c;
	int errflag = 0;

	while ((c = getopt(argc, argv, "vV?")) != EOF) {
		switch(c) {
		case 'v':
			verbose = 1;
			break;

		case 'V':
			verbose = 2;
			break;

		case '?':
		default:
			errflag++;
		}
	}

	if (errflag) {
		usage();
		exit(1);
	}

	{
		extern FILE *skip_log_fp;

		skip_log_fp = fopen("/var/log/skipd.log", "w+");

		// if open fails, skip_log will default to stdout/stderr
	}


//  put ourselves into the background

	switch (fork()) {
	case -1:
		skip_log(SKIP_ERROR, "fork failed");
		exit(1);

	case 0:
		break;

	default:
		exit(0);
	}

	setsid();

	freopen("/dev/null", "r", stdin);
	freopen("/dev/null", "w", stdout);
	freopen("/dev/null", "w", stderr);

	skip_init();
	skipd_loop();

	exit(0);
}


extern void randpool_write_randseed();

void heartbeat()
{
	static time_t last_heartbeat;
	static time_t randseed_timestamp = 0;
	time_t now;

// don't run heartbeat more than once every 5 seconds

	time(&now);

	if (last_heartbeat + 5 > now)
		return;

	last_heartbeat = now;

//  write out the randseed file periodically

	if (now > randseed_timestamp + 5400) {
		if (randseed_timestamp > 0)
			randpool_write_randseed();
		randseed_timestamp = now;
	}


	cdp_q.heartbeat();
}

void process_cert_get(cdp_rec *p, cdp& reply)
{
	CertInfoList certs;
	CertInfo *q;
	int ncerts = 0;

	if (skip_conf.serve_only_local &&
	    !LocalList.is_local_identity(p->ci.nsid, p->ci.mkid)) {

		reply.cdp_getfail(p->ci.nsid, p->ci.mkid);

		skip_log(SKIP_NOTICE,
			"%s %s response=getfail (not a local identity)",
				sock_info_str, p->get_info_str());
		return;
	}

	if (db_get_certinfo_list(p->ci.nsid, p->ci.mkid, certs)) {
		reply.cdp_getfail(p->ci.nsid, p->ci.mkid);

		skip_log(SKIP_NOTICE, "%s %s response=getfail",
				sock_info_str, p->get_info_str());
		return;
	}

	for (q = certs.first(); q; q = certs.next()) {
		reply.cdp_getok(*q);
		ncerts++;
	}

	skip_log(SKIP_NOTICE, "%s %s response=getok (%d cert%s)",
				sock_info_str,
				p->get_info_str(),
				ncerts, ncerts == 1 ? "" : "s");
}

void process_cert_put(cdp_rec *p, cdp* reply)
{

	if (skip_conf.disallow_cdp_put) {
		if (reply)
			reply->cdp_putfail(p->ci.nsid, p->ci.mkid);

		skip_log(SKIP_NOTICE,
			"%s %s response=putfail (disallow_cdp_put=1)",
				sock_info_str, p->get_info_str());
		return;
	}

	if (p->ci.cert) {
		db_put_certinfo(p->ci);
		if (reply)
			reply->cdp_putok(p->ci.nsid, p->ci.mkid);

		skip_log(SKIP_NOTICE, "%s %s response=putok",
			sock_info_str, p->get_info_str());
		return;
	}

	if (reply)
		reply->cdp_putfail(p->ci.nsid, p->ci.mkid);

	skip_log(SKIP_NOTICE, "%s %s response=putfail",
			sock_info_str, p->get_info_str());
}

void process_certd(int sock)
{
	cdp request;
	Bstream bufstr;

	bufstr = read_sock(sock);
		
	if (request.decode(bufstr)) {
		skip_log(SKIP_ERROR, "%s manged request", sock_info_str);
		return;
	}

	if (request.action != CDP_INITIATE ) {
		skip_log(SKIP_ERROR, "%s action = %d - ignored",
				sock_info_str, request.action);
		return;
	}

	cdp reply(CDP_RESPONSE);
	cdp_rec *p;

	for (p = request.recs.first(); p; p = request.recs.next()) {
		switch (p->action) {
		case CDP_REC_GET:
			process_cert_get(p, reply);
			break;

		case CDP_REC_PUT:
			process_cert_put(p, &reply);
			break;

		default:
			skip_log(SKIP_NOTICE, "%s %s unknown request",
				sock_info_str, p->get_info_str());
		}
	}

	if (reply.recs.length() > 0) {
		Bstream replystr = reply.encode();
		write_sock(sock, replystr);
	}
}

static char inbuf[MGTCSIZE];
static char outbuf[MGTCSIZE];

void process_kernel(int keyfd)
{
	int size;
	int status;
	struct remote_info remote;

	size = get_kernel_message(keyfd, inbuf, MGTCSIZE);

	if (size <= 0 )
		return;


	status = make_response(inbuf, outbuf, &size, &remote);

	switch(status) {
	case KEYMGR_OK:
		if (verbose)
		skip_log(SKIP_NOTICE, "OK: kernel query nsid=%d mkid=%s",
				remote.nsid, remote.keyid.get_info_str());
		put_kernel_message(keyfd, outbuf, size);
		break;

	case KEYMGR_NOCERT:
		skip_log(SKIP_NOTICE, "NOCERT: kernel query nsid=%d mkid=%s",
				remote.nsid, remote.keyid.get_info_str());

		if (!skip_conf.enable_cdp)
			skip_log(SKIP_NOTICE,
				"no certificate for nsid=%d mkid=%s",
				remote.nsid, remote.keyid.get_info_str());
		else
			cdp_q.add_entry(&remote, inbuf, size);
		break;

	case KEYMGR_BAD_N_OFFSET:
		skip_log(SKIP_ERROR, "N-counter out of range - either replayed"
				     " packets or out of sync clocks ",
				     "nsid=%d mkid=%s", remote.nsid, 
				     remote.keyid.get_info_str());
		break;

	case KEYMGR_NO_MANUAL_KEY:
		skip_log(SKIP_ERROR, "no raw key: nsid=%d mkid=%s",
				remote.nsid, remote.keyid.get_info_str());
		break;

	default:
		skip_log(SKIP_ERROR, "make_response status=%d", status);
	}
}

void skipd_loop()
{
	int fd;

	while (1) {
		fd = select_wrapper(kern_fd, certd_fd, cdp_q);

#if 0
		if (reinit_flag) {		// XXX
			reinit_flag = 0;
			skip_log(SKIP_NOTICE, "skipd: reloading configuration");
			reload_config();
			continue;
		}
#endif

		if (fd == -1)
			;
		else if (fd == kern_fd)
			process_kernel(kern_fd);
		else if (fd == certd_fd)
			process_certd(certd_fd);
		else if (cdp_q.check_answer_received(fd, kern_fd))
			;
		else
			skip_log(SKIP_ERROR, "skipd_loop: internal error");

		heartbeat();
	}
}

