# SKIP Source Code License Statement:
# ------------------------------------------------------------------
#   Copyright
#   Sun Microsystems, Inc.
# 
# 
#   Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
#   Reserved.
# 
#   Permission is hereby granted, free of charge, to any person
#   obtaining a copy of this software and associated documentation
#   files (the "Software"), to deal in the Software without
#   restriction, including without limitation the rights to use,
#   copy, modify, merge, publish, distribute, sublicense, and/or sell
#   copies of the Software or derivatives of the Software, and to 
#   permit persons to whom the Software or its derivatives is furnished 
#   to do so, subject to the following conditions:
# 
#   The above copyright notice and this permission notice shall be
#   included in all copies or substantial portions of the Software.
# 
#   The Software must not be transferred to persons who are not US
#   citizens or permanent residents of the US or exported outside
#   the US (except Canada) in any form (including by electronic
#   transmission) without prior written approval from the US
#   Government. Non-compliance with these restrictions constitutes
#   a violation of the U.S. Export Control Laws.
# 
#   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
#   EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
#   OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
#   NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
#   FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
#   OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
#   CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
#   THE USE OR OTHER DEALINGS IN THE SOFTWARE.
# 
#   Except as contained in this notice, the name of Sun Microsystems, Inc.
#   shall not be used in advertising or otherwise to promote
#   the sale, use or other dealings in this Software or its derivatives 
#   without prior written authorization from Sun Microsystems, Inc.
;GIL-3
(
(
	:type                   :menu
	:name                   stats_menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "SKIP Statistics"
	:menu-item-labels       ("Network Interface Stats" "Header Stats" "Key Stats" "Encryption Stats (version 1)" "Encryption Stats" "Authentication Stats" )
	:menu-item-label-types  (:string :string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil nil nil )
	:menu-item-menus        (nil nil nil nil nil nil )
	:menu-item-colors       ("" "" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (stats_menu "Network Interface Stats")
		:when                   (Notify )
		:to                     (stats_menu "Network Interface Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(0);")
		)
		(
		:from                   (stats_menu "Header Stats")
		:when                   (Notify )
		:to                     (stats_menu "Header Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(1);")
		)
		(
		:from                   (stats_menu "Encryption Stats (version 1)")
		:when                   (Notify )
		:to                     (stats_menu "Encryption Stats (version 1)")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(2);")
		)
		(
		:from                   (stats_menu "Key Stats")
		:when                   (Notify )
		:to                     (stats_menu "Key Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(3);")
		)
		(
		:from                   (stats_menu "Encryption Stats")
		:when                   (Notify )
		:to                     (stats_menu "Encryption Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(4);")
		)
		(
		:from                   (stats_menu "Authentication Stats")
		:when                   (Notify )
		:to                     (stats_menu "Authentication Stats")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("stats(5);")
		)
	)
)
(
	:type                   :menu
	:name                   menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "File"
	:menu-item-labels       ("Load" "Key Management..." "SKIP Statistics" "Save" "Exit" )
	:menu-item-label-types  (:string :string :string :string :string )
	:menu-item-states       (:active :active :active :active :active )
	:menu-item-defaults     (nil nil nil nil nil )
	:initial-selections     (nil nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil nil )
	:menu-item-menus        (nil nil stats_menu nil nil )
	:menu-item-colors       ("" "" "" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (menu "Save")
		:when                   (Notify )
		:to                     (menu "Save")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("acl_save();")
		)
		(
		:from                   (menu "Exit")
		:when                   (Notify )
		:to                     (menu "Exit")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("exit(0);")
		)
		(
		:from                   (menu "Load")
		:when                   (Notify )
		:to                     (menu "Load")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("acl_build(); show_mode(); access_update();")
		)
		(
		:from                   (menu "Key Management...")
		:when                   (Notify )
		:to                     (key_params_win)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (menu "Key Management...")
		:when                   (Notify )
		:to                     (key_params_win)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("get_key_params();
")
		)
	)
)
(
	:type                   :menu
	:name                   version_menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Host Security..."
	:menu-item-labels       ("Off" "SKIP" "SKIP (version 1)" "ESP/AH (manual keying)" )
	:menu-item-label-types  (:string :string :string :string )
	:menu-item-states       (:active :active :active :active )
	:menu-item-defaults     (t nil nil nil )
	:initial-selections     (nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil )
	:menu-item-menus        (nil nil nil nil )
	:menu-item-colors       ("" "" "" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (version_menu "SKIP")
		:when                   (Notify )
		:to                     (hostwin_v2)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (version_menu "ESP/AH (manual keying)")
		:when                   (Notify )
		:to                     (hostwin_raw)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (version_menu "SKIP (version 1)")
		:when                   (Notify )
		:to                     (hostwin_v1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (version_menu "Off")
		:when                   (Notify )
		:to                     (hostwin)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :menu
	:name                   version_menu_nom
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Nomadic Security..."
	:menu-item-labels       ("SKIP" "SKIP (version 1)" )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (t nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (nil nil )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (version_menu_nom "SKIP (version 1)")
		:when                   (Notify )
		:to                     (nomwin_v1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (version_menu_nom "SKIP")
		:when                   (Notify )
		:to                     (nomwin_v2)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :menu
	:name                   version_menu_net
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Network Security..."
	:menu-item-labels       ("Off" "SKIP" "SKIP (version 1)" "ESP/AH (manual keying)" )
	:menu-item-label-types  (:string :string :string :string )
	:menu-item-states       (:active :active :active :active )
	:menu-item-defaults     (t nil nil nil )
	:initial-selections     (nil nil nil nil )
	:menu-item-handlers     (nil nil nil nil )
	:menu-item-menus        (nil nil nil nil )
	:menu-item-colors       ("" "" "" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (version_menu_net "ESP/AH (manual keying)")
		:when                   (Notify )
		:to                     (netwin_raw)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (version_menu_net "Off")
		:when                   (Notify )
		:to                     (netwin)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (version_menu_net "SKIP (version 1)")
		:when                   (Notify )
		:to                     (netwin_v1)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
		(
		:from                   (version_menu_net "SKIP")
		:when                   (Notify )
		:to                     (netwin_v2)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :menu
	:name                   add_menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Add..."
	:menu-item-labels       ("Host" "Network" "Nomadic" )
	:menu-item-label-types  (:string :string :string )
	:menu-item-states       (:active :active :active )
	:menu-item-defaults     (t nil nil )
	:initial-selections     (nil nil nil )
	:menu-item-handlers     (nil nil nil )
	:menu-item-menus        (version_menu version_menu_net version_menu_nom )
	:menu-item-colors       ("" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                ()
)
(
	:type                   :menu
	:name                   xversion_menu_nom
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Nomadic Security..."
	:menu-item-labels       ("SKIP " "SKIP (version 1)" )
	:menu-item-label-types  (:string :string )
	:menu-item-states       (:active :active )
	:menu-item-defaults     (nil nil )
	:initial-selections     (nil nil )
	:menu-item-handlers     (nil nil )
	:menu-item-menus        (nil nil )
	:menu-item-colors       ("" "" )
	:pinnable               nil
	:user-data              ()
	:actions                (
		(
		:from                   (xversion_menu_nom "SKIP (version 1)")
		:when                   (Notify )
		:to                     (xversion_menu_nom "SKIP (version 1)")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(add_xnomwin_v1->win, XV_SHOW, TRUE, NULL);")
		)
		(
		:from                   (xversion_menu_nom "SKIP ")
		:when                   (Notify )
		:to                     (xversion_menu_nom "SKIP ")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(add_xnomwin_v2->win, XV_SHOW, TRUE, NULL);")
		)
	)
)
(
	:type                   :menu
	:name                   exc_menu
	:help                   ""
	:columns                1
	:menu-type              :command
	:menu-handler           nil
	:menu-title             "Exclude..."
	:menu-item-labels       ("Host..." "Network..." "Nomadic" )
	:menu-item-label-types  (:string :string :string )
	:menu-item-states       (:active :active :active )
	:menu-item-defaults     (t nil nil )
	:initial-selections     (nil nil nil )
	:menu-item-handlers     (nil nil nil )
	:menu-item-menus        (nil nil xversion_menu_nom )
	:menu-item-colors       ("" "" "" )
	:pinnable               t
	:user-data              ()
	:actions                (
		(
		:from                   (exc_menu "Host...")
		:when                   (Notify )
		:to                     (exc_menu "Host...")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(add_xhostwin->win, XV_SHOW, TRUE, NULL);")
		)
		(
		:from                   (exc_menu "Network...")
		:when                   (Notify )
		:to                     (exc_menu "Network...")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(add_xnetwin->win, XV_SHOW, TRUE, NULL);")
		)
	)
)
(
	:type                   :base-window
	:name                   base_window
	:owner                  nil
	:width                  535
	:height                 380
	:background-color       ""
	:foreground-color       ""
	:label                  "Solaris SKIP ()"
	:label-type             :string
	:initial-state          :open
	:show-footer            t
	:resizable              nil
	:icon-file              "skiptool_small.xbm"
	:icon-label             "skip"
	:icon-mask-file         ""
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   host_panel
	:owner                  base_window
	:help                   ""
	:x                      0
	:y                      0
	:width                  535
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   settings_button
	:owner                  host_panel
	:help                   ""
	:x                      20
	:y                      8
	:width                  54
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "File"
	:label-type             :string
	:initial-state          :active
	:menu                   menu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   about_button
	:owner                  host_panel
	:help                   ""
	:x                      448
	:y                      8
	:width                  63
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "About..."
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base_window about_button)
		:when                   (Notify )
		:to                     (about_win)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Show)
		)
	)
)
(
	:type                   :control-area
	:name                   controls1
	:owner                  base_window
	:help                   ""
	:x                      0
	:y                      33
	:width                  535
	:height                 74
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  controls1
	:help                   ""
	:x                      22
	:y                      10
	:width                  64
	:height                 42
	:foreground-color       ""
	:label                  "skiptool_small.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   access_ctrl
	:owner                  controls1
	:help                   ""
	:x                      280
	:y                      12
	:width                  88
	:height                 23
	:value-x                280
	:value-y                12
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("disabled" "enabled" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base_window access_ctrl "disabled")
		:when                   (Notify )
		:to                     (base_window access_ctrl "disabled")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
		(
		:from                   (base_window access_ctrl "enabled")
		:when                   (Notify )
		:to                     (base_window access_ctrl "disabled")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
	)
)
(
	:type                   :message
	:name                   message6
	:owner                  controls1
	:help                   ""
	:x                      108
	:y                      17
	:width                  119
	:height                 13
	:foreground-color       ""
	:label                  "Access control is:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   access_mode
	:owner                  controls1
	:help                   ""
	:x                      280
	:y                      36
	:width                  160
	:height                 23
	:value-x                280
	:value-y                36
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("No access" "Ask for confirmation" "Add automatically" )
	:choice-label-types     (:string :string :string )
	:choice-colors          ("" "" "" )
	:choice-defaults        (nil nil nil )
	:initial-selections     (nil nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (base_window access_mode "No access")
		:when                   (Notify )
		:to                     (base_window access_mode "No access")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
		(
		:from                   (base_window access_mode "Ask for confirmation")
		:when                   (Notify )
		:to                     (base_window access_mode "Ask for confirmation")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
		(
		:from                   (base_window access_mode "Add automatically")
		:when                   (Notify )
		:to                     (base_window access_mode "Add automatically")
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("access_update();")
		)
	)
)
(
	:type                   :message
	:name                   message12
	:owner                  controls1
	:help                   ""
	:x                      108
	:y                      40
	:width                  157
	:height                 13
	:foreground-color       ""
	:label                  "Unauthorized systems:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   remote_panel
	:owner                  base_window
	:help                   ""
	:x                      0
	:y                      102
	:width                  535
	:height                 249
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   hostlist
	:owner                  remote_panel
	:help                   ""
	:x                      18
	:y                      18
	:width                  210
	:height                 199
	:value-x                18
	:value-y                35
	:rows                   9
	:foreground-color       ""
	:label                  "Authorized Systems:"
	:title                  ""
	:label-type             :string
	:layout-type            :vertical
	:read-only              t
	:multiple-selections    nil
	:selection-required     t
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         hostlist_notify
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (base_window hostlist)
		:when                   (Notify )
		:to                     (base_window hostlist)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (hostlist_notify)
		)
	)
)
(
	:type                   :scrolling-list
	:name                   xhostlist
	:owner                  remote_panel
	:help                   ""
	:x                      294
	:y                      18
	:width                  210
	:height                 199
	:value-x                294
	:value-y                35
	:rows                   9
	:foreground-color       ""
	:label                  "Excluded Systems:"
	:title                  ""
	:label-type             :string
	:layout-type            :vertical
	:read-only              t
	:multiple-selections    nil
	:selection-required     t
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         xhostlist_notify
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                (
		(
		:from                   (base_window xhostlist)
		:when                   (Notify )
		:to                     (base_window xhostlist)
		:function_type          CallFunction
		:arg_type               ()
		:action                 (xhostlist_notify)
		)
	)
)
(
	:type                   :button
	:name                   to_x
	:owner                  remote_panel
	:help                   ""
	:x                      252
	:y                      102
	:width                  34
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  ">>"
	:label-type             :string
	:initial-state          :inactive
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base_window to_x)
		:when                   (Notify )
		:to                     (required_win required_add)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("host_swap();")
		)
	)
)
(
	:type                   :button
	:name                   to_a
	:owner                  remote_panel
	:help                   ""
	:x                      252
	:y                      132
	:width                  34
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "<<"
	:label-type             :string
	:initial-state          :inactive
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base_window to_a)
		:when                   (Notify )
		:to                     (required_win required_add)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("host_swap();")
		)
	)
)
(
	:type                   :control-area
	:name                   controls8
	:owner                  base_window
	:help                   ""
	:x                      0
	:y                      345
	:width                  535
	:height                 35
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   add_host_button
	:owner                  controls8
	:help                   ""
	:x                      48
	:y                      8
	:width                  56
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add"
	:label-type             :string
	:initial-state          :active
	:menu                   add_menu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   delete_button
	:owner                  controls8
	:help                   ""
	:x                      126
	:y                      8
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete"
	:label-type             :string
	:initial-state          :inactive
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base_window delete_button)
		:when                   (Notify )
		:to                     (base_window delete_button)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("host_delete();")
		)
	)
)
(
	:type                   :button
	:name                   add_xhost_button
	:owner                  controls8
	:help                   ""
	:x                      336
	:y                      8
	:width                  56
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add"
	:label-type             :string
	:initial-state          :active
	:menu                   exc_menu
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   delete_xbutton
	:owner                  controls8
	:help                   ""
	:x                      414
	:y                      8
	:width                  57
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Delete"
	:label-type             :string
	:initial-state          :inactive
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (base_window delete_xbutton)
		:when                   (Notify )
		:to                     (base_window delete_xbutton)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("host_delete();")
		)
	)
)
(
	:type                   :popup-window
	:name                   key_params_win
	:owner                  base_window
	:width                  414
	:height                 130
	:background-color       ""
	:foreground-color       ""
	:label                  "Key Management Parameters"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls4
	:owner                  key_params_win
	:help                   ""
	:x                      0
	:y                      0
	:width                  414
	:height                 130
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            nil
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   skip_key_max_use
	:owner                  controls4
	:help                   ""
	:x                      220
	:y                      16
	:width                  75
	:height                 15
	:value-x                220
	:value-y                16
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              100
	:min-value              0
	:initial-value          30
	:initial-state          :inactive
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message3
	:owner                  controls4
	:help                   ""
	:x                      15
	:y                      17
	:width                  195
	:height                 13
	:foreground-color       ""
	:label                  "Change transmit keys every:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message12
	:owner                  controls4
	:help                   ""
	:x                      304
	:y                      18
	:width                  56
	:height                 13
	:foreground-color       ""
	:label                  "seconds"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   skip_key_max_idle
	:owner                  controls4
	:help                   ""
	:x                      220
	:y                      40
	:width                  75
	:height                 15
	:value-x                220
	:value-y                40
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              10000
	:min-value              5
	:initial-value          30
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message14
	:owner                  controls4
	:help                   ""
	:x                      35
	:y                      42
	:width                  175
	:height                 13
	:foreground-color       ""
	:label                  "Delete unused keys after:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message4
	:owner                  controls4
	:help                   ""
	:x                      304
	:y                      42
	:width                  56
	:height                 13
	:foreground-color       ""
	:label                  "seconds"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   skip_key_max_bytes
	:owner                  controls4
	:help                   ""
	:x                      220
	:y                      66
	:width                  75
	:height                 15
	:value-x                220
	:value-y                66
	:value-length           5
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :numeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:max-value              10000
	:min-value              1
	:initial-value          512
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message15
	:owner                  controls4
	:help                   ""
	:x                      89
	:y                      67
	:width                  121
	:height                 13
	:foreground-color       ""
	:label                  "Transmit at most:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message2
	:owner                  controls4
	:help                   ""
	:x                      304
	:y                      67
	:width                  101
	:height                 13
	:foreground-color       ""
	:label                  "kbytes per key"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   key_apply
	:owner                  controls4
	:help                   ""
	:x                      85
	:y                      104
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (key_params_win key_apply)
		:when                   (Notify )
		:to                     (key_params_win)
		:function_type          :user_defined
		:arg_type               ()
		:action                 (Hide)
		)
		(
		:from                   (key_params_win key_apply)
		:when                   (Notify )
		:to                     (key_params_win)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("set_key_params();
")
		)
	)
)
(
	:type                   :button
	:name                   key_default
	:owner                  controls4
	:help                   ""
	:x                      175
	:y                      104
	:width                  63
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Default"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (key_params_win key_default)
		:when                   (Notify )
		:to                     (key_params_win key_default)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("set_key_defaults();
")
		)
	)
)
(
	:type                   :button
	:name                   key_cancel
	:owner                  controls4
	:help                   ""
	:x                      277
	:y                      104
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   required_win
	:owner                  base_window
	:width                  350
	:height                 300
	:background-color       ""
	:foreground-color       ""
	:label                  "Required systems"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls5
	:owner                  required_win
	:help                   ""
	:x                      0
	:y                      0
	:width                  350
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  controls5
	:help                   ""
	:x                      20
	:y                      12
	:width                  64
	:height                 42
	:foreground-color       ""
	:label                  "skiptool_small.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   required_message
	:owner                  controls5
	:help                   ""
	:x                      100
	:y                      36
	:width                  196
	:height                 13
	:foreground-color       ""
	:label                  "0 addresses currently in use"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls11
	:owner                  required_win
	:help                   ""
	:x                      0
	:y                      64
	:width                  350
	:height                 198
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message5
	:owner                  controls11
	:help                   ""
	:x                      20
	:y                      12
	:width                  323
	:height                 13
	:foreground-color       ""
	:label                  "The addresses below are currently in use and should"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message13
	:owner                  controls11
	:help                   ""
	:x                      22
	:y                      28
	:width                  211
	:height                 13
	:foreground-color       ""
	:label                  "be added to the access control list:"
	:label-type             :string
	:label-bold             nil
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :scrolling-list
	:name                   required_list
	:owner                  controls11
	:help                   ""
	:x                      22
	:y                      52
	:width                  300
	:height                 128
	:value-x                22
	:value-y                52
	:rows                   6
	:foreground-color       ""
	:label                  ""
	:title                  ""
	:label-type             :string
	:layout-type            :horizontal
	:read-only              nil
	:multiple-selections    t
	:selection-required     nil
	:initial-state          :active
	:droppable              nil
	:default-drop-site      nil
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:initial-list-values    ()
	:initial-list-glyphs    ()
	:initial-selections     ()
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls12
	:owner                  required_win
	:help                   ""
	:x                      0
	:y                      259
	:width                  350
	:height                 41
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   required_add
	:owner                  controls12
	:help                   ""
	:x                      100
	:y                      10
	:width                  42
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Add"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (required_win required_add)
		:when                   (Notify )
		:to                     (required_win required_add)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("required_systems_add();")
		)
	)
)
(
	:type                   :button
	:name                   required_cancel
	:owner                  controls12
	:help                   ""
	:x                      194
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (required_win required_cancel)
		:when                   (Notify )
		:to                     (required_win required_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("required_systems_done();")
		)
	)
)
(
	:type                   :popup-window
	:name                   about_win
	:owner                  base_window
	:width                  260
	:height                 80
	:background-color       ""
	:foreground-color       ""
	:label                  "About SKIP"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls2
	:owner                  about_win
	:help                   ""
	:x                      0
	:y                      0
	:width                  260
	:height                 80
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  controls2
	:help                   ""
	:x                      14
	:y                      16
	:width                  64
	:height                 42
	:foreground-color       ""
	:label                  "skiptool_small.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message8
	:owner                  controls2
	:help                   ""
	:x                      90
	:y                      36
	:width                  117
	:height                 13
	:foreground-color       ""
	:label                  "SKIP version 1.00"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :popup-window
	:name                   hostwin_v2
	:owner                  base_window
	:width                  340
	:height                 434
	:background-color       ""
	:foreground-color       ""
	:label                  "SKIP host properties"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   host_panel
	:owner                  hostwin_v2
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  host_panel
	:help                   ""
	:x                      20
	:y                      13
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "icon_v2.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   host_label
	:owner                  host_panel
	:help                   ""
	:x                      52
	:y                      16
	:width                  72
	:height                 13
	:foreground-color       ""
	:label                  "Hostname:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   addr
	:owner                  host_panel
	:help                   ""
	:x                      136
	:y                      16
	:width                  184
	:height                 15
	:value-x                136
	:value-y                16
	:value-length           23
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   tunnel_transport_panel
	:owner                  hostwin_v2
	:help                   ""
	:x                      0
	:y                      44
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   skip_mode
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      11
	:width                  117
	:height                 23
	:value-x                164
	:value-y                11
	:rows                   0
	:columns                1
	:layout-type            :vertical
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Whole packet" "Data only" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_v2 skip_mode "Whole packet")
		:when                   (Notify )
		:to                     (hostwin_v2 tunnel_label)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_label, PANEL_INACTIVE, FALSE, NULL);")
		)
		(
		:from                   (hostwin_v2 skip_mode "Data only")
		:when                   (Notify )
		:to                     (hostwin_v2 tunnel_label)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_label, PANEL_INACTIVE, TRUE, NULL);")
		)
		(
		:from                   (hostwin_v2 skip_mode "Whole packet")
		:when                   (Notify )
		:to                     (hostwin_v2 tunnel_addr)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_addr, PANEL_INACTIVE, FALSE, NULL);")
		)
		(
		:from                   (hostwin_v2 skip_mode "Data only")
		:when                   (Notify )
		:to                     (hostwin_v2 tunnel_addr)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_addr, PANEL_INACTIVE, TRUE, NULL);")
		)
	)
)
(
	:type                   :message
	:name                   message16
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      15
	:width                  49
	:height                 13
	:foreground-color       ""
	:label                  "Secure:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   tunnel_label
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      41
	:width                  110
	:height                 13
	:foreground-color       ""
	:label                  "Tunnel address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tunnel_addr
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      41
	:width                  152
	:height                 15
	:value-x                164
	:value-y                41
	:value-length           19
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_remote_keyid_panel
	:owner                  hostwin_v2
	:help                   ""
	:x                      0
	:y                      113
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   r_nsid
	:owner                  v2_remote_keyid_panel
	:help                   ""
	:x                      164
	:y                      13
	:width                  107
	:height                 23
	:value-x                164
	:value-y                13
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Not present" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_v2 r_nsid)
		:when                   (Notify )
		:to                     (hostwin_v2 keyid)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->keyid, PANEL_VALUE, \"\", NULL);")
		)
	)
)
(
	:type                   :message
	:name                   r_nsid_msg
	:owner                  v2_remote_keyid_panel
	:help                   ""
	:x                      20
	:y                      15
	:width                  102
	:height                 13
	:foreground-color       ""
	:label                  "Remote Key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   keyid
	:owner                  v2_remote_keyid_panel
	:help                   ""
	:x                      20
	:y                      39
	:width                  298
	:height                 15
	:value-x                46
	:value-y                39
	:value-length           34
	:stored-length          80
	:rows                   2
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "ID:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_local_keyid_panel
	:owner                  hostwin_v2
	:help                   ""
	:x                      0
	:y                      182
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   s_nsid
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      164
	:y                      9
	:width                  107
	:height                 23
	:value-x                164
	:value-y                9
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Not present" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_v2 s_nsid)
		:when                   (Notify )
		:to                     (hostwin_v2 s_nsid)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("s_nsid_hostwin_v2_callback(ip);")
		)
	)
)
(
	:type                   :message
	:name                   s_nsid_msg
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      14
	:width                  87
	:height                 13
	:foreground-color       ""
	:label                  "Local Key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   local_keyid
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      34
	:width                  163
	:height                 23
	:value-x                46
	:value-y                34
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "ID:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("default local key" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_algs_panel
	:owner                  hostwin_v2
	:help                   ""
	:x                      0
	:y                      251
	:width                  340
	:height                 145
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kij_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      8
	:width                  66
	:height                 23
	:value-x                164
	:value-y                8
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kp_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      13
	:width                  106
	:height                 13
	:foreground-color       ""
	:label                  "Key encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      40
	:width                  66
	:height                 23
	:value-x                164
	:value-y                40
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      45
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   mac_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      72
	:width                  56
	:height                 23
	:value-x                164
	:value-y                72
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mac_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      77
	:width                  104
	:height                 13
	:foreground-color       ""
	:label                  "Authentication:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   comp_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      104
	:width                  56
	:height                 23
	:value-x                164
	:value-y                104
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message10
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      109
	:width                  94
	:height                 13
	:foreground-color       ""
	:label                  "Compression:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  hostwin_v2
	:help                   ""
	:x                      0
	:y                      394
	:width                  340
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_v2 win_apply)
		:when                   (Notify )
		:to                     (hostwin_v2 win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->hostwin_v2, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_v2 win_cancel)
		:when                   (Notify )
		:to                     (hostwin_v2 win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->hostwin_v2, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   hostwin_raw
	:owner                  base_window
	:width                  340
	:height                 320
	:background-color       ""
	:foreground-color       ""
	:label                  "ESP/AH host properties"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   host_panel
	:owner                  hostwin_raw
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  host_panel
	:help                   ""
	:x                      20
	:y                      13
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "unknown.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   host_label
	:owner                  host_panel
	:help                   ""
	:x                      52
	:y                      16
	:width                  72
	:height                 13
	:foreground-color       ""
	:label                  "Hostname:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   addr
	:owner                  host_panel
	:help                   ""
	:x                      136
	:y                      16
	:width                  184
	:height                 15
	:value-x                136
	:value-y                16
	:value-length           23
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   tunnel_transport_panel
	:owner                  hostwin_raw
	:help                   ""
	:x                      0
	:y                      44
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   skip_mode
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      11
	:width                  117
	:height                 23
	:value-x                164
	:value-y                11
	:rows                   0
	:columns                1
	:layout-type            :vertical
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Whole packet" "Data only" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_raw skip_mode "Whole packet")
		:when                   (Notify )
		:to                     (hostwin_raw tunnel_label)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_label, PANEL_INACTIVE, FALSE, NULL);")
		)
		(
		:from                   (hostwin_raw skip_mode "Data only")
		:when                   (Notify )
		:to                     (hostwin_raw tunnel_label)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_label, PANEL_INACTIVE, TRUE, NULL);")
		)
		(
		:from                   (hostwin_raw skip_mode "Whole packet")
		:when                   (Notify )
		:to                     (hostwin_raw tunnel_addr)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_addr, PANEL_INACTIVE, FALSE, NULL);")
		)
		(
		:from                   (hostwin_raw skip_mode "Data only")
		:when                   (Notify )
		:to                     (hostwin_raw tunnel_addr)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_addr, PANEL_INACTIVE, TRUE, NULL);")
		)
	)
)
(
	:type                   :message
	:name                   message1
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      15
	:width                  49
	:height                 13
	:foreground-color       ""
	:label                  "Secure:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   tunnel_label
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      41
	:width                  110
	:height                 13
	:foreground-color       ""
	:label                  "Tunnel address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tunnel_addr
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      41
	:width                  152
	:height                 15
	:value-x                164
	:value-y                41
	:value-length           19
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   local_spi_panel
	:owner                  hostwin_raw
	:help                   ""
	:x                      0
	:y                      106
	:width                  340
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   local_keyid
	:owner                  local_spi_panel
	:help                   ""
	:x                      106
	:y                      13
	:width                  128
	:height                 15
	:value-x                106
	:value-y                13
	:value-length           16
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   s_nsid_msg
	:owner                  local_spi_panel
	:help                   ""
	:x                      20
	:y                      14
	:width                  64
	:height                 13
	:foreground-color       ""
	:label                  "Local SPI:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   remote_spi_panel
	:owner                  hostwin_raw
	:help                   ""
	:x                      0
	:y                      145
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   keyid
	:owner                  remote_spi_panel
	:help                   ""
	:x                      106
	:y                      15
	:width                  128
	:height                 15
	:value-x                106
	:value-y                15
	:value-length           16
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   r_nsid_msg
	:owner                  remote_spi_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  79
	:height                 13
	:foreground-color       ""
	:label                  "Remote SPI:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   raw_algs_panel
	:owner                  hostwin_raw
	:help                   ""
	:x                      0
	:y                      189
	:width                  340
	:height                 92
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  raw_algs_panel
	:help                   ""
	:x                      164
	:y                      16
	:width                  66
	:height                 23
	:value-x                164
	:value-y                16
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  raw_algs_panel
	:help                   ""
	:x                      20
	:y                      21
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   mac_alg
	:owner                  raw_algs_panel
	:help                   ""
	:x                      164
	:y                      48
	:width                  56
	:height                 23
	:value-x                164
	:value-y                48
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mac_alg_msg
	:owner                  raw_algs_panel
	:help                   ""
	:x                      20
	:y                      53
	:width                  104
	:height                 13
	:foreground-color       ""
	:label                  "Authentication:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  hostwin_raw
	:help                   ""
	:x                      0
	:y                      280
	:width                  340
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_raw win_apply)
		:when                   (Notify )
		:to                     (hostwin_raw win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->hostwin_raw, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_raw win_cancel)
		:when                   (Notify )
		:to                     (hostwin_raw win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->hostwin_raw, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   hostwin_v1
	:owner                  base_window
	:width                  340
	:height                 305
	:background-color       ""
	:foreground-color       ""
	:label                  "SKIP version 1 properties"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   host_panel
	:owner                  hostwin_v1
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 305
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  host_panel
	:help                   ""
	:x                      20
	:y                      13
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "icon_v1.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   host_label
	:owner                  host_panel
	:help                   ""
	:x                      52
	:y                      16
	:width                  72
	:height                 13
	:foreground-color       ""
	:label                  "Hostname:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   addr
	:owner                  host_panel
	:help                   ""
	:x                      136
	:y                      16
	:width                  184
	:height                 15
	:value-x                136
	:value-y                16
	:value-length           23
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_remote_keyid_panel
	:owner                  hostwin_v1
	:help                   ""
	:x                      0
	:y                      44
	:width                  340
	:height                 261
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   keyid
	:owner                  v1_remote_keyid_panel
	:help                   ""
	:x                      136
	:y                      15
	:width                  184
	:height                 15
	:value-x                136
	:value-y                15
	:value-length           23
	:stored-length          30
	:rows                   2
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message24
	:owner                  v1_remote_keyid_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  56
	:height                 13
	:foreground-color       ""
	:label                  "Node ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_local_keyid_panel
	:owner                  hostwin_v1
	:help                   ""
	:x                      0
	:y                      88
	:width                  340
	:height                 217
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   local_keyid
	:owner                  v1_local_keyid_panel
	:help                   ""
	:x                      164
	:y                      11
	:width                  137
	:height                 23
	:value-x                164
	:value-y                11
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("default local key" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message23
	:owner                  v1_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  86
	:height                 13
	:foreground-color       ""
	:label                  "Local key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   tunnel_address_panel
	:owner                  hostwin_v1
	:help                   ""
	:x                      0
	:y                      132
	:width                  340
	:height                 173
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   tunnel_label
	:owner                  tunnel_address_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  111
	:height                 13
	:foreground-color       ""
	:label                  "Tunnel Address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tunnel_addr
	:owner                  tunnel_address_panel
	:help                   ""
	:x                      164
	:y                      16
	:width                  160
	:height                 15
	:value-x                164
	:value-y                16
	:value-length           20
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_algs_panel
	:owner                  hostwin_v1
	:help                   ""
	:x                      0
	:y                      176
	:width                  340
	:height                 129
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kij_alg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      164
	:y                      14
	:width                  66
	:height                 23
	:value-x                164
	:value-y                14
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kp_alg_msg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      20
	:y                      19
	:width                  106
	:height                 13
	:foreground-color       ""
	:label                  "Key encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      164
	:y                      46
	:width                  66
	:height                 23
	:value-x                164
	:value-y                46
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      20
	:y                      51
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  hostwin_v1
	:help                   ""
	:x                      0
	:y                      265
	:width                  340
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_v1 win_apply)
		:when                   (Notify )
		:to                     (hostwin_v1 win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->hostwin_v1, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin_v1 win_cancel)
		:when                   (Notify )
		:to                     (hostwin_v1 win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->hostwin_v1, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   hostwin
	:owner                  base_window
	:width                  340
	:height                 83
	:background-color       ""
	:foreground-color       ""
	:label                  "Host properties"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   host_panel
	:owner                  hostwin
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 44
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  host_panel
	:help                   ""
	:x                      20
	:y                      13
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "none.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   host_label
	:owner                  host_panel
	:help                   ""
	:x                      52
	:y                      16
	:width                  72
	:height                 13
	:foreground-color       ""
	:label                  "Hostname:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   addr
	:owner                  host_panel
	:help                   ""
	:x                      136
	:y                      16
	:width                  184
	:height                 15
	:value-x                136
	:value-y                16
	:value-length           23
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  hostwin
	:help                   ""
	:x                      0
	:y                      42
	:width                  340
	:height                 41
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin win_apply)
		:when                   (Notify )
		:to                     (hostwin win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->hostwin, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (hostwin win_cancel)
		:when                   (Notify )
		:to                     (hostwin win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->hostwin, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   netwin_raw
	:owner                  base_window
	:width                  340
	:height                 343
	:background-color       ""
	:foreground-color       ""
	:label                  "ESP/AH network properties"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   net_panel
	:owner                  netwin_raw
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 67
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   net_label
	:owner                  net_panel
	:help                   ""
	:x                      60
	:y                      17
	:width                  59
	:height                 13
	:foreground-color       ""
	:label                  "Network:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   addr
	:owner                  net_panel
	:help                   ""
	:x                      136
	:y                      17
	:width                  184
	:height                 15
	:value-x                136
	:value-y                17
	:value-length           23
	:stored-length          24
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  net_panel
	:help                   ""
	:x                      20
	:y                      20
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "unknown.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mask_label
	:owner                  net_panel
	:help                   ""
	:x                      60
	:y                      39
	:width                  63
	:height                 13
	:foreground-color       ""
	:label                  "Netmask:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   mask
	:owner                  net_panel
	:help                   ""
	:x                      136
	:y                      39
	:width                  184
	:height                 15
	:value-x                136
	:value-y                39
	:value-length           23
	:stored-length          24
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "255.255.255.0"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   tunnel_transport_panel
	:owner                  netwin_raw
	:help                   ""
	:x                      0
	:y                      66
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   skip_mode
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      11
	:width                  117
	:height                 23
	:value-x                164
	:value-y                11
	:rows                   0
	:columns                1
	:layout-type            :vertical
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Whole packet" "Data only" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_raw skip_mode "Whole packet")
		:when                   (Notify )
		:to                     (netwin_raw tunnel_label)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_label, PANEL_INACTIVE, FALSE, NULL);")
		)
		(
		:from                   (netwin_raw skip_mode "Data only")
		:when                   (Notify )
		:to                     (netwin_raw tunnel_label)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_label, PANEL_INACTIVE, TRUE, NULL);")
		)
		(
		:from                   (netwin_raw skip_mode "Whole packet")
		:when                   (Notify )
		:to                     (netwin_raw tunnel_addr)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_addr, PANEL_INACTIVE, FALSE, NULL);")
		)
		(
		:from                   (netwin_raw skip_mode "Data only")
		:when                   (Notify )
		:to                     (netwin_raw tunnel_addr)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_addr, PANEL_INACTIVE, TRUE, NULL);")
		)
	)
)
(
	:type                   :message
	:name                   message9
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      15
	:width                  49
	:height                 13
	:foreground-color       ""
	:label                  "Secure:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   tunnel_label
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      41
	:width                  110
	:height                 13
	:foreground-color       ""
	:label                  "Tunnel address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tunnel_addr
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      41
	:width                  152
	:height                 15
	:value-x                164
	:value-y                41
	:value-length           19
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   local_spi_panel
	:owner                  netwin_raw
	:help                   ""
	:x                      0
	:y                      129
	:width                  340
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   local_keyid
	:owner                  local_spi_panel
	:help                   ""
	:x                      106
	:y                      13
	:width                  128
	:height                 15
	:value-x                106
	:value-y                13
	:value-length           16
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   s_nsid_msg
	:owner                  local_spi_panel
	:help                   ""
	:x                      20
	:y                      14
	:width                  64
	:height                 13
	:foreground-color       ""
	:label                  "Local SPI:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   remote_spi_panel
	:owner                  netwin_raw
	:help                   ""
	:x                      0
	:y                      168
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   keyid
	:owner                  remote_spi_panel
	:help                   ""
	:x                      106
	:y                      15
	:width                  128
	:height                 15
	:value-x                106
	:value-y                15
	:value-length           16
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   r_nsid_msg
	:owner                  remote_spi_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  79
	:height                 13
	:foreground-color       ""
	:label                  "Remote SPI:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   raw_algs_panel
	:owner                  netwin_raw
	:help                   ""
	:x                      0
	:y                      212
	:width                  340
	:height                 92
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  raw_algs_panel
	:help                   ""
	:x                      164
	:y                      16
	:width                  66
	:height                 23
	:value-x                164
	:value-y                16
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  raw_algs_panel
	:help                   ""
	:x                      20
	:y                      21
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   mac_alg
	:owner                  raw_algs_panel
	:help                   ""
	:x                      164
	:y                      48
	:width                  56
	:height                 23
	:value-x                164
	:value-y                48
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mac_alg_msg
	:owner                  raw_algs_panel
	:help                   ""
	:x                      20
	:y                      53
	:width                  104
	:height                 13
	:foreground-color       ""
	:label                  "Authentication:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  netwin_raw
	:help                   ""
	:x                      0
	:y                      303
	:width                  340
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_raw win_apply)
		:when                   (Notify )
		:to                     (netwin_raw win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->netwin_raw, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_raw win_cancel)
		:when                   (Notify )
		:to                     (netwin_raw win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->netwin_raw, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   netwin
	:owner                  base_window
	:width                  340
	:height                 109
	:background-color       ""
	:foreground-color       ""
	:label                  "Network properties"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   net_panel
	:owner                  netwin
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   net_label
	:owner                  net_panel
	:help                   ""
	:x                      60
	:y                      17
	:width                  59
	:height                 13
	:foreground-color       ""
	:label                  "Network:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   addr
	:owner                  net_panel
	:help                   ""
	:x                      136
	:y                      17
	:width                  184
	:height                 15
	:value-x                136
	:value-y                17
	:value-length           23
	:stored-length          24
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  net_panel
	:help                   ""
	:x                      20
	:y                      20
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "none.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mask_label
	:owner                  net_panel
	:help                   ""
	:x                      60
	:y                      39
	:width                  63
	:height                 13
	:foreground-color       ""
	:label                  "Netmask:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   mask
	:owner                  net_panel
	:help                   ""
	:x                      136
	:y                      39
	:width                  184
	:height                 15
	:value-x                136
	:value-y                39
	:value-length           23
	:stored-length          24
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "255.255.255.0"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  netwin
	:help                   ""
	:x                      0
	:y                      69
	:width                  340
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (netwin win_apply)
		:when                   (Notify )
		:to                     (netwin win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->netwin, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (netwin win_cancel)
		:when                   (Notify )
		:to                     (netwin win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->netwin, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   netwin_v1
	:owner                  base_window
	:width                  340
	:height                 329
	:background-color       ""
	:foreground-color       ""
	:label                  "SKIP version 1 properties"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   net_panel
	:owner                  netwin_v1
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   net_label
	:owner                  net_panel
	:help                   ""
	:x                      60
	:y                      17
	:width                  59
	:height                 13
	:foreground-color       ""
	:label                  "Network:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   addr
	:owner                  net_panel
	:help                   ""
	:x                      136
	:y                      17
	:width                  184
	:height                 15
	:value-x                136
	:value-y                17
	:value-length           23
	:stored-length          24
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  net_panel
	:help                   ""
	:x                      20
	:y                      20
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "icon_v1.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mask_label
	:owner                  net_panel
	:help                   ""
	:x                      60
	:y                      39
	:width                  63
	:height                 13
	:foreground-color       ""
	:label                  "Netmask:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   mask
	:owner                  net_panel
	:help                   ""
	:x                      136
	:y                      39
	:width                  184
	:height                 15
	:value-x                136
	:value-y                39
	:value-length           23
	:stored-length          24
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "255.255.255.0"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_remote_keyid_panel
	:owner                  netwin_v1
	:help                   ""
	:x                      0
	:y                      69
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   keyid
	:owner                  v1_remote_keyid_panel
	:help                   ""
	:x                      136
	:y                      15
	:width                  184
	:height                 15
	:value-x                136
	:value-y                15
	:value-length           23
	:stored-length          30
	:rows                   2
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message25
	:owner                  v1_remote_keyid_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  56
	:height                 13
	:foreground-color       ""
	:label                  "Node ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_local_keyid_panel
	:owner                  netwin_v1
	:help                   ""
	:x                      0
	:y                      113
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   local_keyid
	:owner                  v1_local_keyid_panel
	:help                   ""
	:x                      164
	:y                      11
	:width                  137
	:height                 23
	:value-x                164
	:value-y                11
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("default local key" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message11
	:owner                  v1_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  86
	:height                 13
	:foreground-color       ""
	:label                  "Local key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   tunnel_address_panel
	:owner                  netwin_v1
	:help                   ""
	:x                      0
	:y                      157
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   tunnel_label
	:owner                  tunnel_address_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  111
	:height                 13
	:foreground-color       ""
	:label                  "Tunnel Address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tunnel_addr
	:owner                  tunnel_address_panel
	:help                   ""
	:x                      164
	:y                      16
	:width                  160
	:height                 15
	:value-x                164
	:value-y                16
	:value-length           20
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_algs_panel
	:owner                  netwin_v1
	:help                   ""
	:x                      0
	:y                      201
	:width                  340
	:height                 90
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kij_alg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      164
	:y                      14
	:width                  66
	:height                 23
	:value-x                164
	:value-y                14
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kp_alg_msg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      20
	:y                      19
	:width                  106
	:height                 13
	:foreground-color       ""
	:label                  "Key encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      164
	:y                      46
	:width                  66
	:height                 23
	:value-x                164
	:value-y                46
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      20
	:y                      51
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  netwin_v1
	:help                   ""
	:x                      0
	:y                      289
	:width                  340
	:height                 40
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_v1 win_apply)
		:when                   (Notify )
		:to                     (netwin_v1 win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->netwin_v1, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_v1 win_cancel)
		:when                   (Notify )
		:to                     (netwin_v1 win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->netwin_v1, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   nomwin_v1
	:owner                  base_window
	:width                  340
	:height                 310
	:background-color       ""
	:foreground-color       ""
	:label                  "SKIP version 1 (Nomadic)"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_nomadic_panel
	:owner                  nomwin_v1
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 55
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  v1_nomadic_panel
	:help                   ""
	:x                      20
	:y                      20
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "icon_v1.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   keyid
	:owner                  v1_nomadic_panel
	:help                   ""
	:x                      60
	:y                      22
	:width                  264
	:height                 15
	:value-x                124
	:value-y                22
	:value-length           25
	:stored-length          30
	:rows                   2
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "Node ID:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   controls3
	:owner                  nomwin_v1
	:help                   ""
	:x                      0
	:y                      54
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   tunnel_label
	:owner                  controls3
	:help                   ""
	:x                      20
	:y                      16
	:width                  111
	:height                 13
	:foreground-color       ""
	:label                  "Tunnel Address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tunnel_addr
	:owner                  controls3
	:help                   ""
	:x                      164
	:y                      16
	:width                  160
	:height                 15
	:value-x                164
	:value-y                16
	:value-length           20
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_local_keyid_panel
	:owner                  nomwin_v1
	:help                   ""
	:x                      0
	:y                      98
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   local_keyid
	:owner                  v1_local_keyid_panel
	:help                   ""
	:x                      164
	:y                      11
	:width                  137
	:height                 23
	:value-x                164
	:value-y                11
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("default local key" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message17
	:owner                  v1_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  86
	:height                 13
	:foreground-color       ""
	:label                  "Local key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v1_algs_panel
	:owner                  nomwin_v1
	:help                   ""
	:x                      0
	:y                      141
	:width                  340
	:height                 90
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kij_alg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      164
	:y                      14
	:width                  66
	:height                 23
	:value-x                164
	:value-y                14
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kp_alg_msg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      20
	:y                      19
	:width                  106
	:height                 13
	:foreground-color       ""
	:label                  "Key encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      164
	:y                      46
	:width                  66
	:height                 23
	:value-x                164
	:value-y                46
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  v1_algs_panel
	:help                   ""
	:x                      20
	:y                      51
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   current_addr_panel
	:owner                  nomwin_v1
	:help                   ""
	:x                      0
	:y                      228
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   current_addr
	:owner                  current_addr_panel
	:help                   ""
	:x                      164
	:y                      15
	:width                  160
	:height                 15
	:value-x                164
	:value-y                15
	:value-length           20
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       nil
	:initial-value          "*"
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message7
	:owner                  current_addr_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  114
	:height                 13
	:foreground-color       ""
	:label                  "Current Address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  nomwin_v1
	:help                   ""
	:x                      0
	:y                      272
	:width                  340
	:height                 38
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (nomwin_v1 win_apply)
		:when                   (Notify )
		:to                     (nomwin_v1 win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->nomwin_v1, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (nomwin_v1 win_cancel)
		:when                   (Notify )
		:to                     (nomwin_v1 win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->nomwin_v1, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   nomwin_v2
	:owner                  base_window
	:width                  340
	:height                 440
	:background-color       ""
	:foreground-color       ""
	:label                  "SKIP properties (Nomadic)"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_nomadic_panel
	:owner                  nomwin_v2
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 80
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   r_nsid
	:owner                  v2_nomadic_panel
	:help                   ""
	:x                      164
	:y                      18
	:width                  115
	:height                 23
	:value-x                164
	:value-y                18
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("IPv4 Address" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (nomwin_v2 r_nsid)
		:when                   (Notify )
		:to                     (nomwin_v2 keyid)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->keyid, PANEL_VALUE, \"\", NULL);")
		)
	)
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  v2_nomadic_panel
	:help                   ""
	:x                      20
	:y                      20
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "icon_v2.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   r_nsid_msg
	:owner                  v2_nomadic_panel
	:help                   ""
	:x                      54
	:y                      23
	:width                  102
	:height                 13
	:foreground-color       ""
	:label                  "Remote Key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   keyid
	:owner                  v2_nomadic_panel
	:help                   ""
	:x                      20
	:y                      48
	:width                  298
	:height                 15
	:value-x                46
	:value-y                48
	:value-length           34
	:stored-length          80
	:rows                   2
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "ID:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   tunnel_transport_panel
	:owner                  nomwin_v2
	:help                   ""
	:x                      0
	:y                      78
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   skip_mode
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      10
	:width                  117
	:height                 23
	:value-x                164
	:value-y                10
	:rows                   0
	:columns                1
	:layout-type            :vertical
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Whole packet" "Data only" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message20
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      15
	:width                  49
	:height                 13
	:foreground-color       ""
	:label                  "Secure:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   tunnel_label
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      41
	:width                  110
	:height                 13
	:foreground-color       ""
	:label                  "Tunnel address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tunnel_addr
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      41
	:width                  152
	:height                 15
	:value-x                164
	:value-y                41
	:value-length           19
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_local_keyid_panel
	:owner                  nomwin_v2
	:help                   ""
	:x                      0
	:y                      147
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   s_nsid
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      164
	:y                      9
	:width                  107
	:height                 23
	:value-x                164
	:value-y                9
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Not present" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (nomwin_v2 s_nsid)
		:when                   (Notify )
		:to                     (nomwin_v2 s_nsid)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("s_nsid_nomwin_v2_callback(ip);")
		)
	)
)
(
	:type                   :message
	:name                   s_nsid_msg
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      14
	:width                  87
	:height                 13
	:foreground-color       ""
	:label                  "Local Key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   local_keyid
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      34
	:width                  163
	:height                 23
	:value-x                46
	:value-y                34
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "ID:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("default local key" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_algs_panel
	:owner                  nomwin_v2
	:help                   ""
	:x                      0
	:y                      216
	:width                  340
	:height                 145
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kij_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      8
	:width                  66
	:height                 23
	:value-x                164
	:value-y                8
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kp_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      13
	:width                  106
	:height                 13
	:foreground-color       ""
	:label                  "Key encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      40
	:width                  66
	:height                 23
	:value-x                164
	:value-y                40
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      45
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   mac_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      72
	:width                  56
	:height                 23
	:value-x                164
	:value-y                72
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mac_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      77
	:width                  104
	:height                 13
	:foreground-color       ""
	:label                  "Authentication:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   comp_alg2
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      104
	:width                  56
	:height                 23
	:value-x                164
	:value-y                104
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message21
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      109
	:width                  94
	:height                 13
	:foreground-color       ""
	:label                  "Compression:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   current_addr_panel
	:owner                  nomwin_v2
	:help                   ""
	:x                      0
	:y                      360
	:width                  340
	:height                 45
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   current_addr
	:owner                  current_addr_panel
	:help                   ""
	:x                      164
	:y                      15
	:width                  160
	:height                 15
	:value-x                164
	:value-y                15
	:value-length           20
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       nil
	:initial-value          "*"
	:initial-state          :active
	:read-only              t
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message22
	:owner                  current_addr_panel
	:help                   ""
	:x                      20
	:y                      16
	:width                  114
	:height                 13
	:foreground-color       ""
	:label                  "Current Address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  nomwin_v2
	:help                   ""
	:x                      0
	:y                      404
	:width                  340
	:height                 36
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (nomwin_v2 win_apply)
		:when                   (Notify )
		:to                     (nomwin_v2 win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->nomwin_v2, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (nomwin_v2 win_cancel)
		:when                   (Notify )
		:to                     (nomwin_v2 win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->nomwin_v2, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :popup-window
	:name                   netwin_v2
	:owner                  base_window
	:width                  340
	:height                 457
	:background-color       ""
	:foreground-color       ""
	:label                  "SKIP network properties"
	:label-type             :string
	:initial-state          :invisible
	:show-footer            nil
	:resizable              nil
	:pinned                 nil
	:done-handler           nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   net_panel
	:owner                  netwin_v2
	:help                   ""
	:x                      0
	:y                      0
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   net_label
	:owner                  net_panel
	:help                   ""
	:x                      60
	:y                      17
	:width                  59
	:height                 13
	:foreground-color       ""
	:label                  "Network:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   addr
	:owner                  net_panel
	:help                   ""
	:x                      136
	:y                      17
	:width                  184
	:height                 15
	:value-x                136
	:value-y                17
	:value-length           23
	:stored-length          24
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   skip_icon
	:owner                  net_panel
	:help                   ""
	:x                      20
	:y                      20
	:width                  22
	:height                 16
	:foreground-color       ""
	:label                  "icon_v2.xbm"
	:label-type             :glyph
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mask_label
	:owner                  net_panel
	:help                   ""
	:x                      60
	:y                      39
	:width                  63
	:height                 13
	:foreground-color       ""
	:label                  "Netmask:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   mask
	:owner                  net_panel
	:help                   ""
	:x                      136
	:y                      39
	:width                  184
	:height                 15
	:value-x                136
	:value-y                39
	:value-length           23
	:stored-length          24
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          "255.255.255.0"
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   tunnel_transport_panel
	:owner                  netwin_v2
	:help                   ""
	:x                      0
	:y                      68
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   skip_mode
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      11
	:width                  117
	:height                 23
	:value-x                164
	:value-y                11
	:rows                   0
	:columns                1
	:layout-type            :vertical
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Whole packet" "Data only" )
	:choice-label-types     (:string :string )
	:choice-colors          ("" "" )
	:choice-defaults        (nil nil )
	:initial-selections     (nil nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_v2 skip_mode "Whole packet")
		:when                   (Notify )
		:to                     (netwin_v2 tunnel_label)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_label, PANEL_INACTIVE, FALSE, NULL);")
		)
		(
		:from                   (netwin_v2 skip_mode "Data only")
		:when                   (Notify )
		:to                     (netwin_v2 tunnel_label)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_label, PANEL_INACTIVE, TRUE, NULL);")
		)
		(
		:from                   (netwin_v2 skip_mode "Whole packet")
		:when                   (Notify )
		:to                     (netwin_v2 tunnel_addr)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_addr, PANEL_INACTIVE, FALSE, NULL);")
		)
		(
		:from                   (netwin_v2 skip_mode "Data only")
		:when                   (Notify )
		:to                     (netwin_v2 tunnel_addr)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->tunnel_addr, PANEL_INACTIVE, TRUE, NULL);")
		)
	)
)
(
	:type                   :message
	:name                   message18
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      15
	:width                  49
	:height                 13
	:foreground-color       ""
	:label                  "Secure:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   tunnel_label
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      20
	:y                      41
	:width                  110
	:height                 13
	:foreground-color       ""
	:label                  "Tunnel address:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   tunnel_addr
	:owner                  tunnel_transport_panel
	:help                   ""
	:x                      164
	:y                      41
	:width                  152
	:height                 15
	:value-x                164
	:value-y                41
	:value-length           19
	:stored-length          80
	:rows                   3
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  ""
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_remote_keyid_panel
	:owner                  netwin_v2
	:help                   ""
	:x                      0
	:y                      137
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   r_nsid
	:owner                  v2_remote_keyid_panel
	:help                   ""
	:x                      164
	:y                      13
	:width                  107
	:height                 23
	:value-x                164
	:value-y                13
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Not present" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_v2 r_nsid)
		:when                   (Notify )
		:to                     (netwin_v2 keyid)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("xv_set(ip->keyid, PANEL_VALUE, \"\", NULL);")
		)
	)
)
(
	:type                   :message
	:name                   r_nsid_msg
	:owner                  v2_remote_keyid_panel
	:help                   ""
	:x                      20
	:y                      15
	:width                  102
	:height                 13
	:foreground-color       ""
	:label                  "Remote Key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :text-field
	:name                   keyid
	:owner                  v2_remote_keyid_panel
	:help                   ""
	:x                      20
	:y                      39
	:width                  298
	:height                 15
	:value-x                46
	:value-y                39
	:value-length           34
	:stored-length          80
	:rows                   2
	:foreground-color       ""
	:text-type              :alphanumeric
	:label                  "ID:"
	:label-type             :string
	:layout-type            :horizontal
	:value-underlined       t
	:initial-value          ""
	:initial-state          :active
	:read-only              nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_local_keyid_panel
	:owner                  netwin_v2
	:help                   ""
	:x                      0
	:y                      206
	:width                  340
	:height                 70
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   s_nsid
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      164
	:y                      9
	:width                  107
	:height                 23
	:value-x                164
	:value-y                9
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Not present" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_v2 s_nsid)
		:when                   (Notify )
		:to                     (netwin_v2 s_nsid)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("s_nsid_netwin_v2_callback(ip);")
		)
	)
)
(
	:type                   :message
	:name                   s_nsid_msg
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      14
	:width                  87
	:height                 13
	:foreground-color       ""
	:label                  "Local Key ID:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   local_keyid
	:owner                  v2_local_keyid_panel
	:help                   ""
	:x                      20
	:y                      34
	:width                  163
	:height                 23
	:value-x                46
	:value-y                34
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  "ID:"
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("default local key" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   v2_algs_panel
	:owner                  netwin_v2
	:help                   ""
	:x                      0
	:y                      275
	:width                  340
	:height                 145
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kij_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      8
	:width                  66
	:height                 23
	:value-x                164
	:value-y                8
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kp_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      13
	:width                  106
	:height                 13
	:foreground-color       ""
	:label                  "Key encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   kp_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      40
	:width                  66
	:height                 23
	:value-x                164
	:value-y                40
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("none" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   kij_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      45
	:width                  128
	:height                 13
	:foreground-color       ""
	:label                  "Traffic encryption:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   mac_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      72
	:width                  56
	:height                 23
	:value-x                164
	:value-y                72
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :active
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   mac_alg_msg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      77
	:width                  104
	:height                 13
	:foreground-color       ""
	:label                  "Authentication:"
	:label-type             :string
	:label-bold             t
	:initial-state          :active
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :setting
	:name                   comp_alg
	:owner                  v2_algs_panel
	:help                   ""
	:x                      164
	:y                      104
	:width                  56
	:height                 23
	:value-x                164
	:value-y                104
	:rows                   0
	:columns                1
	:layout-type            :horizontal
	:foreground-color       ""
	:setting-type           :stack
	:selection-required     t
	:label                  ""
	:label-type             :string
	:notify-handler         nil
	:event-handler          nil
	:choices                ("Off" )
	:choice-label-types     (:string )
	:choice-colors          ("" )
	:choice-defaults        (nil )
	:initial-selections     (nil )
	:initial-state          :inactive
	:user-data              ()
	:actions                ()
)
(
	:type                   :message
	:name                   message19
	:owner                  v2_algs_panel
	:help                   ""
	:x                      20
	:y                      109
	:width                  94
	:height                 13
	:foreground-color       ""
	:label                  "Compression:"
	:label-type             :string
	:label-bold             t
	:initial-state          :inactive
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :control-area
	:name                   apply_cancel_panel
	:owner                  netwin_v2
	:help                   ""
	:x                      0
	:y                      419
	:width                  340
	:height                 38
	:background-color       ""
	:foreground-color       ""
	:initial-state          :visible
	:show-border            t
	:menu                   nil
	:event-handler          nil
	:user-data              ()
	:actions                ()
)
(
	:type                   :button
	:name                   win_apply
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      81
	:y                      10
	:width                  53
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Apply"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_v2 win_apply)
		:when                   (Notify )
		:to                     (netwin_v2 win_apply)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_apply(xv_get(ip->netwin_v2, WIN_CLIENT_DATA));")
		)
	)
)
(
	:type                   :button
	:name                   win_cancel
	:owner                  apply_cancel_panel
	:help                   ""
	:x                      201
	:y                      10
	:width                  59
	:height                 19
	:constant-width         nil
	:button-type            :normal
	:foreground-color       ""
	:label                  "Cancel"
	:label-type             :string
	:initial-state          :active
	:menu                   nil
	:notify-handler         nil
	:event-handler          nil
	:user-data              ()
	:actions                (
		(
		:from                   (netwin_v2 win_cancel)
		:when                   (Notify )
		:to                     (netwin_v2 win_cancel)
		:function_type          ExecuteCode
		:arg_type               (:string)
		:action                 ("es_win_cancel(xv_get(ip->netwin_v2, WIN_CLIENT_DATA));")
		)
	)
)
)
