#ifndef GABA_DEFINE
struct parser
{
  struct read_handler super;
  struct exception_handler *e;
  struct read_handler *next;
};
extern struct lsh_class parser_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_parser_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parser *i = (struct parser *) o;
  mark((struct lsh_object *) i->e);
  mark((struct lsh_object *) i->next);
}

struct lsh_class parser_class =
{ STATIC_HEADER,
  &read_handler_class, "parser", sizeof(struct parser),
  do_parser_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct parse_value
{
  struct parser super;
  struct command_continuation *c;
};
extern struct lsh_class parse_value_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_parse_value_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse_value *i = (struct parse_value *) o;
  mark((struct lsh_object *) i->c);
}

struct lsh_class parse_value_class =
{ STATIC_HEADER,
  &parser_class, "parse_value", sizeof(struct parse_value),
  do_parse_value_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct string_handler
{
  struct lsh_object super;
  void (*(handler))(struct string_handler *self, struct lsh_string *s);
};
extern struct lsh_class string_handler_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class string_handler_class =
{ STATIC_HEADER,
  0, "string_handler", sizeof(struct string_handler),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct parse_string
{
  struct parser super;
  struct string_handler *handler;
};
extern struct lsh_class parse_string_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_parse_string_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse_string *i = (struct parse_string *) o;
  mark((struct lsh_object *) i->handler);
}

struct lsh_class parse_string_class =
{ STATIC_HEADER,
  &parser_class, "parse_string", sizeof(struct parse_string),
  do_parse_string_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct parse_literal_data
{
  struct parse_string super;
  UINT32 i;
  struct lsh_string *data;
};
extern struct lsh_class parse_literal_data_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_parse_literal_data_free(struct lsh_object *o)
{
  struct parse_literal_data *i = (struct parse_literal_data *) o;
  lsh_string_free(i->data);
}

struct lsh_class parse_literal_data_class =
{ STATIC_HEADER,
  &parse_string_class, "parse_literal_data", sizeof(struct parse_literal_data),
  NULL,
  do_parse_literal_data_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct parse_length
{
  struct parse_string super;
  UINT32 length;
};
extern struct lsh_class parse_length_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class parse_length_class =
{ STATIC_HEADER,
  &parse_string_class, "parse_length", sizeof(struct parse_length),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct return_string
{
  struct string_handler super;
  struct command_continuation *c;
};
extern struct lsh_class return_string_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_return_string_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct return_string *i = (struct return_string *) o;
  mark((struct lsh_object *) i->c);
}

struct lsh_class return_string_class =
{ STATIC_HEADER,
  &string_handler_class, "return_string", sizeof(struct return_string),
  do_return_string_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct parse_skip
{
  struct parser super;
  UINT8 expect;
};
extern struct lsh_class parse_skip_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
struct lsh_class parse_skip_class =
{ STATIC_HEADER,
  &parser_class, "parse_skip", sizeof(struct parse_skip),
  NULL,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct handle_display
{
  struct string_handler super;
  struct lsh_string *display;
  struct command_continuation *c;
};
extern struct lsh_class handle_display_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_handle_display_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct handle_display *i = (struct handle_display *) o;
  mark((struct lsh_object *) i->c);
}

static void do_handle_display_free(struct lsh_object *o)
{
  struct handle_display *i = (struct handle_display *) o;
  lsh_string_free(i->display);
}

struct lsh_class handle_display_class =
{ STATIC_HEADER,
  &string_handler_class, "handle_display", sizeof(struct handle_display),
  do_handle_display_mark,
  do_handle_display_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct handle_element
{
  struct command_continuation super;
  unsigned count;
  struct object_queue l;
};
extern struct lsh_class handle_element_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_handle_element_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct handle_element *i = (struct handle_element *) o;
  object_queue_mark(&i->l, mark);
}

static void do_handle_element_free(struct lsh_object *o)
{
  struct handle_element *i = (struct handle_element *) o;
  object_queue_free(&i->l);
}

struct lsh_class handle_element_class =
{ STATIC_HEADER,
  &command_continuation_class, "handle_element", sizeof(struct handle_element),
  do_handle_element_mark,
  do_handle_element_free
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct parse_list
{
  struct parse_value super;
  struct handle_element *elements;
  int advanced;
  struct read_handler *start;
};
extern struct lsh_class parse_list_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_parse_list_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse_list *i = (struct parse_list *) o;
  mark((struct lsh_object *) i->elements);
  mark((struct lsh_object *) i->start);
}

struct lsh_class parse_list_class =
{ STATIC_HEADER,
  &parse_value_class, "parse_list", sizeof(struct parse_list),
  do_parse_list_mark,
  NULL
};
#endif /* !GABA_DECLARE */

#ifndef GABA_DEFINE
struct parse_base64
{
  struct parser super;
  struct base64_state state;
  struct read_handler *inner;
};
extern struct lsh_class parse_base64_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void do_parse_base64_mark(struct lsh_object *o, 
void (*mark)(struct lsh_object *o))
{
  struct parse_base64 *i = (struct parse_base64 *) o;
  mark((struct lsh_object *) i->inner);
}

struct lsh_class parse_base64_class =
{ STATIC_HEADER,
  &parser_class, "parse_base64", sizeof(struct parse_base64),
  do_parse_base64_mark,
  NULL
};
#endif /* !GABA_DECLARE */

