/*
 *  $Id: dentry.c,v 1.1 1998/12/02 23:37:05 ezk Exp $
 */

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif /* HAVE_CONFIG_H */
#include <fist.h>
#include <cryptfs.h>


/*
 * XXX: unsure of this implementation. there may be bugs in cached_lookup
 * in that we don'tunderstand why it will run d_invalidate after a
 * succesful file system's d_revalidate.
 */
STATIC int
cryptfs_d_revalidate(dentry_t *dentry)
{
    int err = 0;
    dentry_t *hidden_dentry = cryptfs_hidden_dentry(dentry);

    print_entry_location();

    if (!hidden_dentry->d_op || !hidden_dentry->d_op->d_revalidate)
	goto out;

    err = hidden_dentry->d_op->d_revalidate(hidden_dentry);

 out:
    print_exit_status(err);
    return err;
}


STATIC int
cryptfs_d_hash(dentry_t *dentry, qstr_t *name)
{
    int err = 0;
    dentry_t *hidden_dentry = cryptfs_hidden_dentry(dentry);

    print_entry_location();

    if (!hidden_dentry->d_op || !hidden_dentry->d_op->d_hash)
	goto out;

    err = hidden_dentry->d_op->d_hash(hidden_dentry, name);

 out:
    print_exit_status(err);
    return err;
}


STATIC int
cryptfs_d_compare(dentry_t *dentry, qstr_t *a, qstr_t *b)
{
    int err;
    dentry_t *hidden_dentry = cryptfs_hidden_dentry(dentry);

    print_entry_location();

    if (hidden_dentry->d_op && hidden_dentry->d_op->d_compare) {
	err = hidden_dentry->d_op->d_compare(hidden_dentry, a, b);
    } else {
	err = ((a->len != b->len) || memcmp(a->name, b->name, b->len));
    }

    print_exit_status(err);
    return err;
}


#ifdef NOT_NEEDED
/*
 * Not needed because the real place where dput() needs to free up
 * private dentry resources in right before the actual destruction of
 * the dentry, which is done in d_free, called from dput().
 */
STATIC void
cryptfs_d_delete(dentry_t *dentry)
{
    fist_print_dentry("cryptfs_d_delete dentry", dentry);
    if (dentry)
	fist_print_inode("cryptfs_d_delete inode", dentry->d_inode);
}
#endif /* NOT_NEEDED */

/*
 * XXX: we may have a problem with ever increasing dentry refcounts
 * if so, we may have to add a new dentry op d_dput which will have
 * to be called from dput().
 */
STATIC
void
cryptfs_d_release(dentry_t *dentry)
{
    dentry_t *hidden_dentry = cryptfs_hidden_dentry(dentry);

    print_entry_location();
    fist_print_dentry("cryptfs_d_release IN hidden_dentry", hidden_dentry);
    if (hidden_dentry->d_inode)
	fist_dprint(6, "cryptfs_d_release: hidden_inode->i_count %d, i_num %lu.\n",
		    hidden_dentry->d_inode->i_count,
		    hidden_dentry->d_inode->i_ino
		    );
    dput(hidden_dentry);

    /* XXX: free private data (cryptfs_dentry_info) here */
    print_exit_location();
}


/*
 * we don't need cryptfs_iput, because dentry_iput will call iput() if
 * d_iput is not defined, and iput() will eventually call clear_inode(),
 * will calls our clear_inode(), which does a dput().  dput() will decrement
 * the refcount of the hidden dentry, and if zero, will call dentry_iput()
 * on the hidden dentry, calling the hidden file system's d_iput if defined.
 * We left this implemented for ease of tracing/debugging.
 */
STATIC void
cryptfs_d_iput(dentry_t *dentry, inode_t *inode)
{
    print_entry_location();
    iput(inode);
    print_exit_location();
}


struct dentry_operations cryptfs_dops = {
    cryptfs_d_revalidate,	/* revalidate */
    cryptfs_d_hash,		/* hash */
    cryptfs_d_compare,		/* compare */
#if 0
    cryptfs_d_delete,		/* delete */
#else
    NULL,			/* delete */
#endif
    cryptfs_d_release,		/* release */
    cryptfs_d_iput		/* iput */
};


/*
 * Local variables:
 * c-basic-offset: 4
 * End:
 */
