/* rand_key.c */
/* Copyright (C) 1995 Eric Young (eay@mincom.oz.au).
 * All rights reserved.
 * Copyright remains Eric Young's, and as such any Copyright notices in
 * the code are not to be removed.
 * See the COPYRIGHT file in the libdes distribution for more details.
 */

#include "des_locl.h"

static int seed=0;
static des_cblock init;

void des_random_seed(key)
des_cblock key;
	{
	bcopy(key,init,sizeof(key));
	seed=1;
	}

int des_random_key(ret)
des_cblock ret;
	{
	extern unsigned short getpid();
	extern unsigned long time();
	des_key_schedule ks;
	static unsigned long c=0;
	static unsigned short pid=0;
	static des_cblock data={0x01,0x23,0x45,0x67,0x89,0xab,0xcd,0xef};
	des_cblock key;
	unsigned char *p;
	unsigned long t;
	int i;

#ifdef MSDOS
	pid=1;
#else
	if (!pid) pid=getpid();
#endif
	p=key;
	if (seed)
		{
		for (i=0; i<8; i++)
			{
			data[i] ^= init[i];
			init[i]=0;
			}
		seed=0;
		}
	t=(unsigned long)time(NULL);
	l2c(t,p);
	t=(unsigned long)((pid)|((c++)<<16));
	l2c(t,p);

	des_set_odd_parity((des_cblock *)data);
	des_set_key((des_cblock *)data,ks);
	des_cbc_cksum((des_cblock *)key,(des_cblock *)key,
		(long)sizeof(key),ks,(des_cblock *)data);

	des_set_odd_parity((des_cblock *)key);
	des_set_key((des_cblock *)key,ks);
	des_cbc_cksum((des_cblock *)key,(des_cblock *)data,
		(long)sizeof(key),ks,(des_cblock *)key);

	bcopy(data,ret,sizeof(key));
	bzero(key,sizeof(key));
	bzero(ks,sizeof(ks));
	t=0;
	return(0);
	}
