#!/bin/sh
#
#pragma ident "@(#)install_skip_keys.sh	1.24 96/08/08"
#
# Script to install the issued key package or SUN ICG key package
# onto an End-system SKIP node


bombout(){
	echo "$1  - Exiting...."
	exit 1
}

install_icg_keys(){
	if [ $# -lt 1 ]
	then
		echo "$0 -icg [dirname]"
		exit 1
	fi

	dirname=$1
	if [ ! -d $dirname ]
	then
		echo "$0 -icg [dirname]"
		exit 1;
	fi

	if [ ! -f "$dirname/dh.key" ]
	then
		bombout "File dh.key is missing from $dirname"
	fi

	if [ ! -f "$dirname/dh.crt" ]
	then
		bombout "File dh.crt is missing from $dirname"
	fi

	if [ ! -f "$dirname/sunicg_c" ]
	then
		bombout "File sunicg_c is missing from $dirname"
	fi

	skipca add $dirname/sunicg_c
	if [ $? -eq 1 ]
	then
		bombout "Unable to add Trusted CA"
	elsif [ $? -eq 2]
		echo "Non-fatal error, continuing..."
	fi

	if [ -f $dirname/secret_i ]
	then
		sf=$dirname/secret_i
		so=-s
	else
		sf=$dirname/dh.key
		so=-S
	fi

	skiplocal add $so $sf -c $dirname/dh.crt -t x509 -o soft -n 1
	if [ $? -eq 1 ]
	then
		bombout "Unable to create local identity"
	fi

	skipdb add -n 1 -t x509 $dirname/dh.crt
	if [ $? -eq 1 ]
	then 
		bombout "Unable to add my own certificate to the database"
	fi
}

install_pkg_keys(){
	filename=$1
	DIR=/tmp/skip$$
	mkdir $DIR
	cp $1 $DIR/tempfile
	cd $DIR
	
	if (grep 'begin' tempfile >/dev/null)
	then
		echo "$0: uudecode..."
		uudecode <tempfile
	elif (grep 'BEGIN PGP MESSAGE' tempfile >/dev/null)
	then
		echo "$0: running PGP to decrypt..."
		cat tempfile | pgp -f >keys.tar
	else
		bombout "$0 file does not appear to be key file."
	fi
	
	tar -xf keys.tar

#	Disgusto hack so that old ZA CA certificates will be understood
	if [ -f my_X509_cert ]
	then
		md5 my_X509_cert my_secret_i ZeroAssurance_Cert > md5.newsums
	else
		md5 dh_params my_dh_cert my_dh_secret my_secret_i ZeroAssurance_Cert > md5.newsums
	fi
	
	echo "Comparing MD5 checksums..."
	diff md5.newsums md5.sums 
	
	if [ $? -ne 0 ]
	then
		bombout "$0: md5 sums do not match!!!"
	fi
	echo "$0: checksums are good."
	echo "$0: Moving files into place...."
	
	skipca add ZeroAssurance_Cert
	if [ $? -eq 1 ]
	then
		bombout "Unable to add CA certificate"
	fi

#	Disgusto hack so that old ZA CA certificates will be understood
	if [ -f my_X509_cert ]
	then
		skiplocal add -s my_secret_i -c my_X509_cert -t x509 -o soft -n 1
		if [ $? -eq 1 ]
		then
			bombout "Unable to create local identity"
		fi
		
		skipdb add -n 1 -t x509 my_X509_cert	
		if [ $? -eq 1 ]
		then
			bombout "Couldn't add my own certificate to the DB"
		fi
	else
		skiplocal add -s my_secret_i -c my_dh_cert -t x509 -o soft -n 1
		if [ $? -eq 1 ]
		then
			bombout "Unable to create local identity"
		fi
		skipdb add -n 1 -t x509 my_dh_cert	
		if [ $? -eq 1 ]
		then
			bombout "Couldn't add my own certificate to the DB"
		fi
	fi
	cd /tmp
	rm -rf $DIR
}


SUNOS=`uname -r | sed 's/\..*//g'`
if [ $SUNOS = 5 ]; then
	SKIP_BIN=/opt/SUNWicg/bin
	SKIP_ETC=/etc/opt/SUNWicg/skip
else
	SKIP_BIN=/usr/skip/bin
	SKIP_ETC=/etc/skip
fi

SKIP_PATH=${SKIP_PATH-$SKIP_BIN}
PATH=${SKIP_PATH}:/bin:/usr/ucb:$PATH export PATH

if [ $# -lt 1 ]
then
	echo "$0 certificate-file | floppy-path "
	exit 1
fi
USER=`whoami`

if [ $USER != "root" ]
then
	echo "$0: you must be root to run this command."
	exit 1
fi

if [ ! -d $SKIP_PATH ]; then
	echo "$0: cannot find $SKIP_PATH - is SKIP installed?"
	exit 1
fi

if [ ! -d $SKIP_ETC ]; then
	echo "$0: cannot find $SKIP_ETC - is SKIP installed?"
	exit 1
fi

skiplocal init -q
skipca init -q

if [ "$1" = "-icg" ]
then
	shift
	if [ -f $1 ]
	then
		bombout "Path is not a directory.  Did you want to use -icg?"
	fi
	if [ -d $1 ]
	then
		install_icg_keys $*
	else
		bombout "Directory $1 Does not exist"
	fi
else
	if [ -d $1 ]
	then
		bombout "Path is a directory.  Did you want to use -icg?"
	fi
	if [ -f $1 ]
	then
		install_pkg_keys $*
	else 
		bombout "File $1 does not exist"	
	fi
fi
	
	
echo "$0: you should now reboot the machine to initialize SKIP."

exit 0
