/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)newcert.C	1.1 96/07/03 Sun Microsystems"

#include <stdio.h>
#include <string.h>
#include "Bstream.h"
#include "Bigint.h"
#include "Time.h"
#include "asn1_der.h"
#include "ObjId.h"
#include "Name.h"
#include "X509Cert.h"
#include "Sig.h"

#include "ca.h"
#include "utils.h"

// returns 0 on success or -1 on failure
int
newcert(char *certreqFile, char *certFile, int lifetime,
		Bstream& passphrase, ObjId& sigoid)
{
	int retval;
	Bstream nullbstr;
	PubKey pub_CA, pub_subject;
	Name issuer, subject;
	String errormsg;
	AlgId sigalg;

	camode = TRUE;
	sigalg.algid = sigoid;
	Bstream ca_certreq = File_to_Bstr(getcryptodir() + CA_CERTREQ_FILE);
  
	if (ca_certreq == nullbstr) {
		fprintf(stderr, "Unable to read %s\n", CA_CERTREQ_FILE);
		return(-1);
	}
	if ((retval = get_certreq_params(ca_certreq, issuer, pub_CA))) {
		fprintf(stderr,
		"Error in decoding CA certreq file %s\n", CA_CERTREQ_FILE);
		asn1_perror(retval);
		return(retval);
	}
	if ((retval = get_certreq_params(File_to_Bstr(certreqFile), 
			subject, pub_subject))) {
		fprintf(stderr,
			"Error in decoding subject certreq file %s\n",
			certreqFile);
		asn1_perror(retval);
		return(retval);
	}
	
	// check if a certificate is already issued for
	// this subject and public key
//	if (allow_certification(subject, pub_subject) == BOOL_FALSE) {
//		fprintf(stderr,
//		"Cannot issue a certificate for this request.\n");
//		return(-1);
//	}

	PCTime notbefore = timenow();
	GMtime gtime = notbefore.get();
	gtime.year += lifetime / 12;	// lifetime is in months
	gtime.month += lifetime % 12;	// 0 - 11 months
	if (gtime.month > 12) {
		gtime.year += gtime.month / 12;
		gtime.month = gtime.month % 12; // 1 - 11 months
	}
	PCTime notafter(gtime);

// XXX Change for HW signer
	Bstream priv_CA = getCAprivkey(passphrase, errormsg);
	if (priv_CA == nullbstr) {
		fprintf(stderr, "Error: %s\n", (const char *)errormsg);
		fprintf(stderr,
		"Unable to fetch CA private key, certificate not created\n");
		return(-1);
	}
	Bigint serialnum = getSerialnum();
	X509Cert cert(serialnum, sigalg, issuer, notbefore, notafter, subject,
			pub_subject);
	Bstream bercert = cert.sign_and_encode(priv_CA);

	// Verify the signature on certificate
	VerifyResult result = cert.verify(pub_CA);
	if (result != VALID) {
		fprintf(stderr, "Error in creating new certificate.\n");
		return(-1);
	}
	String certfilename = getcryptodir() + (String)CERT_DATABASE_DIR +
				DIR_MARKER + serialnum.getnumstr();
  
	bercert.store(certfilename);	// Fix for decimal # use XXX
	bercert.store(certFile);	// Fix for decimal # use XXX

	String temp;
	temp = serialnum.getnumstrd();
#ifdef DEBUG
	fprintf(stderr, "Succesfully created valid certificate # ");
	fprintf(stderr, "%s\n", (const char *)temp);
#endif
	return(0);
}
