/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_ioctl.c	1.42 96/10/01 Sun Microsystems"

/*
 * System includes
 */
#include <skip_os.h>

/*
 * SKIP includes
 */
#include <skip_proto.h>
#include <skip_types.h>
#include <skip_keymgrmsgs.h>
#include <skip_key.h>
#include <skip_ioctl.h>
#include <skip_crypt.h>
#include <skip_ah.h>

/*
 * skip end system global statistics
 */
extern ioctl_key_stat_t	skip_keys_stats;
extern ioctl_hdr_stat_t	skip_hdrs_stats;

/*
 * Set/Get var interface 
 */
extern int 	skip_server_port;
extern int	skip_params_debug;
extern int	skip_max_keyids;
extern int	skip_check_cdp_addr;

static skip_sym_t	skip_var[] = 
{
	{ &skip_key_debug,	SKIP_FMT_STD, "skip_key_debug" },
	{ &skip_key_max_bytes,	SKIP_FMT_STD, "skip_key_max_bytes" },
	{ &skip_key_max_idle,	SKIP_FMT_STD, "skip_key_max_idle" },
	{ &skip_key_max_use,	SKIP_FMT_STD, "skip_key_max_use" },
	{ &skip_max_keyids,	SKIP_FMT_STD, "skip_max_keyids" },
	{ &skip_params_debug,	SKIP_FMT_STD, "skip_params_debug" },
	{ &skip_server_port,	SKIP_FMT_NET, "skip_server_port" },
	{ &skip_check_cdp_addr,	SKIP_FMT_STD, "skip_check_cdp_addr" }
};

/* skip_get_key_stats()
 *
 *  Get SKIP keys statistics
 *
 * Returns: 0 on success, errno otherwise
 */
int
skip_get_key_stats(ioctl_key_stat_t *key_statp)
{

	BCOPY((caddr_t) &skip_keys_stats,
		(caddr_t) key_statp, sizeof(ioctl_key_stat_t));

	return(0);

}

/* skip_get_hdr_stats()
 *
 *  Get SKIP headers statistics
 *
 * Returns: 0 on success, errno otherwise
 */
int
skip_get_hdr_stats(ioctl_hdr_stat_t *hdr_statp)
{

	BCOPY((caddr_t) &skip_hdrs_stats,
		(caddr_t) hdr_statp, sizeof(ioctl_hdr_stat_t));

	return(0);

}


/* skip_get_kp_alg_list()
 *
 * List all loaded cryptor modules 
 *
 */
void
skip_get_kp_alg_list(ioctl_alg_list_t *alg_list)
{
	int		idxalg;
	skip_cryptor_t	*cp;
	skip_mac_t	*alg;

	/*
	 * Scan the V1 cryptors array for installed modules
	 */
	cp = &skip_cryptors_v1[0];
	for (idxalg = 0; idxalg < SKIP_MAXCRYPTORS; idxalg++) {

		if (cp->ekp_len == -1) {
			/*
			 * Module not present - skip it
			 */
			alg_list->flag_alg_v1[idxalg] = B_FALSE;
			cp++;
			continue;
		}
		alg_list->flag_alg_v1[idxalg] = B_TRUE;
		cp++;
	}

	/*
	 * Scan the V2 cryptors array for installed modules
	 */
	cp = &skip_cryptors[0];
	for (idxalg = 0; idxalg < SKIP_MAXCRYPTORS; idxalg++) {

		if (cp->ekp_len == -1) {
			/*
			 * Module not present - skip it
			 */
			alg_list->flag_alg[idxalg] = B_FALSE;
			cp++;
			continue;
		}
		alg_list->flag_alg[idxalg] = B_TRUE;
		cp++;
	}

	/*
	 * Scan the MAC modules array 
	 */
	for (idxalg = 0; idxalg < SKIP_MAX_MAC; idxalg++) {

		alg = skip_macalgs[idxalg];

		if (!alg) {
			/*
			 * MAC Module not present - skip it
			 */
			alg_list->flag_alg_mac[idxalg] = B_FALSE;
			continue;
		}
		alg_list->flag_alg_mac[idxalg] = B_TRUE;
	}
}

/* skip_get_kij_alg_list()
 *
 * List all supported kij algorithms
 *
 */
void
skip_get_kij_alg_list(ioctl_alg_list_t *alg_list)
{
	int		idx;

	/*
	 * Scan the array of supported Kij algorithms
	 */
	for (idx = 0; idx < SKIP_MAXCRYPTORS; idx++) {
		alg_list->flag_alg_v1[idx] = skip_kmgr_kij_alg_v1[idx];
		alg_list->flag_alg[idx]    = skip_kmgr_kij_alg[idx];
	}
}

/* skip_cryptor_stats()
 *
 * Get cryptor modules statistics
 *
 */
void
skip_cryptor_stats(ioctl_crypt_stat_t *p_stats)
{
	int			idxalg;
	skip_cryptor_t		*alg;
	crypt_mod_stat_t	*statp = &(p_stats->crypt_stats[0]);
	unsigned int		count = 0;

	if (p_stats->version == SKIP_V2) { 
		alg = &skip_cryptors[0];
	} else {
		alg = &skip_cryptors_v1[0];
	}
	/*
	 * Scan the cryptors array for installed modules
	 */
	for (idxalg = 0; idxalg < SKIP_MAXCRYPTORS; idxalg++) {

		if (alg->ekp_len == -1) {
			/*
			 * Module not present - skip it
			 */
			alg++;
			continue;
		}

		statp->module_id	= idxalg;
		statp->encrypts         = alg->encrypts;
		statp->encrypterrs      = alg->encrypterrs;
		statp->decrypts         = alg->decrypts;
		statp->decrypterrs      = alg->decrypterrs;

		statp++;
		alg++;
		count++;
	}

	p_stats->nb_algs = count; 

}

/* skip_mac_stats()
 *
 * Get MAC modules statistics
 *
 */
void
skip_mac_stats(ioctl_mac_stat_t *p_stats)
{
	int			idxalg;
	skip_mac_t		*alg;
	mac_mod_stat_t		*statp = &(p_stats->mac_stats[0]);
	unsigned int		count = 0;

	/*
	 * Scan the MAC modules array 
	 */
	for (idxalg = 0; idxalg < SKIP_MAX_MAC; idxalg++) {

		alg = skip_macalgs[idxalg];

		if (!alg) {
			/*
			 * MAC Module not present - skip it
			 */
			continue;
		}

		statp->module_id	= idxalg;
		statp->in_mac		= alg->in_mac;
		statp->in_mac_errs	= alg->in_mac_errs;
		statp->out_mac		= alg->out_mac;
		statp->out_mac_errs	= alg->out_mac_errs;

		statp++;
		count++;
	}

	p_stats->nb_algs = count; 

}

/* skip_find_var()
 *
 * Find a named variable index
 *
 */
static int
skip_find_var(ioctl_skip_sym_t *p_symb)
{

	int	idx;
	int	count = sizeof(skip_var) / sizeof(skip_sym_t);

	/*
	 * Scan the variable array
	 */
	for (idx = 0; idx < count; idx++) {

		if (!BCMP(skip_var[idx].p_name, 
			p_symb->var_name, p_symb->var_lg)) {
			/*
			 * Name found - return its index in array
			 */
			return(idx);
		}
	}

	/*
	 * Name not found - error
	 */
	return(-1);
}

/* skip_get_var()
 *
 * Get named variable value
 *
 */
int
skip_get_var(ioctl_skip_sym_t *p_symb)
{
	int	idx;

	/*
	 * Lookup on variable name
	 */
	idx = skip_find_var(p_symb);
	if (idx < 0) {
		return(EINVAL);
	}

	/*
	 * Get the new value
	 */
	if (skip_var[idx].v_fmt == SKIP_FMT_NET) {
		p_symb->var_value = ntohs(*(skip_var[idx].p_value));
	} else {
		p_symb->var_value = *(skip_var[idx].p_value);
	}

	return(0);
}

/* skip_set_var()
 *
 * Set named variable value
 *
 */
int
skip_set_var(ioctl_skip_sym_t *p_symb)
{
	int	idx;

	/*
	 * Lookup on variable name
	 */
	idx = skip_find_var(p_symb);
	if (idx < 0) {
		return(EINVAL);
	}

	/*
	 * Set the new value
	 */
	if (skip_var[idx].v_fmt == SKIP_FMT_NET) {
		*(skip_var[idx].p_value) = htons(p_symb->var_value);
	} else {
		*(skip_var[idx].p_value) = p_symb->var_value;
	}

	return(0);
}
