/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_os.h	1.1 96/03/11"

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * FreeBSD
 */
#ifndef KERNEL
#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <errno.h>
#include <fcntl.h>
#include <unistd.h>
#include <signal.h>
#include <memory.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <netdb.h>
#include <ctype.h>
#include <assert.h>
#include <dirent.h>
#endif

#include <sys/types.h>
#include <sys/errno.h>
#include <sys/time.h>
#include <sys/resource.h>
/*#include <sys/user.h>*/
#include <sys/malloc.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/syslog.h>
#include <sys/param.h>
#include <sys/uio.h>
#include <sys/file.h>
#include <sys/sockio.h>
#include <sys/wait.h>

#ifndef  __cplusplus
#include <machine/cpu.h>
#include <net/if.h>
#include <netinet/in_systm.h>
#endif
#include <netinet/in.h>
#ifndef __cplusplus
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <netinet/in_var.h>
#include <arpa/inet.h>
#endif

/* 
 * Basic required types and constants
 */
#ifndef boolean_t 
#define boolean_t       int
#endif
#ifndef B_TRUE
#define B_TRUE          1
#define B_FALSE         0
#endif

#ifdef KERNEL
#include <sys/systm.h>
#include <sys/mbuf.h>
#include <sys/syslog.h>
#include <sys/conf.h>
#include <sys/sysent.h>
#include <sys/exec.h>
#include <sys/lkm.h>
#include <sys/protosw.h>
#include <net/route.h>
#include <sys/kernel.h>
#include <sys/domain.h>
#include <net/netisr.h>
#include <sys/proc.h>
#include <sys/device.h>

#define	PANIC(s)		panic(s)

/*
 * 4.x memory management macros
 */
#define	SYSMEM_ALLOC(size)	malloc((u_long)size, M_PCB, M_NOWAIT) 
#define	SYSMEM_FREE(m, n)	free(m, M_PCB)
#define	BCOPY(s, d, n)		bcopy((caddr_t) s, (caddr_t) d, n)
#define	BZERO(s, n)		bzero((caddr_t) s, n)
#define	BCMP(s, d, n)		bcmp((caddr_t) s, (caddr_t) d, n)
#define	STATIC			static


#define ALIGNED(x)		(((unsigned int)(x)&(skip_alignment - 1)) == 0)

/*
 * 4.x lock management macros
 */
#define	MUTEX_T			int
#define	MUTEX_INIT(m, n)
#define	MUTEX_DESTROY(m)
#define	MUTEX_ENTER(m)		(*m) = splnet()
#define	MUTEX_EXIT(m)		splx(*m)

/*
 * 4.x buffer management macros
 */
#define	SKIP_BUF_T		struct mbuf
#define	BUFSTART(m)		mtod(m, unsigned char *)
#define	BUFEND(m)		(mtod(m, unsigned char *) + m->m_len)
#define	BUFLEN(m)		(m->m_len)
#define	BUFGROW(m, n)		(m->m_len += n)
#define	BUFFREE(m)		if (m) m_freem(m)
#define BUFADJUST(m, l)		{ m->m_len += l; m->m_off -=l; }

/*
 * Notifier interface
 */
#define	SKIP_NOTIFYQ_T		int
#define	SKIP_SET_NOTIFIER(n, q)	(n = q)

/*
 * 4.x logging defines
 */
#define skip_log(s)		log(LOG_KERN, s)
#define skip_log1(s, t)		log(LOG_KERN, s, t)
#define skip_log2(s, t, q)	log(LOG_KERN, s, t, q)

/*
 * 4.x debugging defines
 */
#define	SKIP_DEBUG(s)		if (skip_key_debug) printf(s)
#define	SKIP_DEBUG1(s, t)	if (skip_key_debug) printf(s, t)
#define	SKIP_DEBUG2(s, t, q)	if (skip_key_debug) printf(s, t, q)

/*
 * 4.x timing defines
 */
#define SKIP_ES_CURRENTTIME	(time.tv_sec)
#define SKIP_ES_DELTATIME(then)	(SKIP_ES_CURRENTTIME - then)

/*
 * IP packet macros
 */
#define IPHLEN(ip)		(ip->ip_hl <<2)
#define IP_SRC(ip)		(ip->ip_src)
#define IP_DST(ip)		(ip->ip_dst)
#define IP_PROTO(ip)		(ip->ip_p)

/* 
 * Retrieve IP protocol and "skip" IP header 
 */

#define SKIP_GET_PROTO(params, in, len) \
{ \
	struct ip  *ip = mtod(in, struct ip *); \
	params->payload_type = IP_PROTO(ip); \
	len = IPHLEN(ip); \
}

/*
 * ANSI prototypes for system routines
 */
extern int			splimp();
extern int			splnet();
extern void			splx(int);
extern void			m_freem(struct mbuf *);
extern void			panic(const char *, ...);
extern int			tsleep(void *, int, char *, int);
extern void			wakeup(void *);
extern int			uiomove(caddr_t, int, struct uio *);
extern int     			copyin(void *, void *, u_int );
extern int			copyout(void *, void *, u_int);
extern int			mclget(struct mbuf *);
extern int			m_cpytoc(struct mbuf *, int, int, caddr_t);

extern void 			log(int, const char *, ...);

extern char			*strncpy(char *, const char *, size_t);

extern void			printf(const char *, ...);
#else /* KERNEL */

/*
 * User space buffer management macros
 */
#define	SKIP_BUF_T		void

/*
 * User space memory management macros
 */
#define	SYSMEM_ALLOC(m)		calloc(1, m)
#define	SYSMEM_FREE(m, n)	free(m)
#define	BCOPY(s, d, n)		memcpy(d, s, n)
#define	BZERO(s, n)      	memset(s, 0, n)
#define	BCMP(s, d, n)      	memcmp(s, d, n)

#define LOCKFILE(fd)		flock(fd, LOCK_EX)
#define UNLOCKFILE(fd)		flock(fd, LOCK_UN)
/*
 * undefine <sys/debug.h> macros
 */
#ifdef STATIC
#undef STATIC
#endif
#define	STATIC

/*
 * ANSI prototypes for C library routines and syscalls
 */
extern int			gethostname(char *, int);
extern int			fprintf(FILE *, const char *, ...);
extern int			fflush(FILE *);
extern int			fgetc(FILE *);
extern int			fseek(FILE *, long, int);
extern size_t			fread(void *, size_t, size_t, FILE *);
extern int			fclose(FILE *);
extern int			socket(int, int, int);
extern int			ioctl(int, int, ...);
extern int			pclose(FILE *);
/*extern int			getrlimit(int, struct rlimit *); */
extern void			perror(const char *);
extern time_t			time(time_t *);
extern int			getopt(int, char * const *, const char *);
extern int			sscanf(const char *, const char *, ...);

#endif /* KERNEL */

/* XXX Bad IPPROTO_ENCAP define  ? */
#ifdef IPPROTO_ENCAP
#undef IPPROTO_ENCAP
#endif
#define IPPROTO_ENCAP		4

/* SKIP specific */

#define SKIP_DIR		"/etc/skip/"
#define SKIP_BIN		"/usr/skip/bin"
#define KEYMGR			"/dev/skip_key"

/*
 * SKIP access control ioctls
 */
#define	SKIPDEV		"/dev/skip"
typedef struct {
        int             ic_cmd;
        int             ic_timout;
        int             ic_len;
        char            *ic_dp;
} skip_io_t;

#define SKIPIOACL       _IOWR('S', 1, skip_io_t)

/*
 * File type..
 */
typedef int		skip_fd_t;
#define SKIPFD_ERR	(-1)

/* General purpose */

typedef unsigned char byte;

#if 0
extern void			bcopy(void *, void *, int);
extern void			bzero(void *, int);
extern int			bcmp(void *, void *, int);
#endif

#define	SKIP_IFCMP(if1, if2)    strcmp(if1, if2)

#define SKIP_OSNAME   "FreeBSD"

#define EPROTO EPROTONOSUPPORT

#ifdef  __cplusplus
}
#endif
