/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_acl.h	1.4 96/07/08 Sun Microsystems"

#ifndef SKIP_ACL_H
#define SKIP_ACL_H

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * SKIP end system specific ioctls
 */
enum {	SKIP_ES_ADD_IF = (SKIP_KEY_LIST + 1),
				/* create new interface 		*/
	SKIP_ES_DEL_IF,		/* delete an interface 			*/
	SKIP_ES_ACL_ADD,	/* add an entry to the ACL 		*/
	SKIP_ES_ACL_DEL,	/* remove an entry from the ACL 	*/
	SKIP_ES_ACL_GET,	/* get an acl entry from the list 	*/
	SKIP_ES_ACL_LIST,	/* return list of current acl entries 	*/
	SKIP_ES_SET_MODE,	/* turn access control on/off 		*/
	SKIP_ES_GET_MODE,	/* test if access control on/off 	*/
	SKIP_ES_GET_IF_STATS	/* get skip interface statistics 	*/
};		

/*
 * for params->flags
 */
#define	SKIP_EXCL		0x01		/* host/net is excluded */
#define	SKIP_DONTLOG		0x02		/* don't log events */
#define	SKIP_NOMADIC		0x04		/* match by key id */

/*
 * macros for identifying different ACL types
 */
#define	SKIP_HOSTMASK		(0xffffffff)
#define	SKIP_IS_HOSTACL(p)	(p->mask.s_addr == SKIP_HOSTMASK)
#define	SKIP_IS_NETACL(p)	(p->mask.s_addr != SKIP_HOSTMASK)

/*
 * unknown IP address in ACL - all ones
 */
#define	SKIP_UNKNOWNIP		(0xffffffff)
#define	SKIP_IS_UNKNOWNIP(a)	((a).s_addr == SKIP_UNKNOWNIP)

#define	SKIPSZ		(16)

/*
 * SKIP notification - message sent to user space in interactive mode
 */
enum { SkipUnknownSrc, SkipUnknownDst, SkipAuthFailed, SkipBadParams,
	SkipExcludedSrc, SkipExcludedDst };

typedef struct {
	char		if_name[SKIPSZ];	/* e.g. "le0" */
	int		what;
	struct ip	iphdr;
	skip_param_t	params;
} skip_es_notification_t;

/*
 * SKIP_ES_ACL_ADD SKIP_ES_ACL_DEL SKIP_ES_ACL_GET SKIP_ES_ACL_LIST ioctls
 */
typedef struct {
	char		if_name[SKIPSZ];	/* e.g. "le0" */

	/* followed by array of skip_param_t[] */
	void		*params;

} skip_es_req_t;
	
/*
 * maximum hosts in an ACL... XXX
 */
#define	SKIP_MAX_HOSTS	700
#define	SKIP_MAX_IOSZ	(SKIPSZ + SKIP_MAX_HOSTS * sizeof(skip_param_t))

/*
 * SKIP_ES_GET_MODE and SKIP_ES_SET_MODE ioctls
 */
enum { SkipAccessControlOn, SkipAccessControlOff, SkipInteractive };

typedef struct {
	char		if_name[SKIPSZ];	/* e.g. "le0" */
	int		if_mode;
} skip_es_mode_t;

/*
 * Per SKIP interface statistics
 */
typedef struct {
	unsigned long	skip_if_ipkts;
	unsigned long	skip_if_opkts;
	unsigned long	skip_if_encrypts;
	unsigned long	skip_if_decrypts;
	unsigned long	skip_if_bypasses;
	unsigned long	skip_if_drops;
	unsigned long	skip_if_notv4;
	unsigned long	skip_if_nocanput;
	unsigned long	skip_if_raw_in;
	unsigned long	skip_if_raw_out;
#ifdef SYSV
	unsigned long	skip_if_allocbfail;
#endif
} ioctl_if_stat_t;

typedef struct {
	char		if_name[SKIPSZ];	/* e.g. "le0" */
	ioctl_if_stat_t	if_stats;
} skip_ctrl_stats_t;

extern int	skip_get_stats_if(char *, ioctl_if_stat_t *);

#ifdef  __cplusplus
}
#endif

#endif /* SKIP_ACL_H */
