/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/

#pragma ident "@(#)skip_proto.h	1.27 96/07/08 Sun Microsystems"

#ifndef SKIP_PROTO_H
#define SKIP_PROTO_H

#ifdef  __cplusplus
extern "C" {
#endif

/*
 * SKIP IP protocol identifier (SunScreen mode)
 */
#define SKIP_PROTO_V1		(79)

/*
 * IP Security Protocol identifiers (IP SP mode)
 */
#define SKIP_IPSP		(57)	/* SKIP Protocol Number		*/
#define SKIP_ICMP		(39)	/* SKIP ICMP message		*/

#if defined(sparc) || defined (__sparc__)	/* SPARC */
#define	SKIP_SPI		(1L)	/* Security Association ID	*/
#else		/* x86 */
#define	SKIP_SPI		(0x01000000)
#endif


#define	SKIP_NEXT_ESP		50	/* XXX SKIP Next Header is ESP	*/
#define	SKIP_NEXT_AH		51	/* XXX SKIP Next Header is AH	*/

/*
 * SKIP Certificate Discovery Protocol
 */
#define	SKIP_CLIENT_PORT	(1639)
#define	SKIP_SERVER_PORT	(1640)


#define	SKIP_VERSION		(1)	/* SKIP Version			*/

#define	SKIP_MIN_HDR_LG		(12)	/* SKIP header min length	*/

/*
 * Name space identifiers (NSID)
 */
#define SKIP_NSID_NONE		(0)	/* Use Packet Address 		*/
#define SKIP_NSID_IPV4		(1)	/* IPv4 Address Space 		*/
#define SKIP_NSID_XOPEN_UD	(2)	/* POSIX/XOPEN User Ids		*/
#define SKIP_NSID_IPV6		(3)	/* IPv6 Address Space		*/
#define SKIP_NSID_MD5_DNS	(4)	/* MD5 of DNS Names		*/
#define SKIP_NSID_MD5_ISO_DN	(5)	/* MD5 of ISO DN ASN.1 encoding	*/
#define SKIP_NSID_MD5_US_SS	(6)	/* MD5 of US Social Security #	*/
#define SKIP_NSID_MD5_802_MAC	(7)	/* 802.x MAC Address		*/
#define SKIP_NSID_MD5_DH_PUB	(8)	/* MD5 of Principal's DH Pub Val*/
#define SKIP_NSID_MD5_RFC822	(9)	/* MD5 of RFC-822 Mailbox Add.	*/
#define SKIP_NSID_MD5_BA	(10)	/* MD5 of Bank Account	 	*/
#define SKIP_NSID_MD5_NIS	(11)	/* MD5 of NIS Names 		*/

/* 
 * Key/Traffic encryption algorithm identifiers (SunScreen mode)
 */ 
#define SKIP_DES_CBC		(1) 
#define SKIP_RC2_CBC		(2)
#define SKIP_RC4_40_V1		(3) 
#define SKIP_RC4_128            (4) 
#define SKIP_DES_EDE_K2         (5) 
#define SKIP_DES_EDE_K3         (6)
#define SKIP_SIMPLECRYPT        (10)

/* 
 * Key encryption algorithm identifiers 
 */ 
#define	SKIP_KIJ_NONE			(0) 
#define	SKIP_KIJ_DES_CBC		(1) 
#define	SKIP_KIJ_DES_EDE_K3		(2)
#define SKIP_KIJ_IDEA_CBC		(3)
#define SKIP_KIJ_SAFER_128SK_CBC	(241)
#define	SKIP_KIJ_RC2_40			(242)
#define	SKIP_KIJ_SIMPLECRYPT		(252)

/* 
 * Traffic encryption algorithm identifiers 
 */ 
#define	SKIP_CRYPT_DES_CBC		(1)  /* XXX - RFC 1829 ? */
#define	SKIP_CRYPT_DES_EDE_K3		(2)
#define SKIP_CRYPT_IDEA_CBC		(3)
#define	SKIP_CRYPT_RC4_40		(240)
#define SKIP_CRYPT_SAFER_128SK_CBC	(241)
#define	SKIP_CRYPT_RC2_40		(242)
#define	SKIP_CRYPT_SIMPLECRYPT		(252)
 
/*
 * Traffic authentication algorithm (MAC) identifiers
 */
#define SKIP_MAC_MD5		(1)
#define SKIP_MAC_DES_CBC	(2)

/*
 * Compression algorithm identifiers
 */
#define	SKIP_COMP_VJ		(1)	/* XXX	*/

/*
 * AH Header size: Next Header(1) + Lengh(1) + Reserved(2) + SPI(4)
 */
#define	SKIP_AH_HDR_SZ		(8)

/*
 * ESP Header size: SPI(4) + Max Padding (?) + Pad Length(1) + Payload Type(1)
 * XXX This size doesn't include the IV and Payload length
 */
#define SKIP_ESP_HDR_SZ		(12)

/*
 * SKIP header fix part size 
 */
#define SKIP_IPSP_HDR_FIXSZ	(12)

/*
 *  Maximum size of pad required for block algorithms (from ESP)
 */
#define	SKIP_MAX_PAD		(10)

/*
 * max number of crypto/MAC systems supported (== sizeof unsigned char)
 */
#define SKIP_MAXCRYPTORS        256
#define SKIP_MAX_MAC		256	

/*
 * Max number of NSID supported
 */
#define	SKIP_MAX_NSID		SKIP_NSID_MD5_NIS + 1

/*
 * Max number of local master keys supported for the same NSID
 */
#define	SKIP_MAX_LOCAL_KEYIDS	100

#ifdef  __cplusplus
}
#endif

#endif /* SKIP_PROTO_H */
