/*
SKIP Source Code License Statement:
------------------------------------------------------------------
  Copyright
  Sun Microsystems, Inc.


  Copyright (C) 1994, 1995, 1996 Sun Microsystems, Inc.  All Rights
  Reserved.

  Permission is hereby granted, free of charge, to any person
  obtaining a copy of this software and associated documentation
  files (the "Software"), to deal in the Software without
  restriction, including without limitation the rights to use,
  copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software or derivatives of the Software, and to 
  permit persons to whom the Software or its derivatives is furnished 
  to do so, subject to the following conditions:

  The above copyright notice and this permission notice shall be
  included in all copies or substantial portions of the Software.

  The Software must not be transferred to persons who are not US
  citizens or permanent residents of the US or exported outside
  the US (except Canada) in any form (including by electronic
  transmission) without prior written approval from the US
  Government. Non-compliance with these restrictions constitutes
  a violation of the U.S. Export Control Laws.

  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
  OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
  NONINFRINGEMENT.  IN NO EVENT SHALL SUN MICROSYSTEMS, INC., BE LIABLE
  FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
  OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
  CONNECTION WITH THE SOFTWARE OR DERIVATES OF THIS SOFTWARE OR 
  THE USE OR OTHER DEALINGS IN THE SOFTWARE.

  Except as contained in this notice, the name of Sun Microsystems, Inc.
  shall not be used in advertising or otherwise to promote
  the sale, use or other dealings in this Software or its derivatives 
  without prior written authorization from Sun Microsystems, Inc.
*/
 
#pragma ident "@(#)skip_keymgrsubr.C	1.52 96/05/03"

#include "Bigint.h"
#include "Bstream.h"

/*
 * System includes
 */
#include <skip_os.h>

#include "Time.h"
#include "ObjId.h"
#include "Name.h"
#include "X509Cert.h"
#include "SkipCert.h"
#include "X509skip.h"
#include "HashCert.h"
#include "malloc.h"
#include "utils.h"
#include "Sig.h"
#include "skip_log.h"
#include <skip_crypt.h>

#include "my_types.h"
#include "skip_conf.h"
#include "skip_keymgr.h"
#include "skip_cache.h"
//#include "skip_enc_alg.h"
#include "skip_certbase.h"
#include "skip_localid.h"
#include "skip_localidlist.h"
#include "SlotParse.h"

Bstream skip_kp_to_Akp(Bstream, u_char, int);
Bstream skip_kp_to_Ekp(Bstream, u_char, int);
Bstream kijtokijn(Bstream, u_long);

extern void *dh_params;
extern Bstream dhparams;
extern Bstream CA_X509_Cert;
extern int verbose;

secret_cache kij_cache;
LocalId_list LocalList;


int skip_raw_ah_esp(int encrypt, SkipParams *p)
{
	raw_key *m;

	m = find_raw_key(p->l_nsid, p->l_mkeyid, p->r_nsid, p->r_mkeyid);

	if (m == NULL)
		return KEYMGR_NO_MANUAL_KEY;

	p->e_kp = m->e_kp;
	p->a_kp = m->a_kp;

	// Create the IV for the traffic key algorithm

	if (cryptor_get_flags(p->ver, KPALG, p->kp_alg) & SKIP_STREAM_CIPHER) {
		unsigned char zero[8];
		bzero(zero, sizeof(zero));
		p->iv = Bstream(8, zero);
	} else {
		p->iv =
		  get_random_bytes(cryptor_get_ivlen(p->ver, KPALG, p->kp_alg));
	}

	return KEYMGR_OK;
}

int
build_cache_entry(SkipParams *p, secret_cache_elem *elem)
{
	String temp;
	u_long exp;
	LocalId *local;
	Bigint other_public_value;

	Bigint Mod, Base;
	int status = skip_get_dh_public_value(	 other_public_value,
						 Base, Mod, 
						 p->r_mkeyid, 
						 p->r_nsid, 
						 exp);
	if (status != KEYMGR_OK)
		return status;

	local = LocalList.find_valid(p->l_nsid, p->l_mkeyid, NTPNOW);

	if (local == NULL) {
		temp = p->l_mkeyid.gethexstr();
		skip_log(SKIP_ERROR, "No localid nsid=%d keyid=%s",
				p->l_nsid, (const char *)temp);
		return KEYMGR_NO_LOCALID;
	}

	if ( Mod != local->p || Base != local->g ){
		skip_log(SKIP_ERROR,"Certificate g+p do not match dh_params");
		temp = Mod.getnumstr();
		
		printf("Mod: %s != ",(const char *)temp);
		temp = local->p.getnumstr();
		printf("%s\n",(const char *)temp);

		temp=Base.getnumstr();
		printf("Base: %s != ",(const char *)temp);
		temp=local->g.getnumstr();
		printf("%s\n",(const char *)temp);
		return KEYMGR_BADCERT;
	}

	temp = p->r_mkeyid.gethexstr();
	skip_log(SKIP_NOTICE,"Calculating Shared secret for %s",
				(const char *)temp);
	elem->secret = local->generate_SkipSecret(other_public_value);
	skip_log(SKIP_NOTICE,"Done");
	elem->r_keyid = p->r_mkeyid;
	elem->r_nsid  = p->r_nsid;
	elem->l_keyid = p->l_mkeyid;
	elem->l_nsid  = p->l_nsid;
	return KEYMGR_OK;
}

int skip_dispatch(int encrypt, SkipParams *p)
{
	secret_cache_elem *elem;
	secret_cache_elem newelem;
	int status;

	if (p->ver == SKIP_RAW)
		return skip_raw_ah_esp(encrypt, p);

	if (p->ver != SKIP_V1  && p->ver != SKIP_V2)
		return KEYMGR_BAD_VER;

	if (p->ver == SKIP_V2 && !encrypt) {
		if (abs(p->counter_n - CURRENT_NCOUNTER)>1)
			return KEYMGR_BAD_N_OFFSET;
	}

	elem = kij_cache.get_entry(p->l_nsid, p->l_mkeyid, 
				   p->r_nsid, p->r_mkeyid);

	if (elem == NULL) {
		status = build_cache_entry(p, &newelem);
		if (status)
			return status;
		else 
			elem = &newelem;
	}

	kij_cache.insert(elem);  // Update the cache entry

	if (encrypt) 
		return elem->secret->generate_kp_iv(p);
	else
		return elem->secret->decrypt_kp(p);
}

int 
skip_get_dh_public_value(Bigint &pub, Bigint &g, Bigint &p, 
			 const Bstream &keyid, u_char nsid, u_long &expires)
{
	CertInfo ci;
	SkipCert *dh_cert;	// just a handle into ci.cert

	if (db_get_certinfo(nsid, keyid, ci))
		return KEYMGR_NOCERT;

	dh_cert = ci.cert;

	if (dh_cert == NULL)
		return KEYMGR_BADCERT;

	char *reason;
	if (reason = ci.check_valid(auth))
	{
   		skip_log(SKIP_ERROR,
			"Invalid certificate for nsid=%d mkid=%s, reason=%s",
				nsid,
				keyid.get_info_str(),
				reason);

		return KEYMGR_BADCERT;
	}

	if (dh_cert->skip_params(g, p)) {
		skip_log(SKIP_ERROR,"Certificate g+p do not decode");
		return KEYMGR_BADCERT;
	}

	expires = dh_cert->skip_notvalidafter();
	pub = dh_cert->skip_pubkey();
 
	return KEYMGR_OK;
}

Bstream kijtokijn(Bstream kij, u_long ncounter)
{
	Bigint ncount=ncounter;
	Bstream result;
	u_long ncountnet;
	char zero, one;
	ncountnet=htonl(ncounter);
	zero=0, one=1;
	result = MD5(kij+ Bstream(4,(u_char *)&ncountnet)+
			  Bstream(1,(u_char *)&one))+
	         MD5(kij+ Bstream(4,(u_char *)&ncountnet) +
			  Bstream(1,(u_char *)&zero));
	return result;
}


Bstream
skip_kp_to_Ekp(Bstream kp, u_char crypt_alg, int size)
{
	unsigned char c;
	Bstream result;
	c = 2;
	result = MD5(kp+Bstream(1,&crypt_alg)+Bstream(1,&c));
	c = 0;
	result += MD5(kp+Bstream(1,&crypt_alg)+Bstream(1,&c));
	if (size > result.getlength()) {
		skip_log(SKIP_NOTICE,
			"generate_E_kp warning: Size desired < Size present");
	}
	result.consume(result.getlength()-size);
	return result;
}

	
Bstream
skip_kp_to_Akp(Bstream kp, u_char mac_alg, int size) 
{
	unsigned char  c;
	Bstream result;

	c=3;
	result = MD5(kp+Bstream(1, &mac_alg)+Bstream(1,&c));
	c=1;
	result += MD5(kp+Bstream(1, &mac_alg)+Bstream(1,&c));
	if (result.getlength() < size) {
		skip_log(SKIP_NOTICE,
			  "generate_A_kp warning: Size desired < Size present");
	}
	result.consume(result.getlength()-size);
	return result;
}

