COMMENT |
============================================================================
  
  RIPEMD.ASM v2.2.0, RIPE-MD Message Digest Transform (20 January 1995)
  (C) Copyright 1994-1995 Robert Rothenburg Walking-Owl
  
    History: 1.0    Original release (14 Nov 94)
             2.0    ASM code rewritten (Jan 95).
             2.2.0  ASM code written to use MDContext record, for
                    "compatability" with C implementations.

  The author can be contacted via e-mail at <rrothenb@ic.sunysb.edu>
  or surface mail at P.O.Box 1327, Stony Brook, NY, 11790 USA.
  
== License and (Non)Warranty Information ===================================

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or 
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
============================================================================
| Note: source has been assembled successfully with TASM 3.2

; - RIPEMD Assembly Options (Conditional Defines): -------------------------

__CONTEXT           EQU       1     ; Use MDContext structure

; Miscellaneous optimizations:

__LOCALVARS         EQU         1   ; Locals in STACK (otherwise in CODE)
__NOPROCS           EQU         1   ; Use macros not procs for F-I funcs.
__FASTERMETHOD      EQU         1   ; Optimized calculations for F and G (*)
__COPYINIT          EQU         1   ; 
__FASTCALLS         EQU         1   ;

; __FASTERMETHOD is based on recommendations in NIST SHA specification

; - RIPEMD Unconditional Defines: ------------------------------------------

__NOSTOR            EQU         1   ; Copy A,B,C,D regs. as block (faster?)
__MISCOPT           EQU         1   ; Misc. optimization for H and I func

A         EQU       <DWORD PTR es: [di]>    ; chaining variables
B         EQU       <DWORD PTR es: [di+4]>  ;
C         EQU       <DWORD PTR es: [di+8]>  ;
D         EQU       <DWORD PTR es: [di+12]> ;

X         EQU       <DWORD PTR ds: [si]>    ;

        IFDEF   __CONTEXT
ctxlobits EQU       <DWORD PTR es: [di][16]> ; low  no. bits count
ctxhibits EQU       <DWORD PTR es: [di][20]> ; high  "   "     "
ctxinput  EQU       <DWORD PTR es: [di][24]> ; context input buffer
ctxlofin  EQU       <DWORD PTR es: [di][80]> ; 
ctxhifin  EQU       <DWORD PTR es: [di][84]>

; MDContext structure is as follows:
;
;   unsigned long buf[4]                ; 16 bytes, current hash value
;   unsigned long bits[2]               ; current count of bits
;   unsigned char in[64]                ; current buffer
;
; (See note in MD5.ASM about optimizations.)

        ENDIF

; - Miscellaneous macros: --------------------------------------------------

STOR      MACRO     dest, src
           mov      eax,  src
          IFDEF     __LOCALVARS
            mov     dest, eax
          ELSE        
            mov     cs: dest, eax
          ENDIF       
         ENDM        

      IFDEF     __CONTEXT
MCPY     MACRO
           LOCAL        @0
           cld
           shr          cx,     1
           jnc          @0
           movsb
 @0:       rep          movsw
         ENDM

MSET     MACRO             
           LOCAL        @0
           xor          ax,     ax
           shr          cx,     1
           jnc          @0
           stosb
 @0:       rep          stosw
         ENDM
      
XFORM    MACRO         
           pusha
           push        es
           add         di,     24
           push        di
           push        es
           push        dx
          IFDEF      __FASTCALLS  
           push        cs
           mov         ax, OFFSET RIPEMDTransform
           call        ax
          ELSE
           call        cs: RIPEMDTransform
          ENDIF
           popa
         ENDM
      ENDIF

                    DOSSEG
                    .MODEL      LARGE
                    .386

                    .CODE


; - Auxiliary function F(x,y,z)=xy v not(x)z -------------------------------

; if __FASTERMETHOD is defined, F(x,y,z)=z xor (x)(y xor z)

; result = eax, x = ebx, y = ecx, z = edx

                    IFDEF          __NOPROCS
F                     MACRO     
                    ELSE        
F                     PROC      NEAR
                    ENDIF       
                    IFDEF          __FASTERMETHOD
                      mov         eax,      ecx
                      xor         eax,      edx
                      and         eax,      ebx
                      xor         eax,      edx
                    ELSE        
                      mov         eax,      ebx
                      and         eax,      ecx
                      not         ebx
                      and         ebx,      edx
                      or          eax,      ebx
                    ENDIF       
                    IFDEF          __NOPROCS
                      ENDM        
                    ELSE        
                      ret         
F                     ENDP      
                    ENDIF       

; -------------------------------------------------------------------------
; FF(a,b,c,d,X[k],s,t) denotes a = ((a + F(b,c,d) + X[k]) <<< s)
; -------------------------------------------------------------------------

FF                    MACRO     a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                    IFDEF         __NOPROCS
                      F           
                    ELSE        
                      call        F
                    ENDIF       
                      add       eax,      a
                      add       eax,      X
                      rol       eax,      s
                      mov       a,        eax
                    ENDM        

; -------------------------------------------------------------------------
; FFF(a,b,c,d,X[k],s,t) denotes a = ((a + F(b,c,d) + X[k] + t) <<< s)
; -------------------------------------------------------------------------

FFF                   MACRO     a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF       __NOPROCS
                        F
                      ELSE        
                        call        F
                      ENDIF       
                      add         eax,      a
                      add         eax,      X
                      add         eax,      50a28be6h
                      rol         eax,      s
                      mov         a,        eax
                    ENDM

; - Auxiliary function G(x,y,z)=xy v xz v yz -------------------------------

; if __FASTERMETHOD is defined, G(x,y,z)=xy v z(x v y)

                    IFDEF          __NOPROCS
G                     MACRO     
                    ELSE        
G                     PROC      NEAR
                    ENDIF
                    IFDEF       __FASTERMETHOD
                      mov         eax,      ebx
                      or          eax,      ecx
                      and         eax,      edx
                      and         ebx,      ecx
                      or          eax,      ebx
                    ELSE        
                      mov         eax,      ebx
                      and         eax,      ecx
                      and         ebx,      edx
                      and         ecx,      edx
                      or          eax,      ebx
                      or          eax,      ecx
                    ENDIF
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
G                     ENDP      
                    ENDIF       
; --------------------------------------------------------------------------
; GG(a,b,c,d,X[k],s,t) denotes a = ((a + G(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

GG                  MACRO       a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF       __NOPROCS
                        G
                      ELSE        
                        call        G
                      ENDIF       
                      add         eax,      a
                      add         eax,      X
                      add         eax,      5a827999h  ; t
                      rol         eax,      s
                      mov         a,        eax
                    ENDM        

; --------------------------------------------------------------------------
; GGG(a,b,c,d,X[k],s,t) denotes a = ((a + G(b,c,d) + X[k]) <<< s)
; --------------------------------------------------------------------------

GGG                   MACRO      a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF       __NOPROCS
                        G
                      ELSE        
                        call        G
                      ENDIF       
                      add         eax,      a
                      add         eax,      X
                      rol         eax,      s
                      mov         a,        eax
                    ENDM        

; - Auxiliary function H(x,y,z)=x xor y xor z ------------------------------
                    
                    IFDEF          __NOPROCS
H                      MACRO     
                    ELSE        
H                      PROC      NEAR
                    ENDIF       
                    mov         eax,        ebx
                    xor         eax,        ecx
                    xor         eax,        edx
                    IFDEF          __NOPROCS
                    ENDM        
                    ELSE        
                      ret         
H                      ENDP      
                    ENDIF       

; --------------------------------------------------------------------------
; HH(a,b,c,d,X[k],s,t) denotes a = ((a + H(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

HH                    MACRO     a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF          __NOPROCS
                        H            
                      ELSE        
                        call        H 
                      ENDIF       
                      add       eax,      a
                      add       eax,      X
                      add       eax,      6ed9eba1h ; t
                      rol       eax,      s
                      mov       a,        eax
                    ENDM        
; --------------------------------------------------------------------------
; HHH(a,b,c,d,X[k],s,t) denotes a = ((a + H(b,c,d) + X[k] + t) <<< s)
; --------------------------------------------------------------------------

HHH                   MACRO     a, b, c, d, X, s
                      mov         ebx,      b
                      mov         ecx,      c
                      mov         edx,      d
                      IFDEF       __NOPROCS
                        H
                      ELSE        
                        call        H
                      ENDIF       
                      add         eax,      a
                      add         eax,      X
                      add         eax,      5c4dd124h
                      rol         eax,      s
                      mov         a,        eax
                    ENDM        


; - Temporary Registers: ---------------------------------------------------
                    
                    IFNDEF          __LOCALVARS
AA                    LABEL     DWORD
                      DD          (?)
BB                    LABEL     DWORD
                      DD          (?)
CC                    LABEL     DWORD
                      DD          (?)
DD0                   LABEL     DWORD
                      DD          (?)
AAA0                  LABEL   DWORD
                      DD          (?)
BBB                   LABEL   DWORD
                      DD          (?)
CCC                   LABEL   DWORD
                      DD          (?)
DDD                   LABEL   DWORD
                      DD          (?)
                    ENDIF       

; - Initializate Digest: ---------------------------------------------------
                 IFNDEF __TRANSFORMONLY
; if __TRANSFORMONLY defined, no RIPEMDInit routine will assembled.
                    PUBLIC      PASCAL RIPEMDInit
RIPEMDInit             PROC        PASCAL FAR digest: DWORD
                    IFDEF     __COPYINIT
                      push      ds
                      mov       ax,       cs
                      mov       ds,       ax
                      mov       si,       OFFSET initial_values
                    ENDIF       
                    les         di,       digest
                    IFNDEF    __COPYINIT
                      mov       A,      67452301h
                      mov       B,     0EFCDAB89h
                      mov       C,      98BADCFEh
                      mov       D,      10325476h
                     IFDEF    __CONTEXT 
                      mov     ctxlobits, 0
                      mov     ctxhibits, 0  
                     ENDIF
                    ELSE 
                     IFDEF    __CONTEXT 
                      mov       cx,     6
                     ELSE
                      mov       cx,     4
                     ENDIF
                      cld         
                      rep         movsd
                      pop         ds
                    ENDIF       
                    ret        
                    
                    IFDEF       __COPYINIT or __CONTEXT
initial_values      LABEL     DWORD
  DD                  67452301h
  DD                 0EFCDAB89h
  DD                  98BADCFEh
  DD                  10325476h
IFDEF __CONTEXT
  DD  2 DUP (?)         
ENDIF
                    ENDIF
RIPEMDInit             ENDP

; - Update Context Buffer: -------------------------------------------------

                  IFDEF __CONTEXT  
                    PUBLIC      PASCAL RIPEMDUpdate
RIPEMDUpdate        PROC        PASCAL FAR ctx: DWORD, buff: DWORD, len: WORD
                    push        ds
                    lds         si,     buff
                    les         di,     ctx
 @0:                cmp         len,    0
                    jz          SHORT   @3
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     3Fh
                    mov         cx,     40h
                    sub         cx,     ax
                    cmp         cx,     len
                    jna         SHORT @1
                    mov         cx,    len
 @1:                sub         len,   cx
                    mov         bx,    ax
                    mov         ax,    cx
                    and         eax,   0FFFFh
                    shl         eax,    3
                    add         ctxlobits, eax
                    adc         ctxhibits, 0  
                    mov         dx,     di
                    add         di,     24
                    add         di,     bx
                    add         bx,     cx
                    MCPY
                    mov         di,     dx
                    cmp         bx,     40h
                    jnz         SHORT @2
                    XFORM
 @2:                jmp         SHORT @0
 @3:                   
                    pop          ds
                    ret
RIPEMDUpdate        ENDP

; - Wrap-up Context Buffer: ------------------------------------------------

                    PUBLIC      PASCAL RIPEMDFinal
RIPEMDFinal         PROC        PASCAL FAR digest: DWORD, ctx: DWORD
                    push        ds
                    les         di,     ctx
                    mov         eax,    ctxlobits
                    shr         eax,    3
                    and         ax,     3Fh
                    mov         bx,     ax
                    mov         dx,     di
                    add         di,     24
                    add         di,     bx
                    mov         al,     80h
                    cld
                    stosb
                    inc         bx
                    mov         cx,     40h
                    sub         cx,     bx
                    cmp         bx,     38h
                    jb          SHORT @4
                    MSET
                    mov         di,     dx
                    XFORM
                    add         di,     24
                    mov         cx,     38h             
 @4:                MSET
                    mov         di,     dx
                    STOR        ctxlofin, ctxlobits
                    STOR        ctxhifin, ctxhibits
                    XFORM
                    mov         si,     di
                    mov         ax,     es
                    mov         ds,     ax
                    les         di,     digest
                    mov         cx,     16
                    MCPY
                    mov         es,     ax        ; wipe buffer in case
                    mov         di,     dx        ; there is anything
                    mov         cx,     (16+8+64) ; sensitive
                    MSET
                    pop         ds
                    ret
RIPEMDFinal         ENDP
                  ENDIF
                 ENDIF

; - RIPE-MD Transformation: -------------------------------------------------

                    PUBLIC      PASCAL RIPEMDTransform
RIPEMDTransform     PROC        PASCAL FAR hashdata: DWORD,digest: DWORD
                  IFDEF          __LOCALVARS
                    LOCAL        AA: DWORD, BB: DWORD, CC: DWORD, DD0: DWORD, AAA0: DWORD, BBB: DWORD, CCC: DWORD, DDD: DWORD
; Note: if the locals are not on the same line, then TASM cannot be trusted
;       to put them in any consistent order, and __NOSTOR could not be used.
                  ENDIF       
                    push        ds
                    IFDEF          __NOSTOR
                      lds         si,       digest
                      IFDEF          __LOCALVARS
                        lea         di,     OFFSET AA
                        mov         ax,     ss
                      ELSE        
                        mov         di,     OFFSET AA
                        mov         ax,     cs
                      ENDIF       
                      mov         es,       ax
                      mov         cx,       4
                      cld         
                      push        cx
                      push        si
                      rep         movsd
                      pop         si
                      pop         cx
                      rep         movsd
                    ENDIF       
                    lds         si,         hashdata      ; *data[64]
                    les         di,         digest        ; *hash[16]
                    IFNDEF         __NOSTOR
                      STOR        AA,       A             ;
                      STOR        BB,       B
                      STOR        CC,       C
                      STOR        DD0,      D
                      STOR        AAA0,     A
                      STOR        BBB,      B
                      STOR        CCC,      C
                      STOR        DDD,      D
                    ENDIF
; -Round 1 -----------------------------------------------------------------
                    FF          AA,         BB, CC, DD0, X.[4*0], 11
                    FF          DD0,        AA, BB, CC, X.[4*1], 14
                    FF          CC,         DD0, AA, BB, X.[4*2], 15
                    FF          BB,         CC, DD0, AA, X.[4*3], 12
                    FF          AA,         BB, CC, DD0, X.[4*4], 5
                    FF          DD0,        AA, BB, CC, X.[4*5], 8
                    FF          CC,         DD0, AA, BB, X.[4*6], 7
                    FF          BB,         CC, DD0, AA, X.[4*7], 9
                    FF          AA,         BB, CC, DD0, X.[4*8], 11
                    FF          DD0,        AA, BB, CC, X.[4*9], 13
                    FF          CC,         DD0, AA, BB, X.[4*10], 14
                    FF          BB,         CC, DD0, AA, X.[4*11], 15
                    FF          AA,         BB, CC, DD0, X.[4*12], 6
                    FF          DD0,        AA, BB, CC, X.[4*13], 7
                    FF          CC,         DD0, AA, BB, X.[4*14], 9
                    FF          BB,         CC, DD0, AA, X.[4*15], 8
                    FFF         AAA0,       BBB, CCC, DDD, X.[4*0], 11
                    FFF         DDD,        AAA0, BBB, CCC, X.[4*1], 14
                    FFF         CCC,        DDD, AAA0, BBB, X.[4*2], 15
                    FFF         BBB,        CCC, DDD, AAA0, X.[4*3], 12
                    FFF         AAA0,       BBB, CCC, DDD, X.[4*4], 5
                    FFF         DDD,        AAA0, BBB, CCC, X.[4*5], 8
                    FFF         CCC,        DDD, AAA0, BBB, X.[4*6], 7
                    FFF         BBB,        CCC, DDD, AAA0, X.[4*7], 9
                    FFF         AAA0,       BBB, CCC, DDD, X.[4*8], 11
                    FFF         DDD,        AAA0, BBB, CCC, X.[4*9], 13
                    FFF         CCC,        DDD, AAA0, BBB, X.[4*10], 14
                    FFF         BBB,        CCC, DDD, AAA0, X.[4*11], 15
                    FFF         AAA0,       BBB, CCC, DDD, X.[4*12], 6
                    FFF         DDD,        AAA0, BBB, CCC, X.[4*13], 7
                    FFF         CCC,        DDD, AAA0, BBB, X.[4*14], 9
                    FFF         BBB,        CCC, DDD, AAA0, X.[4*15], 8
; - Round 2 ----------------------------------------------------------------
                    GG          AA,         BB, CC, DD0, X.[4*7], 7
                    GG          DD0,        AA, BB, CC, X.[4*4], 6
                    GG          CC,         DD0, AA, BB, X.[4*13], 8
                    GG          BB,         CC, DD0, AA, X.[4*1], 13
                    GG          AA,         BB, CC, DD0, X.[4*10], 11
                    GG          DD0,        AA, BB, CC, X.[4*6], 9
                    GG          CC,         DD0, AA, BB, X.[4*15], 7
                    GG          BB,         CC, DD0, AA, X.[4*3], 15
                    GG          AA,         BB, CC, DD0, X.[4*12], 7
                    GG          DD0,        AA, BB, CC, X.[4*0], 12
                    GG          CC,         DD0, AA, BB, X.[4*9], 15
                    GG          BB,         CC, DD0, AA, X.[4*5], 9
                    GG          AA,         BB, CC, DD0, X.[4*14], 7
                    GG          DD0,        AA, BB, CC, X.[4*2], 11
                    GG          CC,         DD0, AA, BB, X.[4*11], 13
                    GG          BB,         CC, DD0, AA, X.[4*8], 12
                    GGG         AAA0,       BBB, CCC, DDD, X.[4*7], 7
                    GGG         DDD,        AAA0, BBB, CCC, X.[4*4], 6
                    GGG         CCC,        DDD, AAA0, BBB, X.[4*13], 8
                    GGG         BBB,        CCC, DDD, AAA0, X.[4*1], 13
                    GGG         AAA0,       BBB, CCC, DDD, X.[4*10], 11
                    GGG         DDD,        AAA0, BBB, CCC, X.[4*6], 9
                    GGG         CCC,        DDD, AAA0, BBB, X.[4*15], 7
                    GGG         BBB,        CCC, DDD, AAA0, X.[4*3], 15
                    GGG         AAA0,       BBB, CCC, DDD, X.[4*12], 7
                    GGG         DDD,        AAA0, BBB, CCC, X.[4*0], 12
                    GGG         CCC,        DDD, AAA0, BBB, X.[4*9], 15
                    GGG         BBB,        CCC, DDD, AAA0, X.[4*5], 9
                    GGG         AAA0,       BBB, CCC, DDD, X.[4*14], 7
                    GGG         DDD,        AAA0, BBB, CCC, X.[4*2], 11
                    GGG         CCC,        DDD, AAA0, BBB, X.[4*11], 13
                    GGG         BBB,        CCC, DDD, AAA0, X.[4*8], 12
; - Round 3 ----------------------------------------------------------------
                    HH          AA,         BB, CC, DD0, X.[4*3], 11
                    HH          DD0,        AA, BB, CC, X.[4*10], 13
                    HH          CC,         DD0, AA, BB, X.[4*2], 14
                    HH          BB,         CC, DD0, AA, X.[4*4], 7
                    HH          AA,         BB, CC, DD0, X.[4*9], 14
                    HH          DD0,        AA, BB, CC, X.[4*15], 9
                    HH          CC,         DD0, AA, BB, X.[4*8], 13
                    HH          BB,         CC, DD0, AA, X.[4*1], 15
                    HH          AA,         BB, CC, DD0, X.[4*14], 6
                    HH          DD0,        AA, BB, CC, X.[4*7], 8
                    HH          CC,         DD0, AA, BB, X.[4*0], 13
                    HH          BB,         CC, DD0, AA, X.[4*6], 6
                    HH          AA,         BB, CC, DD0, X.[4*11], 12
                    HH          DD0,        AA, BB, CC, X.[4*13], 5
                    HH          CC,         DD0, AA, BB, X.[4*5], 7
                    HH          BB,         CC, DD0, AA, X.[4*12], 5
                    HHH         AAA0,       BBB, CCC, DDD, X.[4*3], 11
                    HHH         DDD,        AAA0, BBB, CCC, X.[4*10], 13
                    HHH         CCC,        DDD, AAA0, BBB, X.[4*2], 14
                    HHH         BBB,        CCC, DDD, AAA0, X.[4*4], 7
                    HHH         AAA0,       BBB, CCC, DDD, X.[4*9], 14
                    HHH         DDD,        AAA0, BBB, CCC, X.[4*15], 9
                    HHH         CCC,        DDD, AAA0, BBB, X.[4*8], 13
                    HHH         BBB,        CCC, DDD, AAA0, X.[4*1], 15
                    HHH         AAA0,       BBB, CCC, DDD, X.[4*14], 6
                    HHH         DDD,        AAA0, BBB, CCC, X.[4*7], 8
                    HHH         CCC,        DDD, AAA0, BBB, X.[4*0], 13
                    HHH         BBB,        CCC, DDD, AAA0, X.[4*6], 6
                    HHH         AAA0,       BBB, CCC, DDD, X.[4*11], 12
                    HHH         DDD,        AAA0, BBB, CCC, X.[4*13], 5
                    HHH         CCC,        DDD, AAA0, BBB, X.[4*5], 7
                    HHH         BBB,        CCC, DDD, AAA0, X.[4*12], 5
; --------------------------------------------------------------------------
                    mov         edx,        DDD
                    add         edx,        CC
                    add         edx,        B
                    mov         eax,        C
                    add         eax,        DD0
                    add         eax,        AAA0
                    mov         B,          eax
                    mov         eax,        D
                    add         eax,        AA
                    add         eax,        BBB
                    mov         C,          eax
                    mov         eax,        A
                    add         eax,        BB
                    add         eax,        CCC
                    mov         D,          eax
                    mov         A,          edx
                    pop         ds               ;
                    ret      
RIPEMDTransform     ENDP

                  END
