/*
 * The author of this code is John Ioannidis, ji@tla.org,
 * 	(except when noted otherwise).
 *
 * This code was written in Athens, Greece, in November 1995.
 *
 * Copyright (C) 1995, by John Ioannidis.
 *	
 * Permission to use, copy, and modify this software without fee
 * is hereby granted, provided that this entire notice is included in
 * all copies of any software which is or includes a copy or
 * modification of this software.
 *
 * THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTY. IN PARTICULAR, THE AUTHOR DOES NOT MAKE ANY
 * REPRESENTATION OR WARRANTY OF ANY KIND CONCERNING THE MERCHANTABILITY
 * OF THIS SOFTWARE OR ITS FITNESS FOR ANY PARTICULAR PURPOSE.
 */

/*
 * HISTORY
 *
 * $Log: ip_ipsp.h,v $
 * Revision 1.2  1995/11/30  04:35:39  ji
 * Performed cosmetic changes and verified SPIs are endian-proof.
 *
 *
 */

/*
 * IPSP global definitions.
 */

struct tdb				/* tunnel descriptor block */
{
	struct tdb	*tdb_hnext;	/* next in hash chain */
	struct tdb	*tdb_onext;	/* next in output */
	struct tdb	*tdb_inext;	/* next in input (prev!) */
	u_long		tdb_spi;	/* SPI to use */
	struct in_addr	tdb_dst;	/* dest address for this SPI */
	struct ifnet	*tdb_rcvif;	/* related rcv encap interface */
	struct xformsw	*tdb_xform;	/* transformation to use */
	caddr_t		tdb_xdata;	/* transformation data (opaque) */
};

#define TDB_HASHMOD	257

struct xformsw
{
	u_short		xf_type;	/* Unique ID of xform */
	u_short		xf_flags;	/* flags (see below) */
	char		*xf_name;	/* human-readable name */
	int		(*xf_attach)();	/* called at config time */
	int		(*xf_init)();	/* xform initialization */
	int		(*xf_zeroize)(); /* termination */
	struct mbuf 	*(*xf_input)();	/* called when packet received */
	int		(*xf_output)();	/* called when packet sent */
};

#define XF_IP4		1		/* IP inside IP */
#define XF_AHMD5	2		/* AH MD5 */
#define XF_AHSHA	3		/* AH SHA */
#define XF_ESPDES	4		/* ESP DES-CBC */
#define XF_ESP3DES	5		/* ESP DES3-CBC */
#define XF_AHHMACMD5	6		/* AH-HMAC-MD5 with opt replay prot */
#define XF_AHHMACSHA	7		/* AH-HMAC-SHA with opt replay prot */
#define XF_ESPMD5DES	8

#define XFT_AUTH	0x0001
#define XFT_CONF	0x0100

#ifdef KERNEL
#define ENCDEBUG
extern int encdebug;


struct tdb *tdbh[TDB_HASHMOD];
extern struct xformsw xformsw[], *xformswNXFORMSW;

extern struct tdb *gettdb(u_long, struct in_addr);
void puttdb(struct tdb *);

extern int ipe4_attach(), ipe4_init(), ipe4_zeroize();
extern int ipe4_output(struct mbuf *, struct sockaddr_encap *, struct tdb *, struct mbuf **);
extern struct mbuf *ipe4_input(struct mbuf *, struct tdb *);

extern int ahmd5_attach(), ahmd5_init(), ahmd5_zeroize();
extern int ahmd5_output(struct mbuf *, struct sockaddr_encap *, struct tdb *, struct mbuf **);
extern struct mbuf *ahmd5_input(struct mbuf *, struct tdb *);

extern int espdes_attach(), espdes_init(), espdes_zeroize();
extern int espdes_output(struct mbuf *, struct sockaddr_encap *, struct tdb *, struct mbuf **);
extern struct mbuf *espdes_input(struct mbuf *, struct tdb *);

extern caddr_t m_pad(struct mbuf *, int);

#endif
