/* get-next-event loop
 * Copyright (C) 1998, 1999  D. Hugh Redelmeier.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: server.h,v 1.10 1999/12/12 22:27:25 dhr Exp $
 */

extern struct sockaddr_un ctl_addr;	/* address of control (whack) socket */
extern void delete_ctl_socket(void);
extern int pfkeyfd;

extern bool listening;	/* should we pay attention to IKE messages? */


/* IP interface (eg. ipsec0/eth0) */
struct iface {
    char *vname;	/* virtual device name */
    char *rname;	/* real device name */
    struct in_addr addr;	/* interface IP address (network order) */
    int fd;	/* file descriptor of socket for IKE UDP messages */
    struct iface *next;
};

extern struct iface *interfaces;	/* public interfaces */

extern void find_ifaces(void);
extern void free_ifaces(void);
extern void call_server(void);
