/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 *
 * Changes by Angelos D. Keromytis and Niels Provos
 * ported from OpenBSD 2.2 by Petr Novak, <pn@i.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#define __NO_VERSION__

#include <linux/module.h>
#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#ifdef CONFIG_IPSEC_ESP
#include "ipsec_esp.h"
#endif

#ifdef DEBUG_IPSEC_ESP
int debug_esp = 0xffffffff;
#endif

int
esp_rcv(struct sk_buff *skb, struct device *dev, struct options *opt, 
		__u32 daddr, unsigned short len, __u32 saddr,
                                   int redo, struct inet_protocol *protocol)
{
	struct iphdr *ipp;
	struct esp_old *espp;
	int iphlen;
#ifdef DEBUG_IPSEC_ESP
	int i;
#endif
	unsigned char *dat;
	struct tdb *tdbp;
	struct in_addr iadst;
	
	/* Don't unlink in the middle of a turnaround */
	MOD_INC_USE_COUNT;
	
	len = skb->len; dat = skb->data;
	
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_PKTRX)
	{
		printk("ipsec_esp: old ip packet is %d bytes:", len);
		for (i = 0; i < len; i++)
			printk(" %02x", dat[i]);
		printk("\n");
	}
#endif

	ipp = (struct iphdr *)skb->data;
	iphlen = ipp->ihl << 2;
	ipp->check = 0;			/* we know the sum is good */
	espp = (struct esp_old *)(skb->data + iphlen);

	/*
	 * Find tunnel control block and (indirectly) call the appropriate
	 * tranform routine. The resulting sk_buf is a valid
	 * IP packet ready to go through input processing.
	 */

	iadst.s_addr = ipp->daddr;
	tdbp = gettdb(espp->esp_spi, iadst);
	if (tdbp == NULL)
	{
#ifdef DEBUG_IPSEC_ESP
		if (debug_esp & DB_ES_TDB)
			printk("esp_input: no tdb for spi=%x\n", (u_int)ntohl(espp->esp_spi));
#endif
		goto rcvleave;
	}

	if (tdbp->tdb_flags & TDBF_INVALID)
	{
		if (debug_esp & DB_ES_TDB)
			printk("esp_input(): attempted to use invalid ESP SA %lx, packet %x->%x\n", ntohl(espp->esp_spi), ipp->saddr, ipp->daddr);
		goto rcvleave;
	}

	if (tdbp->tdb_xform == NULL)
	{
#ifdef DEBUG_IPSEC_ESP
		if (debug_esp & DB_ES_XF)
			printk("esp_input: no xform for spi=%x\n", (u_int)ntohl(espp->esp_spi));
#endif 

		goto rcvleave;
	}

	skb = (*(tdbp->tdb_xform->xf_input))(skb, tdbp);
	
	if (skb == NULL)
	{
		goto rcvleave;
	}

	len = skb->len; dat = skb->data;

#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_PKTRX)
	{
		printk("ipsec_esp: new ip packet is %d bytes:", len);
		for (i = 0; i < len; i++)
			printk(" %02x", dat[i]);
		printk("\n");
	}
#endif

	skb->protocol = htons(ETH_P_IP);
	skb->ip_summed = 0;

	ipp = (struct iphdr *)skb->data;

	if (ipp->protocol == IPPROTO_IPIP)	/* IP-in-IP encapsulation */
	{
	    /* Encapsulating SPI */
	    if (tdbp->tdb_osrc.s_addr && tdbp->tdb_odst.s_addr)
	    {
/* OpenBSD has a test for match of outer and inner IP addresses */
		;
	    }
	    else	/* So we're paranoid */
	    {
		if (debug_esp & DB_ES_XF)
			printk("esp_input(): ESP-tunnel used when expecting ESP-transport, SA %08x/%x\n", tdbp->tdb_spi, tdbp->tdb_dst.s_addr);
		goto rcvleave;
	    }
	}
			
	netif_rx(skb);
	
     rcvleave:
	MOD_DEC_USE_COUNT;
	return(0);
}


struct inet_protocol esp_protocol = {
	esp_rcv,			/* ESP handler          */
#if 0
	NULL,				/* Will be UDP fraglist handler */
#endif
	NULL,				/* TUNNEL error control */
	0,				/* next */
	IPPROTO_ESP,			/* protocol ID */
	0,				/* copy */
	NULL,				/* data */
	"ESP"				/* name */
};
