/*
 *
 *			   IPSEC for Linux
 *		         Preliminary Release
 * 
 *	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 * 
 * Changes by Angelos D. Keromytis and Niels Provos
 * ported from OpenBSD 2.2 by Petr Novak, <pn@i.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <asm/io.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#include "ipsec_ipe4.h"
#ifdef CONFIG_IPSEC_AH
#include "ipsec_ah.h"
#endif

#ifdef DEBUG_IPSEC_NETLINK

int debug_netlink = 0;

#endif

/*
 * IPSEC <> netlink interface.
 */

#define SENDERR(_x) do { len = -(_x); goto errlab; } while (0)

int 
ipsec_callback(struct sk_buff *skb)
{
	/*
	 * this happens when we write to /dev/ipsec (c 36 10)
	 */
	int len = skb->len;
	u_char *dat = (u_char *)skb->data;
	struct encap_msghdr *emp;
	struct tdb *tdbp, *tdbp2;
	int error;
	__u32 spi;
	caddr_t	buffer = 0;
#ifdef DEBUG_IPSEC_NETLINK
	struct eroute *eret;
#endif	
	emp = (struct encap_msghdr *)dat;
	if (emp->em_version != PFENCAP_VERSION_1)
	{
		return -EINVAL;
	}
	
	switch (emp->em_type)
	{
   	      case EMT_SETEROUTE:
		ipsec_makeroute(&(emp->em_eaddr), &(emp->em_emask), emp->em_erdst, emp->em_erspi);
		break;

#ifdef DEBUG_IPSEC_NETLINK
	      case EMT_TESTROUTE:
		      
		printk("ipsec_callback: testroute: trying to locate 0x%08x->0x%08x\n", (u_int)emp->em_eaddr.sen_ip_src.s_addr, (u_int)emp->em_eaddr.sen_ip_dst.s_addr);

		eret = ipsec_findroute(&(emp->em_eaddr));
		
		if (eret == NULL)
		{
			printk(" not found\n");
		}
		else
		{
			printk(" via 0x%08x, 0x%x\n", (u_int)ntohl(eret->er_dst.s_addr), (u_int)ntohl(eret->er_spi));
		}
		break;
#endif

	      case EMT_DELEROUTE:
		ipsec_delroute(&(emp->em_eaddr), &(emp->em_emask));
		break;

	      case EMT_SETSPI:
		tdbp = gettdb(emp->em_spi, emp->em_dst);
		if (tdbp == NULL)
		{
#ifdef DEBUG_IPSEC_NETLINK
			if (debug_netlink & DB_NL_TDBCB)
				printk("ipsec_callback: could not find a TDB for 0x%08x, 0x%08x, allocating\n", (u_int)ntohl(emp->em_spi), (u_int)ntohl(emp->em_dst.s_addr));
#endif
			tdbp = (struct tdb *)kmalloc(sizeof (*tdbp), GFP_ATOMIC);

			if (tdbp == NULL)
			  SENDERR(ENOBUFS);
			
			memset((caddr_t)tdbp, 0, sizeof(*tdbp));
			
			tdbp->tdb_spi = emp->em_spi;
			tdbp->tdb_dst = emp->em_dst;
			puttdb(tdbp);
		}
		else
		{
			if (tdbp->tdb_xform)
				(*tdbp->tdb_xform->xf_zeroize)(tdbp);
		}
		
		tdbp->tdb_src = emp->em_src;

		/* Check if this is an encapsulating SPI */
		if (emp->em_osrc.s_addr != 0)
		{
			tdbp->tdb_flags |= TDBF_TUNNELING;
			tdbp->tdb_osrc = emp->em_osrc;
			tdbp->tdb_odst = emp->em_odst;

			/* TTL */
			switch (emp->em_ttl)
			{
				case IP4_DEFAULT_TTL:
					tdbp->tdb_ttl = 0;
					break;

				case IP4_SAME_TTL:
					tdbp->tdb_flags |= TDBF_SAME_TTL;
					break;

				default:
					/* Get just the least significant bits */
					tdbp->tdb_ttl = emp->em_ttl & 0xff;
					break;
			}
		}

		/* Clear the invalid flag */
		tdbp->tdb_flags &= (~TDBF_INVALID);

		error = tdb_init(tdbp, emp);
		if (error)
		{
			tdb_delete(tdbp, 0);
			SENDERR(EINVAL);
		}

		break;
	      case EMT_DELSPI:
		if (len != EMT_DELSPI_FLEN)
			SENDERR(EINVAL);

		if ((tdbp = gettdb(emp->em_gen_spi, emp->em_gen_dst)) == NULL)
			SENDERR(ENOENT);

		error = tdb_delete(tdbp, 0);
		if (error)
			SENDERR(EINVAL);

		break;
		
	      case EMT_DELSPICHAIN:
		if (len != EMT_DELSPICHAIN_FLEN)
			SENDERR(EINVAL);

		if ((tdbp = gettdb(emp->em_gen_spi, emp->em_gen_dst)) == NULL)
			SENDERR(ENOENT);

		error = tdb_delete(tdbp, 1);
		if (error)
			SENDERR(EINVAL);

		break;

	      case EMT_GRPSPIS:
		if (len != EMT_GRPSPIS_FLEN)
			SENDERR(EINVAL);

		if ((tdbp = gettdb(emp->em_rel_spi, emp->em_rel_dst)) == NULL)
		{
			printk("ipsec_callback: groupspis: no TDB for 0x%08x, %08x\n", (u_int)ntohl(emp->em_rel_dst.s_addr), (u_int)ntohl(emp->em_rel_spi));
			SENDERR(ENOENT);
		}

		if ((tdbp2 = gettdb(emp->em_rel_spi2, emp->em_rel_dst2)) == NULL)
		{
			printk("ipsec_callback: groupspis: no TDB for 0x%08x, %08x\n", (u_int)ntohl(emp->em_rel_dst2.s_addr), (u_int)ntohl(emp->em_rel_spi2));
			SENDERR(ENOENT);
		}
		
		tdbp->tdb_onext = tdbp2;
		tdbp2->tdb_inext = tdbp;

		error = 0;

		break;

	      case EMT_RESERVESPI:
		if (len != EMT_RESERVESPI_FLEN)
			SENDERR(EINVAL);

		spi = reserve_spi(emp->em_gen_spi, emp->em_gen_dst, &error);
		if (spi == 0)
			SENDERR(error);

		emp->em_gen_spi = spi;

#if 0
		/* If we're using a buffer, copy the data back to an mbuf. */
		if (buffer)
			m_copyback(m, 0, len, buffer);

		/* Send it back to us */
		if (sbappendaddr(&so->so_rcv, &encap_src, m,
                             (struct mbuf *) 0) == 0)
			SENDERR(ENOBUFS);
		else
			sorwakeup(so);            /* wakeup  */

		m = NULL;                   /* So it's not free'd */
#endif

		error = 0;

		break;

	      default:
		printk("ipsec_callback: unknown message type\n");
	}
	
      errlab:
	return len;
}
