/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_esp3desmd5.c,v 0.5 1997/06/03 04:24:48 ji Rel $
 *
 * $Log: ipsec_esp3desmd5.c,v $
 * Revision 0.5  1997/06/03 04:24:48  ji
 * Cosmetic changes.
 *
 * Revision 0.4  1997/01/15 01:28:15  ji
 * New transform.
 *
 *
 */

#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#ifdef CONFIG_IPSEC_AH
#include "ipsec_ah.h"
#endif
#ifdef CONFIG_IPSEC_ESP
#include "ipsec_esp.h"
#endif

extern void des_ede3_cbc_encrypt(caddr_t, caddr_t, int, caddr_t, caddr_t, caddr_t, caddr_t, int);
extern void des_set_key(caddr_t, caddr_t);

MD5_CTX d1_pad_i, d1_pad_r, d2_pad_i, d2_pad_r, d3_pad_i, d3_pad_r, i_pad_i, i_pad_r, h_pad_i, h_pad_r, r_pad_i, r_pad_r;

#ifdef DEBUG_IPSEC_ESP
static void
print_ip_pkt(struct iphdr *ip)
{
	int i, len;
	unsigned char *d = (unsigned char *)ip;
	len = ntohs(ip->tot_len);
	
	printk("packet length: %d", len);
	for (i = 0; i < len; i++)
		printk(" %02x", d[i]);
	printk("\n");
}

	
#ifdef NOLONGER_DEBUG_IPSEC_ESP
static void
print_ip(struct iphdr *ip)
{
	unsigned char *ipaddr;

	printk("IP packet:\n");
	printk("--- header len = %d\n", ip->ihl*4);
	printk("--- ip version: %d\n", ip->version);
	printk("--- ip protocol: %d\n", ip->protocol);
	ipaddr=(unsigned char *)&ip->saddr;
	printk("--- source address: %u.%u.%u.%u\n", 
			*ipaddr, *(ipaddr+1), *(ipaddr+2), *(ipaddr+3));
	ipaddr=(unsigned char *)&ip->daddr;
	printk("--- destination address: %u.%u.%u.%u\n", 
			*ipaddr, *(ipaddr+1), *(ipaddr+2), *(ipaddr+3));
	printk("--- total packet len: %d\n", ntohs(ip->tot_len));
}
#endif
#endif

/*
 * Check-replay-window routine, adapted from the original 
 * by J. Hughes, from draft-ietf-ipsec-esp-des-md5-03.txt
 *
 *  This is a routine that implements a 64 packet window. This is intend-
 *  ed on being an implementation sample.
 */

static int
esp_checkreplaywindow(struct esp3desmd5_xdata *xd, unsigned long seq)
{
	unsigned long diff;
	
	if (seq == 0) 
		return 0;		/* first == 0 or wrapped */

	if (seq > xd->edmx_lastseq)	/* new larger sequence number */
	{
		diff = seq - xd->edmx_lastseq;
		if (diff < xd->edmx_ooowin) /* In win, set bit for this pkt */
			xd->edmx_bitmap = (xd->edmx_bitmap << diff) | 1;
		else
			xd->edmx_bitmap = 1; /* This packet has way larger */

		xd->edmx_lastseq = seq;
		return 1;		/* larger is good */
	}
	diff = xd->edmx_lastseq - seq;
	if (diff >= xd->edmx_ooowin)	/* too old or wrapped */
		return 0;
	
	if (xd->edmx_bitmap & (1 << diff)) /* this packet already seen */
		return 0;
	xd->edmx_bitmap |= (1 << diff);	/* mark as seen */
	return 1;			/* out of order but good */
}

struct sk_buff *
esp3desmd5_input(struct sk_buff *skb, struct tdb *tdbp)
{
	struct iphdr *ipp;
	struct esp3desmd5_xdata *xd;
	u_long *espp, seq;
	int iphlen, esphlen, proto, len, pad, ilen;

	MD5_CTX tctx;
	u_char mdchk[16];

	unsigned char *dat, *idat;
	u_long iv[2], iv2[2];
	
	len = skb->len; dat = skb->data;

	ipp = (struct iphdr *)dat;
	iphlen = ipp->ihl << 2;
	espp = (u_long *)(dat + iphlen);
	
	xd = (struct esp3desmd5_xdata *)tdbp->tdb_xdata;

	if (xd->edmx_flags & EME_CONSTIV)
	{
		iv[0] = xd->edmx_iv[0];
		iv[1] = xd->edmx_iv[1];
		esphlen = 4;
	}
	else
	{
		iv[0] = espp[1];
		iv[1] = espp[2];
		esphlen = 12;
	}
	iv2[0] = iv[0]; iv2[1] = iv[1];

	idat = dat + iphlen + esphlen;
	ilen = len - iphlen - esphlen;

	if (ilen % 8)
	{
		printk("ipsec_espdes: got packet
 with ilen = %d \n", ilen);
		return NULL;
	}
	
	des_ede3_cbc_encrypt(idat, idat, ilen, (caddr_t)(xd->edmx_eks1), (caddr_t)(xd->edmx_eks2), (caddr_t)(xd->edmx_eks3), (caddr_t)iv, 0);

	/*
	 * packet is decrypted; verify authenticator
	 */

	tctx = xd->edmx_ictx;
	MD5Update(&tctx, (caddr_t)espp, 4); /* HMAC first four octets */
	MD5Update(&tctx, (caddr_t)iv2, 8);

	MD5Update(&tctx, (caddr_t)(&espp[esphlen/4]), ilen - 16);
	MD5Final(mdchk, &tctx);
	tctx = xd->edmx_octx;
	MD5Update(&tctx, mdchk, sizeof mdchk);
	MD5Final(mdchk, &tctx);

	if (memcmp(mdchk, &(dat[len - 16]), 16))
	{
#ifdef DEBUG_IPSEC_ESP
		if (debug_esp & DB_ES_INAU)
			printk("esp3desmd5_input: bad auth\n");
#endif
		return NULL;
	}

	seq = ntohl(*((unsigned long *)idat)); /* First decrypted word */
	
	if (!esp_checkreplaywindow(xd, seq))
	{
#ifdef DEBUG_IPSEC_ESP
		if (debug_esp & DB_ES_REPLAY)
			printk("espdesmd5_input: duplicate frame\n");
#endif
		return NULL;
	}

	proto = idat[ilen - 16 - 1];
	pad = idat[ilen - 16 - 2] + 2 + 16;
	
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_IPAD)
	  printk("espdes_input: proto = %d, padding = %d\n", proto, pad);
#endif

	/*
	 *	Discard the original IP header
	 */
	 
	ipp->tot_len = htons(ntohs(ipp->tot_len) - esphlen - 4 - pad);
	ipp->protocol = proto;

	memmove((void *)(skb->data + esphlen + 4), (void *)skb->data, iphlen);

	skb_pull(skb, esphlen + 4);
	skb_trim(skb, len - esphlen - 4 - pad);

	/*
	 *	Adjust pointers
	 */
	 
	
	len = skb->len; dat = skb->data;
	

	skb->h.iph=(struct iphdr *)skb->data;
	skb->ip_hdr=(struct iphdr *)skb->data;

	memset(skb->proto_priv, 0, sizeof(struct options));
	
	ipp = (struct iphdr *)dat;
	ipp->check = 0;
	ipp->check = ip_fast_csum((unsigned char *)dat, iphlen >> 2);

	return skb;
}

int
esp3desmd5_attach(void)
{
	u_char pad[64];
	int i;
	
#define PADINIT(c, v) for (i=0; i<64; i++) pad[i] = (v); MD5Init(&(c)); MD5Update(&(c), pad, 64)
#define PADINIT1(z, c, v) pad[0] = (z); for (i=1; i<64; i++) pad[i] = (v); MD5Init(&(c)); MD5Update(&(c), pad, 64)

	PADINIT1(0, d1_pad_i, 0x5c);
	PADINIT1(0, d1_pad_r, 0x3a);
	PADINIT1(1, d2_pad_i, 0x5c);
	PADINIT1(1, d2_pad_r, 0x3a);
	PADINIT1(2, d3_pad_i, 0x5c);
	PADINIT1(2, d3_pad_r, 0x3a);
	PADINIT(i_pad_i, 0xac);
	PADINIT(i_pad_r, 0x55);
	PADINIT(h_pad_i, 0x53);
	PADINIT(h_pad_r, 0x3c);
	PADINIT(r_pad_i, 0x35);
	PADINIT(r_pad_r, 0xcc);

#undef PADINIT
#undef PADINIT1
	
	printk("esp3desmd5_attach: called.\n");

	return 0;
}

/*
 * espdes_init() is called when an SPI is being set up. It interprets the
 * encap_msghdr present in m, and sets up the transformation data.
 */

int
esp3desmd5_init(struct tdb *tdbp, struct xformsw *xsp, struct encap_msghdr *em)
{
	struct espblkrply_edata *ed;
	struct esp3desmd5_xdata *xd;

	__u32 mdoutput[16];		/* temp space for MD5 digests */
	MD5_CTX d1_pad, d2_pad, d3_pad, i_pad, h_pad, r_pad;
	
	tdbp->tdb_xform = xsp;

	if ((em->em_msglen - EMT_SETSPI_FLEN) > sizeof (struct espblkrply_edata))
		return EINVAL;

	tdbp->tdb_xdata = (caddr_t)kmalloc(sizeof (struct esp3desmd5_xdata), GFP_ATOMIC); /* XXX memory leak here if updating old TDB? */

	if (tdbp->tdb_xdata == NULL)
	  return ENOBUFS;
	memset(tdbp->tdb_xdata, 0, sizeof (struct esp3desmd5_xdata));

	xd = (struct esp3desmd5_xdata *)tdbp->tdb_xdata;
	ed = (struct espblkrply_edata *)em->em_dat;

	xd->edmx_flags = ed->eme_flags;
	xd->edmx_ooowin = ed->eme_ooowin;
	
	if (xd->edmx_flags & EME_INITIATOR)
	{
		d1_pad = d1_pad_i;
		d2_pad = d2_pad_i;
		d3_pad = d3_pad_i;
		i_pad = i_pad_i;
		h_pad = h_pad_i;
		r_pad = r_pad_i;
	}
	else
	{
		d1_pad = d1_pad_r;
		d2_pad = d2_pad_r;
		d3_pad = d3_pad_r;
		i_pad = i_pad_r;
		h_pad = h_pad_r;
		r_pad = r_pad_r;
	}
		
	MD5Update(&d1_pad, ed->eme_key, ed->eme_klen);
	MD5Final((unsigned char *)mdoutput, &d1_pad);
	des_set_key((caddr_t)mdoutput, (caddr_t)(xd->edmx_eks1));

	MD5Update(&d2_pad, ed->eme_key, ed->eme_klen);
	MD5Final((unsigned char *)mdoutput, &d2_pad);
	des_set_key((caddr_t)mdoutput, (caddr_t)(xd->edmx_eks2));

	MD5Update(&d3_pad, ed->eme_key, ed->eme_klen);
	MD5Final((unsigned char *)mdoutput, &d3_pad);
	des_set_key((caddr_t)mdoutput, (caddr_t)(xd->edmx_eks3));

	if (xd->edmx_flags & EME_CONSTIV)
	{
		MD5Update(&i_pad, ed->eme_key, ed->eme_klen);
		MD5Final((unsigned char *)mdoutput, &i_pad);
		xd->edmx_iv[0] = mdoutput[0];
		xd->edmx_iv[1] = mdoutput[1];
	}
	else
	{
		xd->edmx_iv[0] = ed->eme_ivl[0];
		xd->edmx_iv[1] = ed->eme_ivl[1];
	}

	MD5Update(&h_pad, ed->eme_key, ed->eme_klen);
	MD5Final((unsigned char *)mdoutput, &h_pad);
	/*
	 * HMAC_key is now contained in the first 128 bits of mdoutput.
	 * Pad with zeros and XOR with 0x36 to create the inner context
	 */
	
	mdoutput[0] ^= 0x36363636;	mdoutput[1] ^= 0x36363636;
	mdoutput[2] ^= 0x36363636;	mdoutput[3] ^= 0x36363636;
	mdoutput[4] = 0x36363636;	mdoutput[5] = 0x36363636;
	mdoutput[6] = 0x36363636;	mdoutput[7] = 0x36363636;
	mdoutput[8] = 0x36363636;	mdoutput[9] = 0x36363636;
	mdoutput[10] = 0x36363636;	mdoutput[11] = 0x36363636;
	mdoutput[12] = 0x36363636;	mdoutput[13] = 0x36363636;
	mdoutput[14] = 0x36363636;	mdoutput[15] = 0x36363636;
	
	MD5Init(&xd->edmx_ictx);
	MD5Update(&xd->edmx_ictx, (unsigned char *)mdoutput, sizeof mdoutput);
		
	mdoutput[0] ^= 0x6a6a6a6a;	mdoutput[1] ^= 0x6a6a6a6a;
	mdoutput[2] ^= 0x6a6a6a6a;	mdoutput[3] ^= 0x6a6a6a6a;
	mdoutput[4] ^= 0x6a6a6a6a;	mdoutput[5] ^= 0x6a6a6a6a;
	mdoutput[6] ^= 0x6a6a6a6a;	mdoutput[7] ^= 0x6a6a6a6a;
	mdoutput[8] ^= 0x6a6a6a6a;	mdoutput[9] ^= 0x6a6a6a6a;
	mdoutput[10] ^= 0x6a6a6a6a;	mdoutput[11] ^= 0x6a6a6a6a;
	mdoutput[12] ^= 0x6a6a6a6a;	mdoutput[13] ^= 0x6a6a6a6a;
	mdoutput[14] ^= 0x6a6a6a6a;	mdoutput[15] ^= 0x6a6a6a6a;
	
	MD5Init(&xd->edmx_octx);
	MD5Update(&xd->edmx_octx, (unsigned char *)mdoutput, sizeof mdoutput);

	MD5Update(&r_pad, (unsigned char *)ed->eme_key, ed->eme_klen);
	MD5Final((unsigned char *)mdoutput, &r_pad);
	xd->edmx_lastseq = ntohl(mdoutput[0]);

	return 0;
}



int
esp3desmd5_zeroize(void)
{
	return 0;
}

int
esp3desmd5_print(void *xdat, char *buf)
{
	int size;
	int i, ds;
	union 
	{
		u_char c[8];
		u_long l[2];
	}cl;

	struct esp3desmd5_xdata *xd = (struct esp3desmd5_xdata *)xdat;
	size = sprintf(buf, "iv =");
	buf += size;

	cl.l[0] = xd->edmx_iv[0];
	cl.l[1] = xd->edmx_iv[1];
	
	for (i = 0; i < 8; i++)
	{
		ds = sprintf(buf, " %02x", cl.c[i]);
		buf += ds;
		size += ds;
	}

	ds = sprintf(buf, " seq = 0x%08x, bit = %08x, win = %d", xd->edmx_lastseq, xd->edmx_bitmap, xd->edmx_ooowin);
	buf += ds;
	size += ds;
	

	ds = sprintf(buf, " flags = %x <", xd->edmx_flags);
	buf += ds;
	size += ds;

	if (xd->edmx_flags & EME_CONSTIV)
	{
		ds = sprintf(buf, "CONSTIV,");
		buf += ds;
		size += ds;
	}

	/* 
	 * (other flag printing goes here)
	 */

	if (xd->edmx_flags & EME_INITIATOR)
		ds = sprintf(buf, "INITIATOR>");
	else
		ds = sprintf(buf, "RESPONDER>");
	buf += ds;
	size += ds;

#ifdef ESPPRINTKEYS
	ds = sprintf(buf, ", ks = ");
	buf += ds;
	size += ds;
	
	for (i = 8; i < 136; i++)
	{
		ds = sprintf(buf, " %02x", xd->edmx_iv[i]);
		buf += ds;
		size += ds;
	}
#endif
	return size;
}

int
esp3desmd5_room(struct tdb *tp, int iphlen, int tlen, int *hr, int *tr)
{
	struct esp3desmd5_xdata *xd = (struct esp3desmd5_xdata *)(tp->tdb_xdata) ;
	
	*hr += 4 + 4 			/* SPI + count */ 
		+ ((xd->edmx_flags & EME_CONSTIV) ? 0 : 8); /* IV */
		
	/* the +4 accounts for the length of the counter */
	*tr += ((8 - ((tlen + 4 + 2) % 8)) % 8) + 2 /* padding */
		+ 16;			/* 128-bit MD5 HMAC */
	
	return 0;
}

int
esp3desmd5_output(struct sk_buff *skb, struct tdb *tdbp)
{
	struct iphdr *ipp;
	struct esp3desmd5_xdata *xd;
	__u32 *espp;
	int iphlen, esphlen, hrm, trm, len, ilen;
	unsigned char *dat, *idat;
	MD5_CTX tctx;
	__u32 thash[4];
	__u32 iv[2];
	
	ipp = (struct iphdr *)(skb->data);
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OINFO)
	{
		printk("espdes_output: old header (headroom = %d, tailroom = %d\n", skb_headroom(skb), skb_tailroom(skb));
		print_ip_pkt(ipp);
	}

#endif	
	iphlen = ipp->ihl << 2;
	if (iphlen != sizeof (struct iphdr))
	{
		printk("espdes_output: cannot process options yet\n"); /* XXX */
		return -1;
	}

	xd = (struct esp3desmd5_xdata *)(tdbp->tdb_xdata);

	/* see esp3desmd5_room() for next two lines */

	hrm = 8 + ((xd->edmx_flags & EME_CONSTIV) ? 0 : 8);
	trm = ((8 - ((skb->len - iphlen + 4 + 2) % 8)) % 8) + 2 + 16;

	dat = skb_push(skb, hrm);
	ilen = skb->len;
	len = ilen + trm;
	
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OINFO2)
		printk("before skb_trim: %d,%d (need: %d,%d)", skb_headroom(skb), skb_tailroom(skb), hrm, trm);
#endif
	skb_put(skb, trm);
#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OINFO2)
		printk(" after skb_trim: %d,%d\n", skb_headroom(skb), skb_tailroom(skb));
#endif	
	memmove((void *)dat, (void *)(dat + hrm), iphlen);
	espp = (__u32 *)(dat + iphlen);
	ipp = (struct iphdr *)dat;

	if (ntohs(ipp->frag_off) & IP_OFFSET)
	{
		printk("espdes_output: attempted to encrypt fragment!\n");
		return -1;
	}

	tctx = xd->edmx_ictx;

	espp[0] = tdbp->tdb_spi;
	MD5Update(&tctx, (caddr_t)espp, 4); /* HMAC first four octets */
	
	if (xd->edmx_flags & EME_CONSTIV)
	{
		esphlen = 4;		/* what's not encrypted */
		iv[0] = xd->edmx_iv[0];
		iv[1] = xd->edmx_iv[1];
		espp[1] = htonl(xd->edmx_lastseq++);
		MD5Update(&tctx, (caddr_t)(xd->edmx_iv), 8);
	}
	else
	{
		esphlen = 12;		/* what's not encrypted */
		iv[0] = espp[1] = xd->edmx_iv[0];
		iv[1] = espp[2] = xd->edmx_iv[1];
		espp[3] = htonl(xd->edmx_lastseq++);
		if ((xd->edmx_iv[1]++ == 0) && (xd->edmx_iv[0]++ == 0))
			xd->edmx_iv[1] = 1; /* wrapped around!!! */
	}
	
	/*
	 * XXX -- should randomize the 0..6 padding bytes.
	 */
	dat[len - 16 - 1] = ipp->protocol;
	dat[len - 16 - 2] = trm - 2 - 16;

	MD5Update(&tctx, (caddr_t)(&espp[1]), len - iphlen - 4 - 16);
	MD5Final((unsigned char *)thash, &tctx);
	tctx = xd->edmx_octx;
	MD5Update(&tctx, (unsigned char *)thash, sizeof thash);
	MD5Final(&(dat[len - 16]), &tctx);

	ipp->protocol		=	50;
	ipp->tot_len		=	htons(len);

	idat = dat + iphlen + esphlen;
	ilen = len - iphlen - esphlen;

#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OINFO)
		printk("encrypting %d bytes\n", ilen);
#endif	
	des_ede3_cbc_encrypt(idat, idat, ilen, (caddr_t)(xd->edmx_eks1), (caddr_t)(xd->edmx_eks2), (caddr_t)(xd->edmx_eks3), (caddr_t)iv, 1);

	/*
	 * XXX -- increment IV if not constant IV
	 */

	skb->ip_hdr = skb->h.iph = (struct iphdr *) skb->data;
	ipp->check = 0;
	ipp->check = ip_fast_csum((unsigned char *)ipp, ipp->ihl);

#ifdef DEBUG_IPSEC_ESP
	if (debug_esp & DB_ES_OH)
	{
		printk("espdes_output: new header (headroom = %d, tailroom = %d\n", skb_headroom(skb), skb_tailroom(skb));
		print_ip_pkt(ipp);
	}
#endif


	return 0;
}

