/*
 *
			   IPSEC for Linux
		         Preliminary Release
 
	 Copyright (C) 1996, 1997, John Ioannidis <ji@hol.gr>
 
		 LIMITED PRELIMINARY RELEASE LICENCE
 	
  Permission to copy, use, and distribute unmodified copies of this
  software without fee is hereby granted, provided that this entire
  notice is included in all copies.

  No modified copies may be distributed.

  [[ This restriction will, of course, change when the code becomes
  more stable. While you may of course still distribute context-diffs
  (or anything equivalent), I strongly urge you to send any changes
  you have directly to me. This will help the community by providing a
  reference base for the code. Thanks, /ji ]]
 
  THIS SOFTWARE IS BEING PROVIDED "AS IS", WITHOUT ANY EXPRESS OR
  IMPLIED WARRANTY. IN PARTICULAR, NEITHER THE AUTHOR NOR ANYONE
  DISTRIBUTING THIS SOFTWARE MAKE ANY REPRESENTATION OR WARRANTY OF
  ANY KIND CONCERNING THE MERCHANTABILITY OF THIS SOFTWARE OR ITS
  FITNESS FOR ANY PARTICULAR PURPOSE.
 
 *
 */

/*
 * $Id: ipsec_netlink.c,v 0.4 1997/01/15 01:28:15 ji Rel $
 *
 * $Log: ipsec_netlink.c,v $
 * Revision 0.4  1997/01/15 01:28:15  ji
 * No changes.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */

#include <linux/config.h>
#include <asm/segment.h>
#include <asm/system.h>
#include <asm/io.h>
#include <linux/types.h>
#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <linux/config.h>

#include <linux/socket.h>
#include <linux/sockios.h>
#include <linux/in.h>
#include <linux/inet.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/icmp.h>
#include <linux/udp.h>
#include <net/ip.h>
#include <net/protocol.h>
#include <net/route.h>
#include <net/tcp.h>
#include <net/udp.h>
#include <net/sock.h>
#include <net/icmp.h>

#include <net/checksum.h>

#include <linux/fs.h>
#include <linux/mm.h>
#include <linux/miscdevice.h>

#include <linux/skbuff.h>
#include <linux/proc_fs.h>
#include <linux/stat.h>

#include <net/netlink.h>
#include <unistd.h>
#include "radij.h"
#include "ipsec_encap.h"
#include "ipsec_radij.h"
#include "ipsec_netlink.h"
#include "ipsec_xform.h"
#ifdef CONFIG_IPSEC_AH
#include "ipsec_ah.h"
#endif

#ifdef DEBUG_IPSEC_NETLINK

int debug_netlink = 0;

#endif

/*
 * IPSEC <> netlink interface.
 */

#define SENDERR(_x) do { len = -(_x); goto errlab; } while (0)

int 
ipsec_callback(struct sk_buff *skb)
{
	/*
	 * this happens when we write to /dev/ipsec (c 36 10)
	 */
	int len = skb->len;
	u_char *dat = (u_char *)skb->data;
	struct encap_msghdr *em;
	struct tdb *tdbp, *tprev;
	int i, nspis, error;
#ifdef DEBUG_IPSEC_NETLINK
	struct eroute *eret;
#endif	
	em = (struct encap_msghdr *)dat;
	if (em->em_magic != EM_MAGIC)
	{
		return -EINVAL;
	}
	
	switch (em->em_type)
	{
   	      case EMT_SETEROUTE:
		ipsec_makeroute(&(em->em_eaddr), &(em->em_emask), em->em_erdst, em->em_erspi);
		break;

#ifdef DEBUG_IPSEC_NETLINK
	      case EMT_TESTROUTE:
		      
		printk("ipsec_callback: testroute: trying to locate 0x%08x->0x%08x\n", (u_int)em->em_eaddr.sen_ip_src.s_addr, (u_int)em->em_eaddr.sen_ip_dst.s_addr);

		eret = ipsec_findroute(&(em->em_eaddr));
		
		if (eret == NULL)
		{
			printk(" not found\n");
		}
		else
		{
			printk(" via 0x%08x, 0x%x\n", (u_int)ntohl(eret->er_dst.s_addr), (u_int)ntohl(eret->er_spi));
		}
		break;
#endif
	      case EMT_SETSPI:
		if (em->em_if >= 5)	/* XXX -- why 5? */
		  SENDERR(ENODEV);
		
		tdbp = gettdb(em->em_spi, em->em_dst);
		if (tdbp == NULL)
		{
#ifdef DEBUG_IPSEC_NETLINK
			if (debug_netlink & DB_NL_TDBCB)
				printk("ipsec_callback: could not find a TDB for 0x%08x, 0x%08x, allocating\n", (u_int)ntohl(em->em_spi), (u_int)ntohl(em->em_dst.s_addr));
#endif
			tdbp = (struct tdb *)kmalloc(sizeof (*tdbp), GFP_ATOMIC);

			if (tdbp == NULL)
			  SENDERR(ENOBUFS);
			
			memset((caddr_t)tdbp, 0, sizeof(*tdbp));
			
			tdbp->tdb_spi = em->em_spi;
			tdbp->tdb_dst = em->em_dst;
/* XXX  		tdbp->tdb_rcvif = &(enc_softc[em->em_if].enc_if);*/
			tdbp->tdb_rcvif = NULL;
			puttdb(tdbp);
		}
		
		error = tdb_init(tdbp, em);
		break;
		
	      case EMT_GRPSPIS:
		nspis = (len - 8) / 12;
		if (nspis * 12 + 8 != len)
		{
			SENDERR(EINVAL);
			break;
		}
		
		for (i = 0; i < nspis; i++)
			if ((tdbp = gettdb(em->em_rel[i].emr_spi, em->em_rel[i].emr_dst)) == NULL)
			{
				printk("ipsec_callback: groupspis: no TDB for 0x%08x, %08x\n", (u_int)ntohl(em->em_rel[i].emr_dst.s_addr), (u_int)ntohl(em->em_rel[i].emr_spi)); /* XXX */

				SENDERR(ENOENT);
			}
		
			else
				em->em_rel[i].emr_tdb = tdbp;
		tprev = em->em_rel[0].emr_tdb;
		tprev->tdb_inext = NULL;
		for (i = 1; i < nspis; i++)
		{
			tdbp = em->em_rel[i].emr_tdb;
			tprev->tdb_onext = tdbp;
			tdbp->tdb_inext = tprev;
			tprev = tdbp;
		}
		tprev->tdb_onext = NULL;
		error = 0;
		break;

	      default:
		printk("ipsec_callback: unknown message type\n");
	}
	
      errlab:
	return len;
}

