
#include <windows.h>

#define	INTERVAL	1000

static int		first = 1;
static double	frq;

extern "C" double cycles(void)
{	unsigned long	hi, lo;

	__asm
	{
		_emit	0x0f
		_emit	0xa2
		_emit	0x0f
		_emit	0x31
		mov		lo,eax
	    mov		hi,edx
	}

	return 4294967296.0 * hi + lo;
};

double freq(void)
{
	return frq;
};

double clock(void)
{	unsigned long	t1, t2;
	double			c1, c2;	

	if(first)	/* if first time through get the machine clock speed	*/
	{
		first = 0; 
		
		t2 = GetTickCount();	/* get millisecond timer count 			*/

		do
		{	t1 = GetTickCount(); c1 = cycles();	/* get cycle count		*/
		}
		while
			(t1 == t2);	/* wait for millisecond timer to change			*/

		do
		{	t2 = GetTickCount(); c2 = cycles();	/* get cycle count		*/
		}
		while
			(t2 < t1 + INTERVAL);	/* wait for INTERVAL milliseconds	*/

		frq = 1000.0 * (c2 - c1) / INTERVAL;
    }
  
	return cycles() / frq;
};
