/*	IDEA Encryption Plugin for Back Orifice 2000    
	Copyright (C) 1999, Maw~

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

	The author of this program may be contacted at maw@wynne.demon.co.uk. 
*/
/*
Notes:
   *Fixed bug in PW_MD5 which only allowed it to work with one block (did not effect security
	since pw are never more than one block).
   *Implement patch from Ken Swingle (Thanks!)
*/
#include <string.h>
#include <stdlib.h>

#define ROTL(x,s)	( (x<<s) | (x>>(32-s)) )

void MD5_FF(unsigned int *a, unsigned int b, unsigned int c, unsigned int d,
			unsigned int Mj, unsigned int s, unsigned int Ti)
{
	*a = ROTL( (((b & c) | ((~b) & d)) + *a + Mj + Ti),s) + b;
}

void MD5_GG(unsigned int *a, unsigned int b, unsigned int c, unsigned int d,
			unsigned int Mj, unsigned int s, unsigned int Ti)
{
	*a = ROTL( (((b & d) | (c & ~d)) + *a + Mj + Ti),s) + b;
}

void MD5_HH(unsigned int *a, unsigned int b, unsigned int c, unsigned int d,
			unsigned int Mj, unsigned int s, unsigned int Ti)
{
	*a = ROTL( ((b ^ c ^ d) + *a + Mj + Ti),s) + b;
}

void MD5_II(unsigned int *a, unsigned int b, unsigned int c, unsigned int d,
			unsigned int Mj, unsigned int s, unsigned int Ti)
{
	*a = ROTL( ((c ^ (b | ~d)) + *a + Mj + Ti),s) + b;
}

void MD5_OneBlock(unsigned int *M, unsigned int *A, unsigned int *B, unsigned int *C, unsigned int *D)
{
	MD5_FF(A,*B,*C,*D, M[0], 7, 0xD76AA478);
	MD5_FF(D,*A,*B,*C, M[1],12, 0xe8c7b756);
	MD5_FF(C,*D,*A,*B, M[2],17, 0x242070db);
	MD5_FF(B,*C,*D,*A, M[3],22, 0xc1bdceee);
	MD5_FF(A,*B,*C,*D, M[4], 7, 0xf57c0faf);
	MD5_FF(D,*A,*B,*C, M[5],12, 0x4787c62a);
	MD5_FF(C,*D,*A,*B, M[6],17, 0xa8304613);
	MD5_FF(B,*C,*D,*A, M[7],22, 0xfd469501);
	MD5_FF(A,*B,*C,*D, M[8], 7, 0x698098d8);
	MD5_FF(D,*A,*B,*C, M[9],12, 0x8b44f7af);
	MD5_FF(C,*D,*A,*B, M[10],17, 0xffff5bb1);
	MD5_FF(B,*C,*D,*A, M[11],22, 0x895cd7be);
	MD5_FF(A,*B,*C,*D, M[12], 7, 0x7b901122);
	MD5_FF(D,*A,*B,*C, M[13],12, 0xfd987193);
	MD5_FF(C,*D,*A,*B, M[14],17, 0xa679438e);
	MD5_FF(B,*C,*D,*A, M[15],22, 0x49b40821);

	MD5_GG(A,*B,*C,*D, M[0], 5, 0xf61e2562);
	MD5_GG(D,*A,*B,*C, M[1], 9, 0xc040b340);
	MD5_GG(C,*D,*A,*B, M[2],14, 0x265e5a51);
	MD5_GG(B,*C,*D,*A, M[3],20, 0xe9b6c7aa);
	MD5_GG(A,*B,*C,*D, M[4], 5, 0xd62f105d);
	MD5_GG(D,*A,*B,*C, M[5], 9, 0x02441453);
	MD5_GG(C,*D,*A,*B, M[6],14, 0xd8a1e681);
	MD5_GG(B,*C,*D,*A, M[7],20, 0xe7d3fbc8);
	MD5_GG(A,*B,*C,*D, M[8], 5, 0x21e1cde6);
	MD5_GG(D,*A,*B,*C, M[9], 9, 0xc33707d6);
	MD5_GG(C,*D,*A,*B, M[10],14, 0xf4d50d87);
	MD5_GG(B,*C,*D,*A, M[11],20, 0x455a14ed);
	MD5_GG(A,*B,*C,*D, M[12], 5, 0xa9e3e905);
	MD5_GG(D,*A,*B,*C, M[13], 9, 0xfcefa3f8);
	MD5_GG(C,*D,*A,*B, M[14],14, 0x676f02d9);
	MD5_GG(B,*C,*D,*A, M[15],20, 0x8d2a4c8a);

	MD5_HH(A,*B,*C,*D, M[0], 4, 0xfffa3942);
	MD5_HH(D,*A,*B,*C, M[1],11, 0x8771f681);
	MD5_HH(C,*D,*A,*B, M[2],16, 0x6d9d6122);
	MD5_HH(B,*C,*D,*A, M[3],23, 0xfde5380c);
	MD5_HH(A,*B,*C,*D, M[4], 4, 0xa4beea44);
	MD5_HH(D,*A,*B,*C, M[5],11, 0x4bdecfa9);
	MD5_HH(C,*D,*A,*B, M[6],16, 0xf6bb4b60);
	MD5_HH(B,*C,*D,*A, M[7],23, 0xbebfbc70);
	MD5_HH(A,*B,*C,*D, M[8], 4, 0x289b7ec6);
	MD5_HH(D,*A,*B,*C, M[9],11, 0xeaa127fa);
	MD5_HH(C,*D,*A,*B, M[10],16, 0xd4ef3085);
	MD5_HH(B,*C,*D,*A, M[11],23, 0x04881d05);
	MD5_HH(A,*B,*C,*D, M[12], 4, 0xd9d4d039);
	MD5_HH(D,*A,*B,*C, M[13],11, 0xe6db99e5);
	MD5_HH(C,*D,*A,*B, M[14],16, 0x1fa27cf8);
	MD5_HH(B,*C,*D,*A, M[15],23, 0xc4ac5665);

	MD5_II(A,*B,*C,*D, M[0], 6, 0xf4292244);
	MD5_II(D,*A,*B,*C, M[1],10, 0x432aff97);
	MD5_II(C,*D,*A,*B, M[2],15, 0xab9423a7);
	MD5_II(B,*C,*D,*A, M[3],21, 0xfc93a039);
	MD5_II(A,*B,*C,*D, M[4], 6, 0x655b59c3);
	MD5_II(D,*A,*B,*C, M[5],10, 0x8f0ccc92);
	MD5_II(C,*D,*A,*B, M[6],15, 0xffeff47d);
	MD5_II(B,*C,*D,*A, M[7],21, 0x85845dd1);
	MD5_II(A,*B,*C,*D, M[8], 6, 0x6fa87e4f);
	MD5_II(D,*A,*B,*C, M[9],10, 0xfe2ce6e0);
	MD5_II(C,*D,*A,*B, M[10],15, 0xa3014314);
	MD5_II(B,*C,*D,*A, M[11],21, 0x4e0811a1);
	MD5_II(A,*B,*C,*D, M[12], 6, 0xf75e7e82);
	MD5_II(D,*A,*B,*C, M[13],10, 0xbd3af235);
	MD5_II(C,*D,*A,*B, M[14],15, 0x2ad7d2bb);
	MD5_II(B,*C,*D,*A, M[15],21, 0xeb86d391);
}

// This has been patched up by me and Ken Swingle(thanks!)
void PW_MD5(char *pw, int pwlen, char *key)
{
     int len, pad;
     unsigned char *M;

//   len = pwlen % 56;        // this didn't work if the pwlen was > 64
//   pad = 56 - len;
     pad = (((pwlen/64)+1)*64)-pwlen-8;  // there's probably a nicer way to do this
     len = pwlen+pad+8;

     M = (unsigned char*)malloc(len);

     memset(M,0,len);
     memcpy(M,pw,pwlen);
     M[pwlen]=128;
     memcpy(M+len-8,&pwlen,4);

     unsigned int A,B,C,D;
     unsigned int a,b,c,d;

     a = A = 0x01234567;
     b = B = 0x89abcdef;
     c = C = 0xfedcba98;
     d = D = 0x76543210;

     // int blocks = len / 16;     // wrong value
     int blocks = len / 64;        // note that we're processing 16 32 bit blocks
                                   // each block is 64 bytes

     for (int i=0;i<blocks;i++)
     {
          MD5_OneBlock((unsigned int *)M, &a, &b, &c, &d);
          A += a;
          B += b;
          C += c;
          D += d;
          a=A;
          b=B;
          c=C;
          d=D;
          M=&M[16];
     }

     memcpy(key, &A, 4);
     memcpy(key+4, &B, 4);
     memcpy(key+8, &C, 4);
     memcpy(key+12, &D, 4);
}

