/*
 * Decompiled with CFR 0.152.
 */
package cryptix.test;

import cryptix.test.BaseTest;
import cryptix.util.math.BigRegister;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

class TestBR
extends BaseTest {
    public static void main(String[] stringArray) {
        new TestBR().commandline(stringArray);
    }

    protected void engineTest() throws Exception {
        this.setExpectedPasses(8);
        BigRegister bigRegister = new BigRegister(64);
        this.out.println(bigRegister);
        bigRegister.setBit(0);
        bigRegister.setBit(5);
        bigRegister.setBit(6);
        this.out.println("Setting bits 0, 5 and 6...\n" + bigRegister);
        bigRegister.shiftLeft(10);
        this.out.println("Shift left 10 positions...\n" + bigRegister);
        bigRegister.shiftLeft(10);
        this.out.println("Shift left 10 positions...\n" + bigRegister);
        bigRegister.shiftRight(11);
        this.out.println("Shift right 11 positions...\n" + bigRegister);
        bigRegister.shiftRight(9);
        this.out.println("Shift right 9 positions...\n" + bigRegister);
        bigRegister.shiftLeft(-2);
        this.out.println("Shift right 2 positions (using 'shiftLeft')...\n" + bigRegister);
        bigRegister.shiftRight(-4);
        this.out.println("Shift left 4 positions (using 'shiftRight')...\n" + bigRegister);
        bigRegister.shiftRight(2);
        this.out.println("Shift right 2 positions...\n" + bigRegister);
        bigRegister.rotateLeft(10);
        this.out.println("Rotating left 10 positions...\n" + bigRegister);
        bigRegister.rotateRight(13);
        this.out.println("Rotating right 13 positions...\n" + bigRegister);
        bigRegister.rotateRight(-10);
        this.out.println("Rotating left 10 positions (using 'rotateRight')...\n" + bigRegister);
        bigRegister.rotateLeft(-13);
        this.out.println("Rotating right 13 positions (using 'rotateLeft')...\n" + bigRegister);
        bigRegister.rotateLeft(50);
        this.out.println("Rotating left 50 positions = right 14...\n" + bigRegister);
        bigRegister.rotateRight(60);
        this.out.println("Rotating right 60 positions = left 4...\n" + bigRegister);
        bigRegister.shiftRight(65);
        this.out.println("Shifting right 65 positions...\n" + bigRegister);
        BigRegister bigRegister2 = new BigRegister(64);
        BigRegister bigRegister3 = new BigRegister(64);
        bigRegister3.atRandom();
        BigRegister bigRegister4 = (BigRegister)bigRegister3.clone();
        this.out.println("Register A (random value): " + bigRegister3);
        this.out.println("Register AA (copy of A): " + bigRegister3);
        this.out.println("Both A and AA have " + bigRegister3.countSetBits() + " set bits between indices: #" + bigRegister3.lowestSetBit() + " and #" + bigRegister3.highestSetBit() + " (inclusive)...");
        this.out.println();
        this.out.println("Register B: " + bigRegister2);
        bigRegister3.and(bigRegister2);
        this.out.println("Register AA: " + bigRegister4);
        this.out.println("A = A & B: " + bigRegister3);
        this.passIf(bigRegister3.countSetBits() == 0, "Register A now has 0 set bits?");
        bigRegister3.load(bigRegister4);
        bigRegister3.or(bigRegister2);
        this.out.println("Register A: " + bigRegister3);
        this.passIf(bigRegister3.isSameValue(bigRegister4), "A == AA using isSameValue?");
        this.out.print("How does A compare to AA?");
        int n = bigRegister3.compareTo(bigRegister4);
        this.out.println(" " + (n == 0 ? "A == AA" : (n == -1 ? "A < AA" : " A > AA")));
        this.passIf(n == 0, "A == AA using compareTo?");
        this.out.println();
        bigRegister2.not();
        this.out.println("Register B: " + bigRegister2);
        this.passIf(bigRegister2.countSetBits() == bigRegister2.getSize(), "Register B is now all 1s?");
        bigRegister3.atRandom();
        bigRegister2.atRandom();
        bigRegister4 = (BigRegister)bigRegister3.clone();
        this.out.println("Register A (random value): " + bigRegister3);
        this.out.println("Register B (random value): " + bigRegister2);
        bigRegister3.xor(bigRegister2);
        this.out.println("A = A ^ B: " + bigRegister3);
        this.out.println("Register AA (old value of A): " + bigRegister4);
        this.passIf(!bigRegister3.isSameValue(bigRegister4), "A != AA?");
        bigRegister3.xor(bigRegister2);
        this.out.println("(A ^ B) ^ B: " + bigRegister3);
        this.passIf(bigRegister3.isSameValue(bigRegister4), "AA = (A ^ B) ^ B?");
        try {
            bigRegister3.atRandom();
            this.out.println("About to serialize A and B to './t.tmp'...");
            this.out.println("Register A (random value): " + bigRegister3);
            this.out.println("Register B: " + bigRegister2);
            FileOutputStream fileOutputStream = new FileOutputStream("t.tmp");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(bigRegister3);
            objectOutputStream.writeObject(bigRegister2);
            objectOutputStream.flush();
            fileOutputStream.close();
            this.out.println("About to deserialize A and B from './t.tmp'...");
            FileInputStream fileInputStream = new FileInputStream("t.tmp");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            bigRegister4 = (BigRegister)objectInputStream.readObject();
            BigRegister bigRegister5 = (BigRegister)objectInputStream.readObject();
            fileInputStream.close();
            this.out.println("Register AA: " + bigRegister4);
            this.out.println("Register BB: " + bigRegister5);
            this.passIf(bigRegister3.isSameValue(bigRegister4), "A == AA?");
            this.passIf(bigRegister2.isSameValue(bigRegister5), "B == BB?");
        }
        catch (Exception exception) {
            this.fail("Exception during serialization test");
            exception.printStackTrace();
        }
        bigRegister = new BigRegister(53);
        this.out.println(bigRegister);
        bigRegister.setBit(0);
        bigRegister.setBit(5);
        bigRegister.setBit(6);
        this.out.println("Setting bits 0, 5 and 6...\n" + bigRegister);
        bigRegister.shiftLeft(10);
        this.out.println("Shift left 10 positions...\n" + bigRegister);
        bigRegister.rotateRight(13);
        this.out.println("Rotating right 13 positions...\n" + bigRegister);
        bigRegister.setBits(45, 5, 255L);
        this.out.println("Setting 5 bits starting @45 to 1s...\n" + bigRegister);
        this.out.println("2 bits starting @44 have a value of: " + bigRegister.getBits(44, 2));
        this.out.println("4 bits starting @46 have a value of: " + bigRegister.getBits(46, 4));
    }

    TestBR() {
    }
}

