/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESedeCipher;
import com.sun.crypto.provider.DESedeKey;
import com.sun.crypto.provider.PBEWithMD5AndDESCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public final class PBEWithMD5AndTripleDESCipher
extends PBEWithMD5AndDESCipher {
    public PBEWithMD5AndTripleDESCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.desCipher = new DESedeCipher();
        this.desCipher.engineSetMode("CBC");
        this.desCipher.engineSetPadding("PKCS5Padding");
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (n == 2 && algorithmParameterSpec == null) {
            throw new InvalidAlgorithmParameterException("Parameters missing");
        }
        try {
            if (key == null || !key.getAlgorithm().equalsIgnoreCase("PBEWithMD5AndDES")) {
                throw new InvalidKeyException("Missing password");
            }
            byte[] byArray = key.getEncoded();
            if (algorithmParameterSpec == null) {
                this.salt = new byte[8];
                secureRandom.nextBytes(this.salt);
            } else {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Wrong parameter type");
                }
                this.salt = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
                if (this.salt.length != 8) {
                    throw new InvalidAlgorithmParameterException("Salt must be 8 bytes long");
                }
                this.iCount = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
            }
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n2 = 0;
            while (n2 < 4) {
                if (this.salt[n2] != this.salt[n2 + 4]) break;
                ++n2;
            }
            if (n2 == 4) {
                n2 = 0;
                while (n2 < 2) {
                    byte by = this.salt[n2];
                    this.salt[n2] = this.salt[3 - n2];
                    this.salt[2] = by;
                    ++n2;
                }
            }
            byte[] byArray2 = null;
            IvParameterSpec ivParameterSpec = null;
            byte[] byArray3 = null;
            n2 = 0;
            while (n2 < 2) {
                byArray3 = new byte[this.salt.length / 2];
                System.arraycopy(this.salt, n2 * (this.salt.length / 2), byArray3, 0, byArray3.length);
                int n3 = 0;
                while (n3 < this.iCount) {
                    messageDigest.update(byArray3);
                    messageDigest.update(byArray);
                    byArray3 = messageDigest.digest();
                    ++n3;
                }
                if (n2 == 0) {
                    byArray2 = new byte[24];
                    System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
                } else {
                    System.arraycopy(byArray3, 0, byArray2, byArray3.length, byArray3.length / 2);
                    ivParameterSpec = new IvParameterSpec(byArray3, byArray3.length / 2, byArray3.length / 2);
                }
                ++n2;
            }
            Arrays.fill(byArray, (byte)0);
            DESedeKey dESedeKey = new DESedeKey(byArray2);
            this.desCipher.engineInit(n, (Key)dESedeKey, ivParameterSpec, secureRandom);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.toString());
        }
    }
}

