/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class BlowfishKeyGenerator
extends KeyGeneratorSpi {
    private SecureRandom random = null;
    private int keysize = 56;

    protected SecretKey engineGenerateKey() {
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        byte[] byArray = new byte[this.keysize];
        this.random.nextBytes(byArray);
        return new SecretKeySpec(byArray, "Blowfish");
    }

    protected void engineInit(int n, SecureRandom secureRandom) {
        if (n % 8 != 0 || n < 32 || n > 448) {
            throw new InvalidParameterException("Keysize must be multiple of 8, and can only range from 32 to 448 (inclusive)");
        }
        this.keysize = n / 8;
        this.engineInit(secureRandom);
    }

    protected void engineInit(SecureRandom secureRandom) {
        this.random = secureRandom;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("Blowfish key generation does not take any parameters");
    }
}

