/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.BigInt;
import com.sun.crypto.provider.DerInputBuffer;
import com.sun.crypto.provider.DerValue;
import com.sun.crypto.provider.ObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

class DerInputStream {
    DerInputBuffer buffer;

    DerInputStream(DerInputBuffer derInputBuffer) {
        this.buffer = derInputBuffer;
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream(byte[] byArray) {
        this.buffer = new DerInputBuffer(byArray);
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public DerInputStream(byte[] byArray, int n, int n2) {
        this.buffer = new DerInputBuffer(byArray, n, n2);
        this.buffer.mark(Integer.MAX_VALUE);
    }

    public int available() {
        return this.buffer.available();
    }

    public byte[] getBitString() throws IOException {
        byte[] byArray;
        if (this.buffer.read() != 3) {
            throw new IOException("DER input not an bit string");
        }
        int n = DerInputStream.getLength(this.buffer);
        if (this.buffer.read() != 0) {
            return null;
        }
        if (this.buffer.read(byArray = new byte[--n]) != n) {
            throw new IOException("short read of DER bit string");
        }
        return byArray;
    }

    int getByte() throws IOException {
        return 0xFF & this.buffer.read();
    }

    public void getBytes(byte[] byArray) throws IOException {
        if (this.buffer.read(byArray) != byArray.length) {
            throw new IOException("short read of DER octet string");
        }
    }

    public DerValue getDerValue() throws IOException {
        return new DerValue(this.buffer);
    }

    public BigInt getInteger() throws IOException {
        if (this.buffer.read() != 2) {
            throw new IOException("DER input, Integer tag error");
        }
        return this.buffer.getUnsigned(DerInputStream.getLength(this.buffer));
    }

    int getLength() throws IOException {
        return DerInputStream.getLength(this.buffer);
    }

    static int getLength(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 & 0x80) == 0) {
            n = n2;
        } else {
            if ((n2 &= 0x7F) <= 0 || n2 > 4) {
                throw new IOException("DerInput.getLength(): lengthTag=" + n2 + ", " + (n2 == 0 ? "Indefinite length encoding not supported or incorrect DER encoding." : "too big."));
            }
            n = 0;
            while (n2 > 0) {
                n <<= 8;
                n += 0xFF & inputStream.read();
                --n2;
            }
        }
        return n;
    }

    public void getNull() throws IOException {
        if (this.buffer.read() != 5 || this.buffer.read() != 0) {
            throw new IOException("getNull, bad data");
        }
    }

    public ObjectIdentifier getOID() throws IOException {
        return new ObjectIdentifier(this);
    }

    public byte[] getOctetString() throws IOException {
        if (this.buffer.read() != 4) {
            throw new IOException("DER input not an octet string");
        }
        int n = DerInputStream.getLength(this.buffer);
        byte[] byArray = new byte[n];
        if (this.buffer.read(byArray) != n) {
            throw new IOException("short read of DER octet string");
        }
        return byArray;
    }

    public DerValue[] getSequence(int n) throws IOException {
        if (this.buffer.read() != 48) {
            throw new IOException("Sequence tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n) throws IOException {
        if (this.buffer.read() != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    public DerValue[] getSet(int n, boolean bl) throws IOException {
        int n2 = this.buffer.read();
        if (!bl && n2 != 49) {
            throw new IOException("Set tag error");
        }
        return this.readVector(n);
    }

    public void mark(int n) {
        this.buffer.mark(n);
    }

    public int peekByte() throws IOException {
        return this.buffer.peek();
    }

    protected DerValue[] readVector(int n) throws IOException {
        int n2 = DerInputStream.getLength(this.buffer);
        if (n2 == 0) {
            return new DerValue[0];
        }
        DerInputStream derInputStream = this.buffer.available() == n2 ? this : this.subStream(n2, true);
        Vector<DerValue> vector = new Vector<DerValue>(n, 5);
        do {
            DerValue derValue = new DerValue(derInputStream.buffer);
            vector.addElement(derValue);
        } while (derInputStream.available() > 0);
        if (derInputStream.available() != 0) {
            throw new IOException("extra data at end of vector");
        }
        int n3 = vector.size();
        DerValue[] derValueArray = new DerValue[n3];
        int n4 = 0;
        while (n4 < n3) {
            derValueArray[n4] = (DerValue)vector.elementAt(n4);
            ++n4;
        }
        return derValueArray;
    }

    public void reset() {
        this.buffer.reset();
    }

    public DerInputStream subStream(int n, boolean bl) throws IOException {
        DerInputBuffer derInputBuffer = this.buffer.dup();
        derInputBuffer.truncate(n);
        if (bl) {
            this.buffer.skip(n);
        }
        return new DerInputStream(derInputBuffer);
    }
}

