/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESConstants;
import com.sun.crypto.provider.DESCrypt;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;

class DESedeCrypt
extends DESCrypt
implements DESConstants {
    private byte[] key1;
    private byte[] key2;
    private byte[] key3;
    private byte[] buf1 = new byte[8];
    private byte[] buf2 = new byte[8];

    DESedeCrypt() {
    }

    void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, IllegalBlockSizeException {
        if (this.key1 == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (n2 != 8) {
            throw new IllegalBlockSizeException("SunJCE DESede: " + n2);
        }
        this.expandedKey = this.key3;
        this.decrypting = true;
        this.cipherBlock(byArray, n, this.buf1, 0);
        this.expandedKey = this.key2;
        this.decrypting = false;
        this.cipherBlock(this.buf1, 0, this.buf2, 0);
        this.expandedKey = this.key1;
        this.decrypting = true;
        this.cipherBlock(this.buf2, 0, byArray2, n3);
    }

    void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalStateException, IllegalBlockSizeException {
        if (this.key1 == null) {
            throw new IllegalStateException("Cipher not initialized");
        }
        if (n2 != 8) {
            throw new IllegalBlockSizeException("SunJCE DESede : " + n2);
        }
        this.expandedKey = this.key1;
        this.decrypting = false;
        this.cipherBlock(byArray, n, this.buf1, 0);
        this.expandedKey = this.key2;
        this.decrypting = true;
        this.cipherBlock(this.buf1, 0, this.buf2, 0);
        this.expandedKey = this.key3;
        this.decrypting = false;
        this.cipherBlock(this.buf2, 0, byArray2, n3);
    }

    void init(Key key) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Key missing");
        }
        if (!key.getAlgorithm().equalsIgnoreCase("DESede") && !key.getAlgorithm().equalsIgnoreCase("TripleDES")) {
            throw new InvalidKeyException("Wrong algorithm: DESede or TripleDES required");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException("RAW bytes missing");
        }
        if (byArray.length != 24) {
            throw new InvalidKeyException("Wrong key size");
        }
        byte[] byArray2 = new byte[8];
        this.key1 = new byte[128];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        this.expandKey(byArray2);
        System.arraycopy(this.expandedKey, 0, this.key1, 0, 128);
        if (this.keyEquals(byArray2, 0, byArray, 16, 8)) {
            this.key3 = this.key1;
        } else {
            this.key3 = new byte[128];
            System.arraycopy(byArray, 16, byArray2, 0, 8);
            this.expandKey(byArray2);
            System.arraycopy(this.expandedKey, 0, this.key3, 0, 128);
        }
        this.key2 = new byte[128];
        System.arraycopy(byArray, 8, byArray2, 0, 8);
        this.expandKey(byArray2);
        System.arraycopy(this.expandedKey, 0, this.key2, 0, 128);
    }

    void init(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException {
        this.init(key);
    }

    private boolean keyEquals(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            if (byArray[n4 + n] != byArray2[n4 + n2]) {
                return false;
            }
            ++n4;
        }
        return true;
    }
}

