/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

class PBEKey
implements SecretKey {
    private byte[] key;

    public PBEKey(PBEKeySpec pBEKeySpec) {
        char[] cArray = pBEKeySpec.getPassword();
        this.key = new byte[cArray.length];
        int n = 0;
        while (n < cArray.length) {
            this.key[n] = (byte)cArray[n];
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase("PBE")) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl = Arrays.equals(this.key, byArray);
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    protected void finalize() {
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        }
    }

    public String getAlgorithm() {
        return "PBE";
    }

    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n = 0;
        int n2 = 1;
        while (n2 < this.key.length) {
            n += this.key[n2] * n2;
            ++n2;
        }
        return n ^= this.getAlgorithm().toLowerCase().hashCode();
    }
}

