/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private byte[] iv;
    private int version;
    private int rounds;
    private int wordSize;

    public RC5ParameterSpec(int n, int n2, int n3) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray) {
        this(n, n2, n3, byArray, 0);
    }

    public RC5ParameterSpec(int n, int n2, int n3, byte[] byArray, int n4) {
        this.version = n;
        this.rounds = n2;
        this.wordSize = n3;
        if (byArray == null) {
            throw new IllegalArgumentException("IV missing");
        }
        int n5 = n3 / 8 * 2;
        if (byArray.length - n4 < n5) {
            throw new IllegalArgumentException("IV too short");
        }
        this.iv = new byte[n5];
        System.arraycopy(byArray, n4, this.iv, 0, n5);
    }

    public byte[] getIV() {
        if (this.iv != null) {
            return (byte[])this.iv.clone();
        }
        return null;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getVersion() {
        return this.version;
    }

    public int getWordSize() {
        return this.wordSize;
    }
}

