/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.DESCipher;
import com.sun.crypto.provider.DESKey;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PBEWithMD5AndDESCipher
extends CipherSpi {
    protected DESCipher desCipher = new DESCipher("CBC", "PKCS5Padding");
    private byte[] salt;
    private int iterationCount;
    static /* synthetic */ Class class$javax$crypto$spec$PBEParameterSpec;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.desCipher.engineDoFinal(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.desCipher.engineDoFinal(byArray, n, n2, byArray2, n3);
    }

    protected int engineGetBlockSize() {
        return this.desCipher.engineGetBlockSize();
    }

    protected byte[] engineGetIV() {
        return this.desCipher.engineGetIV();
    }

    protected int engineGetOutputSize(int n) {
        return this.desCipher.engineGetOutputSize(n);
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        try {
            algorithmParameters = AlgorithmParameters.getInstance("PBE", "SunJCE");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new RuntimeException("SunJCE called, but not configured");
        }
        try {
            algorithmParameters.init(pBEParameterSpec);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException("PBEParameterSpec not supported");
        }
        return algorithmParameters;
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pBEParameterSpec = null;
        if (algorithmParameters != null) {
            try {
                pBEParameterSpec = (PBEParameterSpec)algorithmParameters.getParameterSpec(class$javax$crypto$spec$PBEParameterSpec != null ? class$javax$crypto$spec$PBEParameterSpec : (class$javax$crypto$spec$PBEParameterSpec = PBEWithMD5AndDESCipher.class$("javax.crypto.spec.PBEParameterSpec")));
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: PBE expected");
            }
        }
        this.engineInit(n, key, pBEParameterSpec, secureRandom);
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        throw new InvalidKeyException("Cannot derive key: PBE parameter missing");
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        try {
            if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Inappropriate parameter type");
            }
            if (key == null || !key.getAlgorithm().equalsIgnoreCase("PBE")) {
                throw new InvalidKeyException("Missing password");
            }
            byte[] byArray = key.getEncoded();
            this.salt = ((PBEParameterSpec)algorithmParameterSpec).getSalt();
            if (this.salt.length != 8) {
                throw new InvalidAlgorithmParameterException("Salt does not have length 8");
            }
            byte[] byArray2 = new byte[byArray.length + this.salt.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            Arrays.fill(byArray, (byte)0);
            System.arraycopy(this.salt, 0, byArray2, byArray.length, this.salt.length);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = byArray2;
            this.iterationCount = ((PBEParameterSpec)algorithmParameterSpec).getIterationCount();
            int n2 = 0;
            while (n2 < this.iterationCount) {
                messageDigest.update(byArray3);
                byArray3 = messageDigest.digest();
                ++n2;
            }
            Arrays.fill(byArray2, (byte)0);
            DESKey dESKey = new DESKey(byArray3);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray3, 8, 8);
            this.desCipher.engineInit(n, (Key)dESKey, ivParameterSpec, secureRandom);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.toString());
        }
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (string != null && !string.equalsIgnoreCase("CBC")) {
            throw new NoSuchAlgorithmException("Invalid cipher mode: " + string);
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        if (string != null && !string.equalsIgnoreCase("PKCS5Padding")) {
            throw new NoSuchPaddingException("Invalid padding scheme: " + string);
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        return this.desCipher.engineUpdate(byArray, n, n2);
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        return this.desCipher.engineUpdate(byArray, n, n2, byArray2, n3);
    }
}

