/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.security.InvalidKeyException;
import javax.crypto.SecretKey;

public class DESKey
implements SecretKey {
    private byte[] key;
    protected static final int DES_KEY_SIZE = 8;

    public DESKey(byte[] byArray) throws InvalidKeyException {
        this(byArray, 0);
    }

    public DESKey(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray == null || byArray.length - n < 8) {
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[8];
        System.arraycopy(byArray, n, this.key, 0, 8);
    }

    public String getAlgorithm() {
        return "DES";
    }

    public byte[] getEncoded() {
        byte[] byArray = new byte[this.key.length];
        System.arraycopy(this.key, 0, byArray, 0, this.key.length);
        return byArray;
    }

    public String getFormat() {
        return "RAW";
    }
}

