/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import javax.crypto.SecretKey;

public class SecretKeySpec
implements SecretKey {
    private byte[] key;
    private String algorithm;

    public SecretKeySpec(byte[] byArray, int n, int n2, String string) {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("Missing argument");
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException("Invalid offset/length combination");
        }
        this.key = new byte[n2];
        System.arraycopy(byArray, n, this.key, 0, n2);
        this.algorithm = string;
    }

    public SecretKeySpec(byte[] byArray, String string) {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("Missing argument");
        }
        this.key = (byte[])byArray.clone();
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public String getFormat() {
        return "RAW";
    }
}

