/**
   EAYEncryptedPrivateKey.java

   Copyright (C) 1999, Claymore Systems, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu Jun  3 21:03:14 1999

   This package is a SSLv3/TLS implementation written by Eric Rescorla
   <ekr@rtfm.com> and licensed by Claymore Systems, Inc.

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:
   1. Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
   2. Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
   3. All advertising materials mentioning features or use of this software
      must display the following acknowledgement:
      This product includes software developed by Claymore Systems, Inc.
   4. Neither the name of Claymore Systems, Inc. nor the name of Eric
      Rescorla may be used to endorse or promote products derived from this
      software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
   ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
   FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
   DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
   OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
   HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
   LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
   OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
   SUCH DAMAGE.

   $Id: EAYEncryptedPrivateKey.java,v 1.5 1999/06/22 06:24:51 ekr Exp $

*/


package COM.claymoresystems.crypto;
import COM.claymoresystems.util.Util;
import COM.claymoresystems.util.RFC822Hdr;
import COM.claymoresystems.cert.WrappedObject;
import COM.claymoresystems.cert.EAYDSAPrivateKey;
import COM.claymoresystems.cert.EAYRSAPrivateKey;

import java.io.*;
import java.security.Cipher;
import java.security.PrivateKey;
import java.security.FeedbackCipher;
import java.security.MessageDigest;

import cryptix.provider.key.RawSecretKey;
import cryptix.util.core.Hex;


public class EAYEncryptedPrivateKey {
     private static final String DSA_STRING="DSA";
     private static final String RSA_STRING="RSA";     
     
     public static PrivateKey createPrivateKey(BufferedReader in,String type,
       byte[] password)
       throws IOException,IllegalArgumentException {
       RFC822Hdr proc_type=new RFC822Hdr(in);
       RFC822Hdr dek_info=null;
       byte[] plainKey;

       if(proc_type.getName()!=null){
	 if(!proc_type.getSubfield(0).equals("4"))
	   throw new IOException("Unknown proc type" + proc_type.getSubfield(0));
	 
	 dek_info=new RFC822Hdr(in);

	 try {
	   byte[] encryptedKey=WrappedObject.readBlock(in);
	   
	   // TODO: Create a map table from EAY ciphers to java ciphers
	   String algorithm="3DES/CBC/PKCS5Padding";
	   byte[] key_bytes=new byte[24];
	   
	   byte[] iv=Hex.fromString(dek_info.getSubfield(1));
	   
	   EVP_BytesToKey("MD5",iv, // Salt is IV
	     password,(short)1,key_bytes,null);
	   
	   RawSecretKey key=new RawSecretKey(algorithm,key_bytes);

//	   Util.xdump("Decryption key",key_bytes);
	   
	   Cipher ciph=Cipher.getInstance(algorithm);
	   ((FeedbackCipher)ciph).setInitializationVector(iv);
	   ciph.initDecrypt(key);

//	   Util.xdump("Encrypted key",encryptedKey);
	   
	   plainKey=ciph.crypt(encryptedKey);
	 } catch (java.security.KeyException e){
	   throw new InternalError(e.toString());
	 }
	 catch (java.security.NoSuchAlgorithmException e){
	   throw new InternalError(e.toString());
	 }
       }
       else{
	 plainKey=WrappedObject.readBlock(in);
       }

       // TODO: table to look up key types
       if(type.equals(DSA_STRING))
	 return new EAYDSAPrivateKey(plainKey);
       else if(type.equals(RSA_STRING))
	 return new EAYRSAPrivateKey(plainKey);
       else
	 throw new InternalError("Couldn't find key type" + type);
     }
     
     /**
	  This is a straight translation of SSLeay's EVP_BytesToKey()
	  from evp_key.c. It converts a password into a key

	  @param digest the digest to use
	  @param salt salt octets
	  @param data the input password/key
	  @param count the iteration count
	  @param key the key (OUT)
	  @param iv the iv (OUT)
     */
     static void EVP_BytesToKey(String digest,
       byte[] salt, byte[] data, short count, byte[] key, byte[] iv){
       byte[] md_buf=null;
       int key_offset=0;
       int key_left=key.length;
       int iv_offset=0;
       int iv_left=0;

       if(iv!=null) iv_left=iv.length;
	   
       try {
	 MessageDigest md;

	 md=MessageDigest.getInstance(digest);

	 for(;;){
	   if(md_buf!=null)
	     md.update(md_buf);
	   md.update(data);
	   if(salt!=null)
	     md.update(salt);
	   md_buf=md.digest();

	   // Repeat this count times
	   for(short i=1;i<count;i++){
	     md.update(md_buf);
	     md_buf=md.digest();
	   }

	   // First copy the key if we need more key
	   int left=md_buf.length;
	   int offset=0;
	     
	   if(key_left!=0){
	     int tocpy=Util.min(key_left,left);
	     System.arraycopy(md_buf,0,key,key_offset,tocpy);
	     left-=tocpy;
	     offset=tocpy;
	     key_left-=tocpy;
	     key_offset+=tocpy;
	   }

	   // Now copy the IV if we need more IV
	   if(left>=0 && iv_left>0){
	     int tocpy=Util.min(iv_left,left);
	     System.arraycopy(md_buf,offset,iv,iv_offset,tocpy);
	     iv_left-=tocpy;
	     iv_offset+=tocpy;
	   }

	   // If we've generated all the keying material we need, break
	   if(key_left==0 && iv_left==0)
	     break;
	 }
       }
       catch (java.lang.Exception e){
	 throw new InternalError(e.toString());
       }
     }

     // Test
     public static void main(String [] args)
       throws java.io.IOException,FileNotFoundException {
       FileInputStream fis=new FileInputStream(args[0]);
       BufferedReader br=new BufferedReader(new InputStreamReader(fis));
       String line;

       line=br.readLine();
       String password="70617373776f7264";
       
       PrivateKey pk=createPrivateKey(br,"BEGIN DSA PRIVATE KEY",Hex.fromString(password));
     }
}
	 

       
       
	 
	 
       


       


       
