/**
   SSLServerSocket.c

   Copyright (C) 1999, RTFM, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Wed Jun  9 14:55:18 1999
 */


static char *RCSSTRING="$Id: SSLServerSocket.c,v 1.1.1.1 1999/06/17 18:49:02 ekr Exp $";

#include "COM_claymore_sslg_openssl_SSLServerSocket.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <openssl/ssl.h>
#include <native_common.h>
#include <errno.h>

typedef struct S_sock_ {
     int sock;
     int timeout;
     c_SSLContext *ctx;
} S_sock;

extern BIO *bio_err;

JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLServerSocket_close
  (JNIEnv *env, jobject thisObj)
  {
    S_sock *s;
    
    if(!(s=get_context(env,thisObj)))
      return;

    close(s->sock);
    free(s);
  }

JNIEXPORT void JNICALL Java_COM_claymore_sslg_openssl_SSLServerSocket_setSoTimeout
  (JNIEnv *env, jobject thisObj, jint timeout)
  {
    S_sock *s;
    
    if(!(s=get_context(env,thisObj)))
      return;

    s->timeout=timeout;
  }

JNIEXPORT jint JNICALL Java_COM_claymore_sslg_openssl_SSLServerSocket_getSoTimeout
  (JNIEnv *env, jobject thisObj)
  {
    S_sock *s;
    
    if(!(s=get_context(env,thisObj)))
      return(0);

    return(s->timeout);
  }

JNIEXPORT jlong JNICALL Java_COM_claymore_sslg_openssl_SSLServerSocket_nativeSSLServerSocket
  (JNIEnv *env, jobject thisObj, jobject ssl_ctx, jint port, jint backlog, jbyteArray listenAddr)
  {
    int sock=0;
    int val=1;
    jbyte *bptr=0;
    jboolean isCopy=0;
    struct sockaddr_in sin;
    u_int32_t in_addr;
    S_sock *s=0;
    EXCEPT_DECL;
    c_SSLContext *ctx;

    if(!(ctx=get_context(env,ssl_ctx)))
      THROW("java/lang/InternalError","Couldn't find SSL context");
    
    sock=socket(AF_INET, SOCK_STREAM, 0);
    if(sock<=0)
      THROW("java/lang/InternalError","Couldn't create socket");
    sin.sin_port=htons(port);
    sin.sin_family=AF_INET;
    if(listenAddr){
      bptr=(*env)->GetByteArrayElements(env,listenAddr, &isCopy);
      in_addr=(bptr[0]<<24) | (bptr[1] << 16) | (bptr[2] << 8) |
	bptr[3];
      sin.sin_addr.s_addr=in_addr;
    }
    else {
      sin.sin_addr.s_addr=INADDR_ANY;
    }
    
    setsockopt(sock,SOL_SOCKET,SO_REUSEADDR,(void *)&val, sizeof(val));
    if(bind(sock,(struct sockaddr *)&sin,sizeof(sin))<0)
      THROW("java/io/IOException","Couldn't bind socket");
    if(listen(sock,backlog)<0)
      THROW("java/io/IOException","Couldn't listen on socket");      
    if(!(s=(S_sock *)calloc(sizeof(S_sock),1)))
      THROW("java/io/InternalError","Couldn't allocate socket struct");
    s->sock=sock;
    s->timeout=0;
    s->ctx=ctx;

 thrown:
    if(bptr && isCopy)
      free(bptr);

    if(_exception){
      close(sock);
      throw_exception(env,thisObj,_exception,_msg);
      s=0;
    }
    
    return((long)s);
  }


JNIEXPORT jlong JNICALL Java_COM_claymore_sslg_openssl_SSLServerSocket_nativeAccept
  (JNIEnv *env, jobject thisObj)
  {
    S_sock *s;
    struct sockaddr_in addr;
    int addrlen=sizeof(addr);
    int r;
    int ns;
    SSL *ssl;
    EXCEPT_DECL;
    c_SSLSocket *sock=0;
    
    if(!(s=get_context(env,thisObj)))
      return(0);

    /*TODO: Add timeouts*/
    if((ns=accept(s->sock,(struct sockaddr *)&addr,&addrlen))<0){
      printf("Error number %d\n",errno);
      THROW("java/io/IOException","Accept failure");
    }
    
    if(!(sock=(c_SSLSocket *)calloc(sizeof(c_SSLSocket),1)))
      THROW("java/lang/InternalError","Couldn't allocate c_SSLSocket");

    if(!(ssl=SSL_new(s->ctx->ctx)))
      THROW("java/lang/InternalError","Couldn't make SSL object");
    SSL_set_fd(ssl,ns);
    if((r=SSL_accept(ssl))<0){
      ERR_print_errors(bio_err);
      THROW("java/io/IOException","Problem accepting");
    }

    SSL_set_shutdown(ssl,0);

    sock->ssl=ssl;
    sock->sock=ns;
    
  thrown:
    if(_exception){
      if(sock)
	free(sock);
      return(0);
    }
    EXCEPT_HANDLE;
    return((long)sock);
  }
  

    




