/**
   native_common.c

   Copyright (C) 1999, RTFM, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Wed Jun  9 14:36:57 1999
 */


static char *RCSSTRING="$Id: native_common.c,v 1.1.1.1 1999/06/17 18:49:02 ekr Exp $";

#include <jni.h>
#include <native_common.h>

void *get_context(JNIEnv *env,jobject thisObj)
  {
    jclass clazz;
    jfieldID fid;
    jlong val;

    clazz=(*env)->GetObjectClass(env,thisObj);
    fid=(*env)->GetFieldID(env,clazz,"_ptr","J");
    val=(*env)->GetLongField(env,thisObj, fid);
    
    if(!val){
      throw_exception(env,thisObj,"java/lang/InternalError",
	"Context not found");
      return(0);
    }
	   
    return((void *)val);
  }

void throw_exception(JNIEnv *env,jobject thisObj,char *except_type,
  char *msg)
  {
    jclass clazz;
    jmethodID mid;
    jthrowable throwObj;
    
    clazz=(*env)->FindClass(env,except_type);
    mid=(*env)->GetMethodID(env,clazz,"<init>","()V");
    throwObj=(jthrowable)(*env)->NewObject(env,clazz,mid);

    (*env)->Throw(env,throwObj);
  }
