/*
 *	des64.i - contains the fixed permutation and substitution tables 
 *			for a 64 bit DES implementation
 *	  see "AS2805.5-1985 DEA" for table definitions and explanations
 *
 *  Author:	Lawrence Brown <lpb@csadfa.oz>		Dec 1987
 *		Computer Science, UC UNSW, ADFA, Canberra, ACT 2600, Australia.
 *
 *	RCS ID: $Header: des64.i,v 2.1 90/07/18 10:55:30 lpb Exp $
 *
 *  Copyright 1988 by Lawrence Brown and CITRAD. All rights reserved.
 *      This program may not be sold or used as inducement to buy a
 *      product without the written permission of the author.
 *
 *	nb: if this program is compiled on a little-endian machine (eg Vax)
 *		#define LITTLE_ENDIAN
 *		in order to enable the byte swapping  routines 
 *
 *	    if compiled on a machine requiring strict alignment of words/longs
 *		and cannot guarantee that the 8 char blocks passed are aligned
 *		#define STRICT_ALIGN
 *
 *	    if a detailed trace of DES function f is required for debugging
 *		#define TRACE
 *
 */

char IP[64]				/* initial permutation P	*/
= {	58, 50, 42, 34, 26, 18, 10,  2,
	60, 52, 44, 36, 28, 20, 12,  4,
	62, 54, 46, 38, 30, 22, 14,  6,
	64, 56, 48, 40, 32, 24, 16,  8,
	57, 49, 41, 33, 25, 17,  9,  1,
	59, 51, 43, 35, 27, 19, 11,  3,
	61, 53, 45, 37, 29, 21, 13,  5,
	63, 55, 47, 39, 31, 23, 15,  7	};

char FP[64]				/* final permutation F	  */
= {	40,  8, 48, 16, 56, 24, 64, 32,
	39,  7, 47, 15, 55, 23, 63, 31,
	38,  6, 46, 14, 54, 22, 62, 30,
	37,  5, 45, 13, 53, 21, 61, 29,
	36,  4, 44, 12, 52, 20, 60, 28,
	35,  3, 43, 11, 51, 19, 59, 27,
	34,  2, 42, 10, 50, 18, 58, 26,
	33,  1, 41,  9, 49, 17, 57, 25	};


char E[48] = {	32,  1,  2,  3,  4,  5,		/* expansion operation matrix */
		 4,  5,  6,  7,  8,  9,
		 8,  9, 10, 11, 12, 13,	
		12, 13, 14, 15, 16, 17,
		16, 17, 18, 19, 20, 21,
		20, 21, 22, 23, 24, 25,
		24, 25, 26, 27, 28, 29,
		28, 29, 30, 31, 32,  1  };

char PC1[56]	/* permuted choice table (key)  */
= {	57, 49, 41, 33, 25, 17,  9,
	 1, 58, 50, 42, 34, 26, 18,
	10,  2, 59, 51, 43, 35, 27,
	19, 11,  3, 60, 52, 44, 36,
	63, 55, 47, 39, 31, 23, 15,
	 7, 62, 54, 46, 38, 30, 22,
	14,  6, 61, 53, 45, 37, 29,
	21, 13,  5, 28, 20, 12,  4 };

char PC2[48]					/* permuted choice key (table)*/
= {	14, 17, 11, 24,  1,  5,
	 3, 28, 15,  6, 21, 10,
	23, 19, 12,  4, 26,  8,
	16,  7, 27, 20, 13,  2,
	41, 52, 31, 37, 47, 55,
	30, 40, 51, 45, 33, 48,
	44, 49, 39, 56, 34, 53,
	46, 42, 50, 36, 29, 32	};

char P[32]				/* 32-bit permutation function P */
= {	16,  7, 20, 21,
	29, 12, 28, 17,
	 1, 15, 23, 26,
	 5, 18, 31, 10,
	 2,  8, 24, 14,
	32, 27,  3,  9,
	19, 13, 30,  6,
	22, 11,  4, 25	};

char keyrot[ROUNDS]			   	/* key rotation schedule      */
= {	1,1,2,2,2,2,2,2,1,2,2,2,2,2,2,1	};

/*
 *	perms is the table of descriptors describing each permutation to be
 *		compiled into a macro by desgen.  Fields are: 
 *		{ fn name, permutation table ptr,
 *		  # output words, type of output words, MSB used, # bits/word
 *		  # input words, type of input words, MSB used, # bits/word }
 *
 */

#ifdef STRICT_ALIGN /* strict alignment needed, blocks are char arrays */
char	  *des64_vers = "strict alignment required, input blocks are chars";
sp_desc   perms[] = {
    { "ip",  IP,  2, "Long", 31, 32,  8, "char",  7,  8, O_REG},
    { "fp",  FP,  8, "char",  7,  8,  2, "Long", 31, 32, I_REG},
    {"pc1", PC1,  2, "Long", 31, 28,  8, "char",  7,  8, O_REG},
    {"pc2", PC2,  2, "Long", 23, 24,  2, "Long", 31, 28, I_REG},
    {   0,    0,  0,      0,  0,  0,  0,      0,  0,  0, 0}
   };

#else STRICT_ALIGN /* blocks are char arrays cast to Longs, may need bswap  */
char	   *des64_vers = "input blocks are chars, but loaded as Long,\n may cause alignment problems - may need byte swapping";
sp_desc    perms[] = {
    { "ip",  IP,  2, "Long", 31, 32,  2, "Long", 31, 32, O_REG|I_ALIGN},
    { "fp",  FP,  2, "Long", 31, 32,  2, "Long", 31, 32, I_REG|O_ALIGN},
    {"pc1", PC1,  2, "Long", 31, 28,  2, "Long", 31, 32, O_REG|I_ALIGN},
    {"pc2", PC2,  2, "Long", 23, 24,  2, "Long", 31, 28, I_REG},
    {   0,    0,  0,      0,  0,  0,  0,      0,  0,  0, 0}
   };
#endif STRICT_ALIGN

char S[8][64]			/* S-Boxes: 48->32 bit compression tables     */
				/* nb: DES bits (16) select row in each table */
				/*     DES bits (2345) select column in row   */
= {					/* S[1]			 */
	14,  4, 13,  1,  2, 15, 11,  8,  3, 10,  6, 12,  5,  9,  0,  7,
	 0, 15,  7,  4, 14,  2, 13,  1, 10,  6, 12, 11,  9,  5,  3,  8,
	 4,  1, 14,  8, 13,  6,  2, 11, 15, 12,  9,  7,  3, 10,  5,  0,
	15, 12,  8,  2,  4,  9,  1,  7,  5, 11,  3, 14, 10,  0,  6, 13,
					/* S[2]			 */
	15,  1,  8, 14,  6, 11,  3,  4,  9,  7,  2, 13, 12,  0,  5, 10,
	 3, 13,  4,  7, 15,  2,  8, 14, 12,  0,  1, 10,  6,  9, 11,  5,
	 0, 14,  7, 11, 10,  4, 13,  1,  5,  8, 12,  6,  9,  3,  2, 15,
	13,  8, 10,  1,  3, 15,  4,  2, 11,  6,  7, 12,  0,  5, 14,  9,
					/* S[3]			 */
	10,  0,  9, 14,  6,  3, 15,  5,  1, 13, 12,  7, 11,  4,  2,  8,
	13,  7,  0,  9,  3,  4,  6, 10,  2,  8,  5, 14, 12, 11, 15,  1,
	13,  6,  4,  9,  8, 15,  3,  0, 11,  1,  2, 12,  5, 10, 14,  7,
	 1, 10, 13,  0,  6,  9,  8,  7,  4, 15, 14,  3, 11,  5,  2, 12,
					/* S[4]			 */
	 7, 13, 14,  3,  0,  6,  9, 10,  1,  2,  8,  5, 11, 12,  4, 15,
	13,  8, 11,  5,  6, 15,  0,  3,  4,  7,  2, 12,  1, 10, 14,  9,
	10,  6,  9,  0, 12, 11,  7, 13, 15,  1,  3, 14,  5,  2,  8,  4,
	 3, 15,  0,  6, 10,  1, 13,  8,  9,  4,  5, 11, 12,  7,  2, 14,
					/* S[5]			 */
	 2, 12,  4,  1,  7, 10, 11,  6,  8,  5,  3, 15, 13,  0, 14,  9,
	14, 11,  2, 12,  4,  7, 13,  1,  5,  0, 15, 10,  3,  9,  8,  6,
	 4,  2,  1, 11, 10, 13,  7,  8, 15,  9, 12,  5,  6,  3,  0, 14,
	11,  8, 12,  7,  1, 14,  2, 13,  6, 15,  0,  9, 10,  4,  5,  3,
					/* S[6]			 */
	12,  1, 10, 15,  9,  2,  6,  8,  0, 13,  3,  4, 14,  7,  5, 11,
	10, 15,  4,  2,  7, 12,  9,  5,  6,  1, 13, 14,  0, 11,  3,  8,
	 9, 14, 15,  5,  2,  8, 12,  3,  7,  0,  4, 10,  1, 13, 11,  6,
	 4,  3,  2, 12,  9,  5, 15, 10, 11, 14,  1,  7,  6,  0,  8, 13,
					/* S[7]			 */
	 4, 11,  2, 14, 15,  0,  8, 13,  3, 12,  9,  7,  5, 10,  6,  1,
	13,  0, 11,  7,  4,  9,  1, 10, 14,  3,  5, 12,  2, 15,  8,  6,
	 1,  4, 11, 13, 12,  3,  7, 14, 10, 15,  6,  8,  0,  5,  9,  2,
	 6, 11, 13,  8,  1,  4, 10,  7,  9,  5,  0, 15, 14,  2,  3, 12,
					/* S[8]			 */
	13,  2,  8,  4,  6, 15, 11,  1, 10,  9,  3, 14,  5,  0, 12,  7,
	 1, 15, 13,  8, 10,  3,  7,  4, 12,  5,  6, 11,  0, 14,  9,  2,
	 7, 11,  4,  1,  9, 12, 14,  2,  0,  6, 10, 13, 15,  3,  5,  8,
	 2,  1, 14,  7,  4, 10,  8, 13, 15, 12,  9,  0,  3,  5,  6, 11	};


/*
 *	spboxes - is a descriptor describing the S-boxes  & P permutation used
 *		  for use by the desgen program
 *		- this version can merges in expansion function E also
 */
#ifdef PATH48
sp_desc	spboxes[] = {
	{ "SPE",   0,	1, "Long", 31, 32,	8, "char",  5,  6, 0},
    	{  "P",   P,	1, "Long", 31, 32,	1, "Long", 31, 32, O_PE},
    	{  "E",   E,	2, "Long", 23, 24,	1, "Long", 31, 32, 0},
    	{    0,   0,	0,      0,  0,  0,	0,      0,  0,  0, 0}
     };

#else
sp_desc	spboxes[] = {
	{ "SP",   0,	1, "Long", 31, 32,	8, "char",  5,  6, 0},
    	{  "P",   P,	1, "Long", 31, 32,	1, "Long", 31, 32, 0},
    	{    0,   0,	0,      0,  0,  0,	0,      0,  0,  0, 0}
     };
#endif
