//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : lattice_basis.h 
// Author      : Werner Backes (WB), Thorsten Lauer (TL) 
// Last change : WB/TL, Feb 10 1995, initial version
//

#ifndef _lattice_basis_h
#define _lattice_basis_h

#include <LiDIA/lattice_gensys.h>

class lattice_basis: public lattice_gensys
{
  public :

//
// Constructors / Destructor
//

    lattice_basis(long, long);
    lattice_basis(long, long, double**);
    lattice_basis(long, long, bigint**);
    lattice_basis(long, long, bigfloat**);
    lattice_basis(const lattice_basis&);
    lattice_basis(const bigint_matrix&);
    virtual ~lattice_basis() { };

//
// Conversion
//

    int make_basis(lattice_gensys);

//
// Algorithms
//

    void lll();
    void lll(const lattice_basis&);
    void lll_trans(lattice_basis&);

    void gram_schmidt_orth();
    void gram_schmidt_orth(const lattice_basis&);

    int lll_check(double);
    double lll_check();

    friend void lll(bigint_matrix&, const bigint_matrix&);
    friend void lll_trans(bigint_matrix&, const bigint_matrix&);


  protected :
    virtual void compute_precision(); 
    virtual void check_basis();

  private :

//
// private functions used for direct access 
//

    void lll_mbi(bigint_matrix&);
    void lll_trans_mbi(bigint_matrix&);
};

#endif





