//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : lidia.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_H
#define LIDIA_H

#include <LiDIA/config.h>

/**
 ** include system files
 **/

#include <iostream.h>
#include <fstream.h>

#ifdef HAVE_STDLIB_H
#ifdef __GNUG__
#include <stdlib.h>
#endif
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_MATH_H
#include <math.h>
#endif

#ifdef HAVE_CTYPE_H
#include <ctype.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#ifdef HAVE_UNISTD_H 
#include <unistd.h>
#endif

#ifdef HAVE_TIME_H
#include <time.h>
#endif

#ifdef HAVE_TIMES_H
#include <times.h>
#endif

#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif

#ifdef HAVE_SYS_TIMES_H
#include <sys/times.h>
#endif

#ifdef HAVE_RESOURCE_H
#include <resource.h>
#endif

#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

#if defined(__EMX__)
#include <sys/param.h>
#endif

#if !defined (HZ) && defined(CLK_TCK)
#define HZ CLK_TCK
#endif

/**
 ** include LiDIA system files
 **/

#include <LiDIA/warning.h>
#include <LiDIA/error.h>
#include <LiDIA/debug.h>
#include <LiDIA/memory.h>

/**
 ** these are the types for machine integers
 **/

typedef          long sdigit;
typedef unsigned long udigit;

/**
 ** LEDA compatability
 ** ------------------
 ** if LiDIA is compiled with LEDA, we assume that the user uses
 ** LEDA bools and macros.
 **/

#ifdef HAVE_LEDA
#define LIDIA_BUILTIN_BOOL
#define LIDIA_MACROS
#endif

/**
 ** definition of the type bool. gcc-2.6.x and Macintosh
 ** supports the type bool.
 **/

#if (__GNUC__ > 1 && __GNUC_MINOR__ > 5) || defined(__MWERKS__)
#ifndef  LIDIA_BUILTIN_BOOL
#define LIDIA_BUILTIN_BOOL
#endif
#endif
#if !defined(LIDIA_BUILTIN_BOOL)
typedef char bool;
enum {false=0, true=1};
#endif

/**
 ** LiDIA macros
 **/

#ifndef LIDIA_MACROS
#define LIDIA_MACROS
#define nil      0
#define newline  cout << "\n"
#define forever  for (;;)
#endif

#endif
