//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : timer.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_TIMER_H
#define LIDIA_TIMER_H

#include <LiDIA/lidia.h>

#define TIME_MODE 0
#define HMS_MODE 1

class timer 
{
  private:

#ifdef HAVE_GETRUSAGE
  static struct rusage buffer;
#else
  static struct tms buffer;
#endif

  long user_t, sys_t;
  long t_user_t, t_sys_t;
  int print_mode;

  void print_hms(long);

  public:

  timer();
  ~timer();

  int set_print_mode(int x = 1);
  int get_print_mode();

  void start_timer(); 
  void stop_timer(); 
  void cont_timer(); 

  long user_time();
  long sys_time();
  long real_time();

  void print();
  
  friend ostream & operator << (ostream & out, timer & t)
    { t.print(); return out; }

};

#endif



