# Test some sequence primitives.
# This also indirectly tests a bunch of other stuff.

# :count=NEW
# count:=0

:|(check :message :x :y)=
  if x=y => (stderr printf "OK: %s\n" message) || (stderr printf "ERROR: %s <%s;%s>\n" message x y)

check "by_take" ((-3 by 2) take 10) [-3 -1 1 3 5 7 9 11 13 15]
check "inx" ((10 to 20) [3 5 4]) [13 15 14]
check "SeqAdd2" ([3 4 5] + [100 200 300 400]) [103 204 305]
check "shape" (shape [3 4 5]) [3]
check "shape" (shape 12) []
check "drop_c1" (("abcdefghi" drop 3) take 4) "defg"
check "drop_c2" ("abcdefghi" drop -3) "abcdef"
check "drop_c3" (("abcdefghi" drop -3) take 4) "abcd"
check "drop_c4" (("abcdefghi" drop -3) take -4) "cdef"

check "reduce1" ([3 4 5] @+) 12
check "reduce2" (+@ [3 4 5]) 12
check "reduce3" ([3 4 5] @-) 4
check "reduce4" ([3 4 5] @- 0) 4
check "reduce5" (-@ [3 4 5]) -6
check "reduce6" (0 -@ [3 4 5]) -12

check "sort1" ([9 3 4 21 6 6 1 5 -1] sort) [-1 1 3 4 5 6 6 9 21]

# C-style formatting:
check "cprintfd1" (sprintf "[%3d]" 5 6) "[  5]"
check "cprintfd2" (sprintf "[%08d]" [5 6]) "[00000005 00000006]"
check "cprintfd3" (sprintf "[%-4d]" 56) "[56  ]"
check "cprintfs1" (sprintf "<~%s::%s~>" "abc" 345) "<~abc::345~>"
check "cprintfs2" (sprintf "[%-4s]" 56) "[56  ]"
check "cprintfs3" (sprintf "[%8s]" [5 6]) "[     5 6]"
check "cprintfr1" (sprintf "[%16r]" 257) "[101]"
check "cprintfr2" (sprintf "[%16.8r]" 257) "[     101]"
check "cprintfr3" (sprintf "[%16.025r]" 20988295476557333863) "[0000000012345678901234567]"
check "cprintfr4" (sprintf "[%16.-5r]" 257) "[101  ]"
check "cprintfr5" (sprintf "[%#16r]" 257) "[0x101]"

#(
# Obfuscated Dinner anouncement from Paul Asente, translated into Q
:dcode=[175482890 111906898 67984692 182088439 163387168 213685792 142178164 22
2016416 219936880 222023763 232601582 205230145 222007379 212466080 142226668]
:(pcode :i)= a. ((dcode (i/4 floor)) (byte 7 7*(i mod 4)))
# check "DinDin" ({pcode ?} (59 downto 0)) "Chile's in San Antonio Shopping Center, Mt. View 5:45. RSVP\n"
:(chartoint :x)= ((0 for 256) where {a.? = x})0

:F = "qwertyuiopasdfghj" open
#)
